/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.tools.idea.run.activity.manifest.IntentFilter;
import com.android.tools.idea.run.activity.manifest.ManifestActivityInfo;
import com.android.tools.idea.run.activity.manifest.NodeActivity;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DefaultApkActivityLocator
extends ActivityLocator {
    private static final Logger LOG = Logger.getInstance(DefaultApkActivityLocator.class);
    private final ApkProvider myApkProvider;

    public DefaultApkActivityLocator(@NotNull ApkProvider apkProvider) {
        this.myApkProvider = apkProvider;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        Collection<ApkInfo> apks;
        try {
            apks = this.myApkProvider.getApks(device);
        }
        catch (Exception e) {
            throw new ActivityLocator.ActivityLocatorException("Unable to list apks", e);
        }
        if (apks.isEmpty()) {
            throw new ActivityLocator.ActivityLocatorException("No APKs provided. Unable to extract default activity");
        }
        String defaultActivity = DefaultApkActivityLocator.computeDefaultActivityFromApks(apks);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        return defaultActivity;
    }

    private static String computeDefaultActivityFromApks(@NotNull Collection<ApkInfo> apks) {
        if (apks.size() != 1) {
            StringBuilder errorMessage = new StringBuilder("Unable to extract Default Activity\n");
            errorMessage.append("Received projects:\n");
            for (ApkInfo apkInfo : apks) {
                errorMessage.append("  " + apkInfo.getApplicationId() + " containing :\n" + apkInfo.getFiles());
                for (ApkFileUnit fileUnit : apkInfo.getFiles()) {
                    errorMessage.append("    " + fileUnit.getApkFile());
                }
            }
            throw new IllegalStateException(errorMessage.toString());
        }
        ArrayList<NodeActivity> activities = new ArrayList<NodeActivity>();
        ApkInfo apkInfo = apks.iterator().next();
        for (ApkFileUnit apkFileUnit : apkInfo.getFiles()) {
            File file2 = apkFileUnit.getApkFile();
            String ext = file2.getName().toLowerCase(Locale.US);
            if (!ext.endsWith(".apk")) continue;
            try {
                ZipFile zipFile = new ZipFile(file2);
                Throwable throwable = null;
                try {
                    ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
                    if (manifestEntry == null) continue;
                    InputStream input = zipFile.getInputStream(manifestEntry);
                    Throwable throwable2 = null;
                    try {
                        ManifestActivityInfo manifest = ManifestActivityInfo.parseBinaryFromStream(input);
                        activities.addAll(manifest.activities());
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable2 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to parse '" + file2.getName() + "' for default activity", (Throwable)e);
            }
        }
        String defaultActivityName = DefaultActivityLocator.computeDefaultActivity(activities);
        if (defaultActivityName == null) {
            StringBuilder errorMessage = new StringBuilder("Unable to find Default Activity in:\n");
            DefaultApkActivityLocator.printActivities(activities, errorMessage);
            LOG.info(errorMessage.toString());
        }
        return defaultActivityName;
    }

    private static void printActivities(List<NodeActivity> activities, StringBuilder message2) {
        for (NodeActivity activity : activities) {
            message2.append("  " + activity.getQualifiedName() + ":\n");
            for (IntentFilter intent : activity.getIntentFilters()) {
                for (String action2 : intent.getActions()) {
                    message2.append("    " + action2 + "\n");
                }
                for (String category : intent.getCategories()) {
                    message2.append("    " + category + "\n");
                }
            }
        }
    }
}

