/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DefaultActivityLocatorStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultActivityLocator
extends ActivityLocator {
    private static final Logger LOG = Logger.getInstance(DefaultActivityLocator.class);
    @NotNull
    private final AndroidFacet myFacet;

    public DefaultActivityLocator(@NotNull AndroidFacet facet2) {
        this.myFacet = facet2;
    }

    @Override
    @Slow
    @WorkerThread
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        assert (!this.myFacet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        String defaultActivity = DefaultActivityLocator.computeDefaultActivityWithDevicePreference(DefaultActivityLocator.getActivitiesFromMergedManifest(this.myFacet), device);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        return defaultActivity;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        assert (!this.myFacet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        StudioFlags.DefaultActivityLocatorStrategy strategy = (StudioFlags.DefaultActivityLocatorStrategy)StudioFlags.DEFAULT_ACTIVITY_LOCATOR_STRATEGY.get();
        if (strategy == StudioFlags.DefaultActivityLocatorStrategy.INDEX && AndroidManifestIndex.indexEnabled().booleanValue()) {
            if (DumbService.isDumb((Project)this.myFacet.getModule().getProject())) {
                return;
            }
            List<ActivityWrapper> activities = DefaultActivityLocator.getActivitiesFromManifestIndex(this.myFacet);
            if (DefaultActivityLocator.computeDefaultActivity(activities) == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
            }
            return;
        }
        boolean usePotentiallyStaleManifest = ApplicationManager.getApplication().isDispatchThread();
        MergedManifestSnapshot mergedManifest = DefaultActivityLocator.getMergedManifest(this.myFacet, usePotentiallyStaleManifest);
        List<Object> activities = mergedManifest == null ? Collections.emptyList() : ActivityWrapper.get(mergedManifest.getActivities(), mergedManifest.getActivityAliases());
        String defaultActivity = DefaultActivityLocator.computeDefaultActivity(activities);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
    }

    @VisibleForTesting
    public static List<ActivityWrapper> getActivitiesFromMergedManifest(@NotNull AndroidFacet facet2) {
        StudioFlags.DefaultActivityLocatorStrategy strategy = (StudioFlags.DefaultActivityLocatorStrategy)StudioFlags.DEFAULT_ACTIVITY_LOCATOR_STRATEGY.get();
        if (strategy == StudioFlags.DefaultActivityLocatorStrategy.INDEX && AndroidManifestIndex.indexEnabled().booleanValue()) {
            return (List)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(() -> DefaultActivityLocator.getActivitiesFromManifestIndex(facet2));
        }
        boolean onEdt = ApplicationManager.getApplication().isDispatchThread();
        boolean usePotentiallyStaleManifest = onEdt && strategy == StudioFlags.DefaultActivityLocatorStrategy.STALE;
        Stopwatch timer2 = Stopwatch.createStarted();
        MergedManifestSnapshot mergedManifest = DefaultActivityLocator.getMergedManifest(facet2, usePotentiallyStaleManifest);
        List<ActivityWrapper> activities = mergedManifest == null ? Collections.emptyList() : ActivityWrapper.get(mergedManifest.getActivities(), mergedManifest.getActivityAliases());
        DefaultActivityLocator.logManifestLatency(onEdt, false, usePotentiallyStaleManifest, timer2.elapsed(TimeUnit.MILLISECONDS));
        return activities;
    }

    @NotNull
    private static List<ActivityWrapper> getActivitiesFromManifestIndex(@NotNull AndroidFacet facet2) {
        boolean onEdt = ApplicationManager.getApplication().isDispatchThread();
        Stopwatch timer2 = Stopwatch.createStarted();
        List<ActivityWrapper> activityWrappers = AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(facet2).getJoined();
        DefaultActivityLocator.logManifestLatency(onEdt, true, false, timer2.elapsed(TimeUnit.MILLISECONDS));
        return activityWrappers;
    }

    private static void logManifestLatency(boolean blocksUiThread, boolean indexBased, boolean usedPotentiallyStaleManifest, long latencyMs) {
        AndroidStudioEvent.Builder proto = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEFAULT_ACTIVITY_LOCATOR_STATS).setDefaultActivityLocatorStats(DefaultActivityLocatorStats.newBuilder().setBlocksUiThread(blocksUiThread).setIndexBased(indexBased).setUsedPotentiallyStaleManifest(usedPotentiallyStaleManifest).setLatencyMs(latencyMs));
        UsageTracker.log((AndroidStudioEvent.Builder)proto);
    }

    @Nullable
    public static String getDefaultLauncherActivityName(@NotNull Project project, @NotNull Manifest manifest) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> DefaultActivityLocator.getDefaultLauncherActivityName(project, manifest));
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && DumbService.isDumb((Project)project)) {
            LOG.warn("Cannot locate default activity when indices are not available");
            return null;
        }
        return DefaultActivityLocator.computeDefaultActivity(DefaultActivityLocator.merge(application.getActivities(), application.getActivityAliases()));
    }

    @Nullable
    public static String computeDefaultActivity(@NotNull List<? extends ActivityWrapper> activities) {
        List<ActivityWrapper> launchableActivities = DefaultActivityLocator.getLaunchableActivities(activities);
        if (launchableActivities.isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.get(0).getQualifiedName();
    }

    @Slow
    @WorkerThread
    @Nullable
    public static String computeDefaultActivityWithDevicePreference(@NotNull List<ActivityWrapper> activities, @NotNull IDevice device) {
        List<ActivityWrapper> launchableActivities = DefaultActivityLocator.getLaunchableActivities(activities);
        if (launchableActivities.isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        ActivityWrapper activity = DefaultActivityLocator.findLauncherActivityForDevice(launchableActivities, device);
        if (activity != null) {
            return activity.getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.get(0).getQualifiedName();
    }

    @Slow
    @WorkerThread
    @Nullable
    private static ActivityWrapper findLauncherActivityForDevice(@NotNull List<ActivityWrapper> launchableActivities, @NotNull IDevice device) {
        if (device.supportsFeature(IDevice.HardwareFeature.TV)) {
            return DefaultActivityLocator.findLeanbackLauncher(launchableActivities);
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findLeanbackLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        for (ActivityWrapper activity : launcherActivities) {
            if (!activity.hasCategory("android.intent.category.LEANBACK_LAUNCHER")) continue;
            return activity;
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findDefaultLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        for (ActivityWrapper activity : launcherActivities) {
            if (!activity.hasCategory("android.intent.category.DEFAULT")) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    private static List<ActivityWrapper> getLaunchableActivities(@NotNull List<? extends ActivityWrapper> allActivities) {
        List<ActivityWrapper> launchableActivities = allActivities.stream().filter(activity -> ActivityLocatorUtils.containsLauncherIntent(activity) && activity.isEnabled()).collect(Collectors.toList());
        if (launchableActivities.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("No launchable activities found, total # of activities: " + allActivities.size());
            allActivities.forEach(wrapper -> LOG.debug(String.format("activity: %1$s, isEnabled: %2$s, containsLauncherIntent: %3$s", wrapper.getQualifiedName(), wrapper.isEnabled(), ActivityLocatorUtils.containsLauncherIntent(wrapper))));
        }
        return launchableActivities;
    }

    private static List<ActivityWrapper> merge(List<Activity> activities, List<ActivityAlias> activityAliases) {
        ArrayList activityWrappers = Lists.newArrayListWithExpectedSize((int)(activities.size() + activityAliases.size()));
        for (Activity activity : activities) {
            activityWrappers.add(ActivityWrapper.get(activity));
        }
        for (ActivityAlias activityAlias : activityAliases) {
            activityWrappers.add(ActivityWrapper.get(activityAlias));
        }
        return activityWrappers;
    }

    private static class ElementActivityWrapper
    extends ActivityWrapper {
        private final Element myActivity;

        public ElementActivityWrapper(Element activity) {
            this.myActivity = activity;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            for (Node node2 = this.myActivity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Element filter2;
                if (node2.getNodeType() != 1 || !"intent-filter".equals(node2.getNodeName()) || !ActivityLocatorUtils.containsCategory(filter2 = (Element)node2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            for (Node node2 = this.myActivity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Element filter2;
                if (node2.getNodeType() != 1 || !"intent-filter".equals(node2.getNodeName()) || !ActivityLocatorUtils.containsAction(filter2 = (Element)node2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            String enabledAttr = this.myActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "enabled");
            return StringUtil.isEmpty((String)enabledAttr) || Boolean.valueOf(enabledAttr) != false || enabledAttr.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            String exportedAttr = this.myActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
            return StringUtil.isEmpty((String)exportedAttr) ? null : Boolean.valueOf(exportedAttr);
        }

        @Override
        public boolean hasIntentFilter() {
            for (Node node2 = this.myActivity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !"intent-filter".equals(node2.getNodeName())) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }
    }

    private static class ActivityAliasWrapper
    extends ActivityWrapper {
        private final ActivityAlias myAlias;

        public ActivityAliasWrapper(ActivityAlias activityAlias) {
            this.myAlias = activityAlias;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            for (IntentFilter filter2 : this.myAlias.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            for (IntentFilter filter2 : this.myAlias.getIntentFilters()) {
                if (!AndroidDomUtil.containsAction(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            AndroidAttributeValue<String> enabled = this.myAlias.getEnabled();
            if (enabled == null) {
                return true;
            }
            String stringValue = enabled.getStringValue();
            return stringValue == null || Boolean.valueOf(stringValue) != false || stringValue.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            AndroidAttributeValue<String> exported = this.myAlias.getExported();
            if (exported == null || exported.getValue() == null || ((String)exported.getValue()).isEmpty()) {
                return null;
            }
            return Boolean.valueOf((String)exported.getValue());
        }

        @Override
        public boolean hasIntentFilter() {
            return !this.myAlias.getIntentFilters().isEmpty();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myAlias);
        }
    }

    private static class RealActivityWrapper
    extends ActivityWrapper {
        private final Activity myActivity;

        public RealActivityWrapper(Activity activity) {
            this.myActivity = activity;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            for (IntentFilter filter2 : this.myActivity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            for (IntentFilter filter2 : this.myActivity.getIntentFilters()) {
                if (!AndroidDomUtil.containsAction(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            AndroidAttributeValue<String> enabled = this.myActivity.getEnabled();
            if (enabled == null) {
                return true;
            }
            String stringValue = enabled.getStringValue();
            return stringValue == null || Boolean.valueOf(stringValue) != false || stringValue.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            AndroidAttributeValue<String> exported = this.myActivity.getExported();
            if (exported == null || exported.getValue() == null || ((String)exported.getValue()).isEmpty()) {
                return null;
            }
            return Boolean.valueOf((String)exported.getValue());
        }

        @Override
        public boolean hasIntentFilter() {
            return !this.myActivity.getIntentFilters().isEmpty();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }
    }

    public static abstract class ActivityWrapper {
        public abstract boolean hasCategory(@NotNull String var1);

        public abstract boolean hasAction(@NotNull String var1);

        public abstract boolean isEnabled();

        @Nullable
        public abstract Boolean getExported();

        public boolean isLogicallyExported() {
            return Boolean.TRUE.equals(this.getExported()) || this.hasIntentFilter();
        }

        public abstract boolean hasIntentFilter();

        @Nullable
        public String getTheme() {
            throw new UnsupportedOperationException("An activity theme name is not tracked");
        }

        @Nullable
        public abstract String getQualifiedName();

        public static ActivityWrapper get(@NotNull Activity activity) {
            return new RealActivityWrapper(activity);
        }

        public static ActivityWrapper get(@NotNull ActivityAlias activityAlias) {
            return new ActivityAliasWrapper(activityAlias);
        }

        public static ActivityWrapper get(@NotNull Element activityOrAlias) {
            return new ElementActivityWrapper(activityOrAlias);
        }

        public static List<ActivityWrapper> get(@NotNull List<Element> activities, @NotNull List<Element> aliases) {
            ArrayList list = Lists.newArrayListWithCapacity((int)(activities.size() + aliases.size()));
            for (Element element2 : activities) {
                list.add(new ElementActivityWrapper(element2));
            }
            for (Element element2 : aliases) {
                list.add(new ElementActivityWrapper(element2));
            }
            return list;
        }
    }
}

