/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericBuiltArtifactsLoader;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeTestedTargetVariant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.impl.ModelCache;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.BestOutputFinder;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;
    @NotNull
    private final BestOutputFinder myBestOutputFinder;
    private final boolean myTest;
    private Function<AndroidVersion, OutputKind> myOutputKindProvider;
    public static final Key<PostBuildModel> POST_BUILD_MODEL = Key.create((String)"com.android.tools.idea.post_build_model");

    public GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test, @NotNull Function<AndroidVersion, OutputKind> outputKindProvider) {
        this(facet2, applicationIdProvider, outputModelProvider, new BestOutputFinder(), test, outputKindProvider);
    }

    @VisibleForTesting
    public GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, boolean test) {
        this(facet2, applicationIdProvider, () -> null, test, version2 -> OutputKind.Default);
    }

    @VisibleForTesting
    public GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test) {
        this(facet2, applicationIdProvider, outputModelProvider, new BestOutputFinder(), test, version2 -> OutputKind.Default);
    }

    @VisibleForTesting
    GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, @NotNull BestOutputFinder bestOutputFinder, boolean test, Function<AndroidVersion, OutputKind> outputKindProvider) {
        this.myFacet = facet2;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myOutputModelProvider = outputModelProvider;
        this.myBestOutputFinder = bestOutputFinder;
        this.myTest = test;
        this.myOutputKindProvider = outputKindProvider;
    }

    OutputKind getOutputKind(@Nullable AndroidVersion targetDevicesMinVersion) {
        return this.myOutputKindProvider.apply(targetDevicesMinVersion);
    }

    boolean isTest() {
        return this.myTest;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        return this.getApks(device.getAbis(), device.getVersion());
    }

    @VisibleForTesting
    @NotNull
    public List<ApkInfo> getApks(List<String> deviceAbis, AndroidVersion deviceVersion) throws ApkProvisionException {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null) {
            GradleApkProvider.getLogger().warn("Android model is null. Sync might have failed");
            return Collections.emptyList();
        }
        IdeVariant selectedVariant = androidModel.getSelectedVariant();
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        int projectType = androidModel.getAndroidProject().getProjectType();
        if (projectType == 0 || projectType == 4 || projectType == 2 || projectType == 6) {
            String pkgName;
            String string = pkgName = projectType == 2 ? this.myApplicationIdProvider.getTestPackageName() : this.myApplicationIdProvider.getPackageName();
            if (pkgName == null) {
                GradleApkProvider.getLogger().warn("Package name is null. Sync might have failed");
                return Collections.emptyList();
            }
            switch (this.myOutputKindProvider.apply(deviceVersion)) {
                case Default: {
                    ArrayList<ApkFileUnit> apkFileList = new ArrayList<ApkFileUnit>();
                    apkFileList.add(new ApkFileUnit(androidModel.getModuleName(), this.getApk(selectedVariant, deviceAbis, deviceVersion, this.myFacet, false)));
                    apkFileList.addAll(this.collectDependentFeaturesApks(androidModel, deviceAbis, deviceVersion));
                    apkList.add(new ApkInfo(apkFileList, pkgName));
                    break;
                }
                case AppBundleOutputModel: {
                    ApkInfo apkInfo;
                    Module baseAppModule = this.myFacet.getModule();
                    if (projectType == 6) {
                        baseAppModule = DynamicAppUtils.getBaseFeature(this.myFacet.getModule());
                    }
                    if (baseAppModule == null || (apkInfo = DynamicAppUtils.collectAppBundleOutput(baseAppModule, this.myOutputModelProvider, pkgName)) == null) break;
                    apkList.add(apkInfo);
                }
            }
        }
        apkList.addAll(GradleApkProvider.getAdditionalApks(selectedVariant.getMainArtifact()));
        if (this.myTest) {
            if (projectType == 2) {
                if (androidModel.getFeatures().isTestedTargetVariantsSupported()) {
                    apkList.addAll(0, this.getTargetedApks(selectedVariant, deviceAbis, deviceVersion));
                }
            } else {
                IdeAndroidArtifact testArtifactInfo = androidModel.getSelectedVariant().getAndroidTestArtifact();
                if (testArtifactInfo != null) {
                    File testApk = this.getApk(androidModel.getSelectedVariant(), deviceAbis, deviceVersion, this.myFacet, true);
                    String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                    assert (testPackageName != null);
                    apkList.add(new ApkInfo(testApk, testPackageName));
                    apkList.addAll(GradleApkProvider.getAdditionalApks(testArtifactInfo));
                }
            }
        }
        return apkList;
    }

    @NotNull
    private List<ApkFileUnit> collectDependentFeaturesApks(@NotNull AndroidModuleModel androidModel, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion) {
        IdeAndroidProject project = androidModel.getAndroidProject();
        return DynamicAppUtils.getDependentFeatureModulesForBase(this.myFacet.getModule().getProject(), project).stream().map(module2 -> {
            AndroidFacet featureFacet = AndroidFacet.getInstance((Module)module2);
            if (featureFacet == null) {
                return null;
            }
            AndroidModuleModel androidFeatureModel = AndroidModuleModel.get(featureFacet);
            if (androidFeatureModel == null) {
                return null;
            }
            IdeVariant selectedVariant = androidFeatureModel.getSelectedVariant();
            try {
                File apk = this.getApk(selectedVariant, deviceAbis, deviceVersion, featureFacet, false);
                return new ApkFileUnit(androidFeatureModel.getModuleName(), apk);
            }
            catch (ApkProvisionException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private static List<ApkInfo> getAdditionalApks(@NotNull IdeAndroidArtifact testArtifactInfo) {
        ArrayList<ApkInfo> result2 = new ArrayList<ApkInfo>();
        for (File fileApk : testArtifactInfo.getAdditionalRuntimeApks()) {
            try {
                String packageId = GradleApkProvider.getPackageId(fileApk);
                result2.add(new ApkInfo(fileApk, packageId));
            }
            catch (ApkProvisionException e) {
                GradleApkProvider.getLogger().error("Failed to get the package name from the given file. Therefore, we are not be able to install it. Please install it manually: " + fileApk.getName() + " error: " + e.getMessage(), (Throwable)e);
            }
        }
        return result2;
    }

    private static Path getPathToAapt() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return AaptInvoker.getPathToAapt((AndroidSdkHandler)handler2, (ILogger)new LogWrapper(GradleApkProvider.class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPackageId(@NotNull File fileApk) throws ApkProvisionException {
        try (ArchiveContext archiveContext = Archives.open((Path)fileApk.toPath());){
            AndroidApplicationInfo applicationInfo = ApkParser.getAppInfo(GradleApkProvider.getPathToAapt(), archiveContext.getArchive());
            if (applicationInfo == AndroidApplicationInfo.UNKNOWN) {
                throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName());
            }
            String string = applicationInfo.packageId;
            return string;
        }
        catch (IOException e) {
            throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName(), e.getCause());
        }
    }

    @VisibleForTesting
    @NotNull
    File getApk(@NotNull IdeVariant variant2, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, @NotNull AndroidFacet facet2, boolean fromTestArtifact) throws ApkProvisionException {
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet2);
        assert (androidModel != null);
        if (androidModel.getFeatures().isBuildOutputFileSupported()) {
            return this.getApkFromBuildOutputFile(androidModel, deviceAbis, fromTestArtifact);
        }
        if (androidModel.getFeatures().isPostBuildSyncSupported()) {
            return this.getApkFromPostBuildSync(variant2, deviceAbis, deviceVersion, facet2, fromTestArtifact);
        }
        return this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact);
    }

    @NotNull
    private File getApkFromBuildOutputFile(@NotNull AndroidModuleModel androidModel, @NotNull List<String> deviceAbis, boolean fromTestArtifact) throws ApkProvisionException {
        IdeVariant variant2 = androidModel.getSelectedVariant();
        String outputFile = GradleBuildOutputUtil.getOutputListingFile(androidModel, variant2.getName(), OutputType.Apk, fromTestArtifact);
        if (outputFile == null) {
            throw new ApkProvisionException("Cannot get output listing file name from the build model");
        }
        GenericBuiltArtifacts builtArtifacts = GenericBuiltArtifactsLoader.loadFromFile((File)new File(outputFile), (ILogger)new LogWrapper(GradleApkProvider.getLogger()));
        if (builtArtifacts == null) {
            throw new ApkProvisionException(String.format("Error loading build artifacts from: %s", outputFile));
        }
        return this.myBestOutputFinder.findBestOutput(variant2, deviceAbis, builtArtifacts);
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPreBuildSync(@NotNull IdeVariant variant2, @NotNull List<String> deviceAbis, boolean fromTestArtifact) throws ApkProvisionException {
        IdeAndroidArtifact artifact;
        IdeAndroidArtifact ideAndroidArtifact = artifact = fromTestArtifact ? variant2.getAndroidTestArtifact() : variant2.getMainArtifact();
        assert (artifact != null);
        ArrayList<IdeAndroidArtifactOutput> outputs = new ArrayList<IdeAndroidArtifactOutput>(artifact.getOutputs());
        return this.myBestOutputFinder.findBestOutput(variant2, deviceAbis, outputs);
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPostBuildSync(@NotNull IdeVariant variant2, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, @NotNull AndroidFacet facet2, boolean fromTestArtifact) throws ApkProvisionException {
        ArrayList<IdeAndroidArtifactOutput> outputs = new ArrayList<IdeAndroidArtifactOutput>();
        PostBuildModel outputModels = this.myOutputModelProvider.getPostBuildModel();
        if (outputModels == null) {
            return this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact);
        }
        ModelCache modelCache = ModelCache.create();
        if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4) {
            InstantAppProjectBuildOutput outputModel = outputModels.findInstantAppProjectBuildOutput(facet2);
            if (outputModel == null) {
                throw new ApkProvisionException("Couldn't get post build model for Instant Apps. Please, make sure to use plugin 3.0.0-alpha10 or later.");
            }
            for (InstantAppVariantBuildOutput instantAppVariantBuildOutput : outputModel.getInstantAppVariantsBuildOutput()) {
                if (!instantAppVariantBuildOutput.getName().equals(variant2.getName())) continue;
                outputs.add((IdeAndroidArtifactOutput)modelCache.androidArtifactOutputFrom(instantAppVariantBuildOutput.getOutput()));
            }
        } else {
            ProjectBuildOutput outputModel = outputModels.findProjectBuildOutput(facet2);
            if (outputModel == null) {
                return this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact);
            }
            for (VariantBuildOutput variantBuildOutput : outputModel.getVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(variant2.getName())) continue;
                if (fromTestArtifact) {
                    for (TestVariantBuildOutput testVariantBuildOutput : variantBuildOutput.getTestingVariants()) {
                        if (!testVariantBuildOutput.getType().equals(TestVariantBuildOutput.ANDROID_TEST)) continue;
                        int apiWithSplitApk = AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel();
                        if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 6 && !deviceVersion.isGreaterOrEqualThan(apiWithSplitApk)) {
                            throw new ApkProvisionException("Running Instrumented Tests for Dynamic Features is currently not supported on API < 21.");
                        }
                        outputs.addAll(ContainerUtil.map((Collection)testVariantBuildOutput.getOutputs(), arg_0 -> ((ModelCache)modelCache).androidArtifactOutputFrom(arg_0)));
                    }
                    continue;
                }
                outputs.addAll(ContainerUtil.map((Collection)variantBuildOutput.getOutputs(), arg_0 -> ((ModelCache)modelCache).androidArtifactOutputFrom(arg_0)));
            }
        }
        return outputs.isEmpty() ? this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact) : this.myBestOutputFinder.findBestOutput(variant2, deviceAbis, outputs);
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull IdeVariant selectedVariant, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion) throws ApkProvisionException {
        ArrayList<ApkInfo> targetedApks = new ArrayList<ApkInfo>();
        for (IdeTestedTargetVariant testedVariant : selectedVariant.getTestedTargetVariants()) {
            String targetGradlePath = testedVariant.getTargetProjectPath();
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> {
                Project project = this.myFacet.getModule().getProject();
                return GradleUtil.findModuleByGradlePath(project, targetGradlePath);
            });
            if (targetModule == null) {
                GradleApkProvider.getLogger().warn(String.format("Module not found for gradle path %s. Please install tested apk manually.", targetGradlePath));
                continue;
            }
            AndroidFacet targetFacet = AndroidFacet.getInstance((Module)targetModule);
            if (targetFacet == null) {
                GradleApkProvider.getLogger().warn("Android facet for tested module is null. Please install tested apk manually.");
                continue;
            }
            AndroidModuleModel targetAndroidModel = AndroidModuleModel.get(targetModule);
            if (targetAndroidModel == null) {
                GradleApkProvider.getLogger().warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            IdeVariant targetVariant = targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            if (targetVariant == null) {
                GradleApkProvider.getLogger().warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = this.getApk(targetVariant, deviceAbis, deviceVersion, targetFacet, false);
            String applicationId2 = targetVariant.getMergedFlavor().getApplicationId();
            if (applicationId2 == null) {
                applicationId2 = targetAndroidModel.getApplicationId();
            }
            targetedApks.add(new ApkInfo(targetApk, applicationId2));
        }
        return targetedApks;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(this.myFacet);
        if (androidModuleModel == null) {
            Runnable requestProjectSync = () -> ProjectSystemUtil.getSyncManager(this.myFacet.getModule().getProject()).syncProject(ProjectSystemSyncManager.SyncReason.USER_REQUEST);
            return ImmutableList.of((Object)ValidationError.fatal("The project has not yet been synced with Gradle configuration", requestProjectSync));
        }
        Object targetDevicesMinVersion = null;
        if (androidModuleModel.getAndroidProject().getProjectType() == 4 || this.myOutputKindProvider.apply((AndroidVersion)targetDevicesMinVersion) == OutputKind.AppBundleOutputModel || androidModuleModel.getMainArtifact().isSigned()) {
            return ImmutableList.of();
        }
        File outputFile = GradleUtil.getOutputFile(androidModuleModel);
        String outputFileName = outputFile == null ? "Unknown output" : outputFile.getName();
        String message2 = AndroidBundle.message("run.error.apk.not.signed", outputFileName, androidModuleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = () -> {
            Module module2 = this.myFacet.getModule();
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module2.getProject());
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openSigningConfiguration(module2);
            } else {
                service.openModuleSettings(module2);
            }
        };
        return ImmutableList.of((Object)ValidationError.fatal(message2, quickFix));
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleApkProvider.class);
    }

    public static enum OutputKind {
        Default,
        AppBundleOutputModel;

    }
}

