/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.RetryingInstallerResult;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullApkInstaller {
    @NotNull
    private final Project myProject;
    @NotNull
    private final LaunchOptions myLaunchOptions;
    @NotNull
    private final InstalledApkCache myInstalledApkCache;
    @NotNull
    private final ConsolePrinter myPrinter;

    public FullApkInstaller(@NotNull Project project, @NotNull LaunchOptions options2, @NotNull InstalledApkCache installedApkCache, @NotNull ConsolePrinter printer) {
        this.myProject = project;
        this.myLaunchOptions = options2;
        this.myInstalledApkCache = installedApkCache;
        this.myPrinter = printer;
    }

    public boolean uploadAndInstallApk(@NotNull IDevice device, @NotNull String packageName, @NotNull File localFile, @NotNull LaunchStatus launchStatus) {
        if (!this.needsInstall(device, localFile, packageName)) {
            return true;
        }
        String remotePath = "/data/local/tmp/" + packageName;
        this.myPrinter.stdout("$ adb push " + localFile + " " + remotePath);
        try {
            device.pushFile(localFile.getPath(), remotePath);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e) {
            this.myPrinter.stderr(e.toString());
            return false;
        }
        String pmInstallOptions = this.getPmInstallOptions(device);
        ApkInstaller installer = new ApkInstaller(this.myPrinter, remotePath, pmInstallOptions);
        RetryingInstaller retryingInstaller = new RetryingInstaller(this.myProject, device, installer, packageName, this.myPrinter, launchStatus);
        RetryingInstallerResult installResult = retryingInstaller.install();
        if (installResult.isSuccess()) {
            this.myPrinter.stdout(String.format("APK installed in %s", StringUtil.formatDuration((long)installResult.getLastInstallDuration().toMillis())));
            try {
                this.myInstalledApkCache.setInstalled(device, localFile, packageName);
            }
            catch (IOException e) {
                Logger.getInstance(FullApkInstaller.class).info("Exception while caching installation state: ", (Throwable)e);
            }
        }
        return installResult.isSuccess();
    }

    @VisibleForTesting
    String getPmInstallOptions(@NotNull IDevice device) {
        String pmInstallOptions = this.myLaunchOptions.getPmInstallOptions(device);
        if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            pmInstallOptions = StringUtil.trimLeading((String)(StringUtil.notNullize((String)pmInstallOptions) + " -g"));
        }
        if (device.getVersion().isGreaterOrEqualThan(28)) {
            pmInstallOptions = StringUtil.trimLeading((String)(StringUtil.notNullize((String)pmInstallOptions) + " --full"));
        }
        return pmInstallOptions;
    }

    @VisibleForTesting
    boolean needsInstall(@NotNull IDevice device, @NotNull File localFile, @NotNull String packageName) {
        if (!this.myLaunchOptions.isSkipNoopApkInstallations()) {
            return true;
        }
        try {
            Integer userId = LaunchUtils.getUserIdFromFlags(this.myLaunchOptions.getPmInstallOptions(device));
            if (!this.myInstalledApkCache.isInstalled(device, localFile, packageName, userId)) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        this.myPrinter.stdout("No apk changes detected since last installation, skipping installation of " + localFile.getPath());
        if (this.myLaunchOptions.isForceStopRunningApp()) {
            this.forceStopPackageSilently(device, packageName, true);
        }
        return false;
    }

    private void forceStopPackageSilently(@NotNull IDevice device, @NotNull String packageName, boolean ignoreErrors) {
        block2: {
            String command = "am force-stop " + packageName;
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver(), 1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (ignoreErrors) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    static final class ApkInstaller
    implements RetryingInstaller.Installer {
        private final String myRemotePath;
        private final ConsolePrinter myPrinter;
        private final String myPmInstallOptions;

        public ApkInstaller(@NotNull ConsolePrinter printer, @NotNull String remotePath, @Nullable String pmInstallOptions) {
            this.myPrinter = printer;
            this.myRemotePath = remotePath;
            this.myPmInstallOptions = pmInstallOptions;
        }

        @Override
        @NotNull
        public InstallResult installApp(@NotNull IDevice device, @NotNull LaunchStatus launchStatus) {
            ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(launchStatus);
            String command = ApkInstaller.getPmInstallCommand(this.myRemotePath, this.myPmInstallOptions);
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)receiver);
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                Logger.getInstance(ApkInstaller.class).info(e);
                return new InstallResult(InstallResult.FailureCode.DEVICE_NOT_RESPONDING, "Exception while installing: " + e, null);
            }
            return InstallResult.forLaunchOutput(receiver);
        }

        @VisibleForTesting
        @NotNull
        static String getPmInstallCommand(@NotNull String remotePath, @Nullable String pmInstallOptions) {
            StringBuilder sb = new StringBuilder(30);
            sb.append("pm install ");
            if (!StringUtil.isEmpty((String)pmInstallOptions)) {
                sb.append(pmInstallOptions);
                sb.append(' ');
            }
            sb.append("-t -r \"");
            sb.append(remotePath);
            sb.append("\"");
            return sb.toString();
        }
    }
}

