/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Function;
import icons.StudioIcons;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectedAndroidDevice
implements AndroidDevice {
    private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private final String myAvdName;
    @Nullable
    private final DeviceNameRendererEx myDeviceNameRenderer;
    private volatile String myDeviceManufacturer;
    private volatile String myDeviceBuild;
    private volatile String myDeviceModel;

    public ConnectedAndroidDevice(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        this.myDevice = device;
        AvdInfo avdInfo = ConnectedAndroidDevice.getAvdInfo(device, avdInfos);
        this.myAvdName = avdInfo == null ? null : avdInfo.getDisplayName();
        this.myDeviceNameRenderer = ConnectedAndroidDevice.getRendererExtension(device);
    }

    @Nullable
    private static AvdInfo getAvdInfo(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        if (avdInfos != null && device.isEmulator()) {
            for (AvdInfo info2 : avdInfos) {
                if (!info2.getName().equals(device.getAvdName())) continue;
                return info2;
            }
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return this.myDevice.isEmulator();
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        return this.myDevice.getVersion();
    }

    @Override
    public int getDensity() {
        return this.myDevice.getDensity();
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        List abis = this.myDevice.getAbis();
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (String abi : abis) {
            Abi a = Abi.getEnum((String)abi);
            if (a == null) continue;
            builder2.add((Object)a);
        }
        return builder2.build();
    }

    @Override
    @NotNull
    public String getSerial() {
        String avdName;
        if (this.myDevice.isEmulator() && (avdName = this.myDevice.getAvdName()) != null) {
            return avdName;
        }
        return this.myDevice.getSerialNumber();
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        return this.myDevice.supportsFeature(feature);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myDeviceNameRenderer != null) {
            return this.myDeviceNameRenderer.getName(this.myDevice);
        }
        if (this.isVirtual()) {
            if (this.myAvdName != null) {
                return this.myAvdName;
            }
            return this.getDeviceName() + " [" + this.getSerial() + "]";
        }
        return this.getDeviceName();
    }

    @Override
    public boolean renderLabel(@NotNull SimpleColoredComponent renderer2, boolean isCompatible, @Nullable String searchPrefix) {
        if (this.myDeviceNameRenderer != null) {
            this.myDeviceNameRenderer.render(this.myDevice, (ColoredTextContainer)renderer2);
            return true;
        }
        renderer2.setIcon(this.myDevice.isEmulator() ? StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE : StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
        IDevice.DeviceState state = this.myDevice.getState();
        if (state != IDevice.DeviceState.ONLINE) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%1$s [%2$s", this.myDevice.getSerialNumber(), state));
            if (state == IDevice.DeviceState.UNAUTHORIZED) {
                buf.append(" - Press 'OK' in the 'Allow USB Debugging' dialog on your device");
            }
            buf.append("] ");
            renderer2.append(buf.toString(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            return true;
        }
        if (this.myDeviceManufacturer != null && this.myDeviceModel != null && this.myDeviceBuild != null) {
            SimpleTextAttributes attr = isCompatible ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            String name = this.getName();
            if (name.isEmpty()) {
                name = "Unknown";
            }
            SearchUtil.appendFragments((String)searchPrefix, (String)name, (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)renderer2);
            String build2 = this.getDeviceBuild();
            if (!build2.isEmpty()) {
                renderer2.append(" (" + build2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            return true;
        }
        renderer2.append("...");
        return false;
    }

    @NotNull
    private String getDeviceName() {
        StringBuilder name = new StringBuilder(20);
        name.append(this.getDeviceManufacturer());
        if (name.length() > 0) {
            name.append(' ');
        }
        name.append(this.getDeviceModel());
        return name.toString();
    }

    @Override
    public void prepareToRenderLabel() {
        assert (!this.isDispatchThread());
        this.getDeviceManufacturer();
        this.getDeviceModel();
        this.getDeviceBuild();
    }

    @NotNull
    private String getDeviceManufacturer() {
        if (this.myDeviceManufacturer == null) {
            assert (!this.isDispatchThread());
            this.myDeviceManufacturer = DevicePropertyUtil.getManufacturer(this.myDevice, "");
        }
        return this.myDeviceManufacturer;
    }

    @NotNull
    private String getDeviceModel() {
        if (this.myDeviceModel == null) {
            assert (!this.isDispatchThread());
            this.myDeviceModel = DevicePropertyUtil.getModel(this.myDevice, "");
        }
        return this.myDeviceModel;
    }

    @NotNull
    private String getDeviceBuild() {
        if (this.myDeviceBuild == null) {
            assert (!this.isDispatchThread());
            this.myDeviceBuild = DevicePropertyUtil.getBuild(this.myDevice);
        }
        return this.myDeviceBuild;
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        return this.getLaunchedDevice();
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project, @NotNull List<String> arguments) {
        return this.getLaunchedDevice();
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        return Futures.immediateFuture((Object)this.myDevice);
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @Nullable
    private static DeviceNameRendererEx getRendererExtension(@NotNull IDevice device) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return null;
        }
        for (DeviceNameRendererEx extensionRenderer : (DeviceNameRendererEx[])EP_NAME.getExtensions()) {
            if (!extensionRenderer.isApplicable(device)) continue;
            return extensionRenderer;
        }
        return null;
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull AndroidFacet facet2, Function<AndroidFacet, EnumSet<IDevice.HardwareFeature>> getRequiredHardwareFeatures, @NotNull Set<String> supportedAbis) {
        return LaunchCompatibility.canRunOnDevice(minSdkVersion2, projectTarget, facet2, getRequiredHardwareFeatures, supportedAbis, this);
    }

    private boolean isDispatchThread() {
        Application application = ApplicationManager.getApplication();
        return application != null && application.isDispatchThread();
    }

    @Override
    public boolean isDebuggable() {
        return LaunchUtils.isDebuggableDevice(this.myDevice);
    }
}

