/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericBuiltArtifactsSplitOutputMatcher;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.run.ApkProvisionException;
import com.google.common.base.Joiner;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BestOutputFinder {
    BestOutputFinder() {
    }

    @NotNull
    File findBestOutput(@NotNull IdeVariant variant2, @NotNull List<String> abis, @NotNull List<IdeAndroidArtifactOutput> outputs) throws ApkProvisionException {
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant2.getDisplayName());
        }
        return BestOutputFinder.doFindBestOutput(variant2, abis, outputs, null);
    }

    @NotNull
    File findBestOutput(@NotNull IdeVariant variant2, @NotNull List<String> abis, @NotNull GenericBuiltArtifacts builtArtifact) throws ApkProvisionException {
        return BestOutputFinder.doFindBestOutput(variant2, abis, null, builtArtifact);
    }

    @NotNull
    private static File doFindBestOutput(@NotNull IdeVariant variant2, @NotNull List<String> abis, @Nullable List<IdeAndroidArtifactOutput> outputs, @Nullable GenericBuiltArtifacts builtArtifact) throws ApkProvisionException {
        Set variantAbiFilters = variant2.getMainArtifact().getAbiFilters();
        List apkFiles = new ArrayList();
        int outputCount = 0;
        if (outputs != null) {
            apkFiles = ContainerUtil.map((Collection)SplitOutputMatcher.computeBestOutput(outputs, (Collection)variantAbiFilters, abis), IdeAndroidArtifactOutput::getOutputFile);
            outputCount = outputs.size();
        }
        if (builtArtifact != null) {
            apkFiles = GenericBuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(builtArtifact, (Collection)variantAbiFilters, abis);
            outputCount = builtArtifact.getElements().size();
        }
        if (apkFiles.isEmpty()) {
            String message2 = AndroidBundle.message("deployment.failed.splitapk.nomatch", variant2.getDisplayName(), outputCount, Joiner.on((String)", ").join(abis));
            throw new ApkProvisionException(message2);
        }
        return (File)apkFiles.get(0);
    }
}

