/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.annotations.Trace;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.util.LaunchStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ApplicationTerminator
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final List<Client> myClientsToWaitFor = Collections.synchronizedList(new ArrayList());
    @NotNull
    private final CountDownLatch myProcessKilledLatch = new CountDownLatch(1);

    public ApplicationTerminator(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        this.myIDevice = iDevice;
        this.myApplicationId = applicationId2;
    }

    @Trace
    public boolean killApp(@NotNull LaunchStatus launchStatus) {
        this.myIDevice.forceStop(this.myApplicationId);
        this.myClientsToWaitFor.addAll(DeploymentApplicationService.getInstance().findClient(this.myIDevice, this.myApplicationId));
        if (!this.myIDevice.isOnline() || this.myClientsToWaitFor.isEmpty()) {
            this.myProcessKilledLatch.countDown();
        } else {
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            this.checkDone();
        }
        try {
            if (!this.myProcessKilledLatch.await(10L, TimeUnit.SECONDS)) {
                launchStatus.terminateLaunch(String.format("%s is already running.", this.myApplicationId), true);
                return false;
            }
        }
        catch (InterruptedException ignored) {
            launchStatus.terminateLaunch(String.format("%s is already running.", this.myApplicationId), true);
            return false;
        }
        return true;
    }

    public void deviceConnected(@NotNull IDevice device) {
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == this.myIDevice) {
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void deviceChanged(@NotNull IDevice changedDevice, int changeMask) {
        if (changedDevice != this.myIDevice || (changeMask & 2) == 0) {
            this.checkDone();
            return;
        }
        this.myClientsToWaitFor.retainAll(Arrays.asList(changedDevice.getClients()));
        this.checkDone();
    }

    private void checkDone() {
        if (this.myClientsToWaitFor.isEmpty()) {
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }
}

