/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ApkFileUnit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ApkInfo {
    @NotNull
    private final List<ApkFileUnit> myFiles;
    @NotNull
    private final String myApplicationId;

    public ApkInfo(@NotNull File file2, @NotNull String applicationId2) {
        this.myFiles = ImmutableList.of((Object)new ApkFileUnit("", file2));
        this.myApplicationId = applicationId2;
    }

    public ApkInfo(@NotNull List<ApkFileUnit> files2, @NotNull String applicationId2) {
        Preconditions.checkArgument((!files2.isEmpty() ? 1 : 0) != 0);
        this.myFiles = files2;
        this.myApplicationId = applicationId2;
    }

    @NotNull
    public File getFile() {
        Preconditions.checkArgument((this.myFiles.size() == 1 ? 1 : 0) != 0);
        return this.myFiles.get(0).getApkFile();
    }

    @NotNull
    public List<ApkFileUnit> getFiles() {
        return this.myFiles;
    }

    @NotNull
    public String getApplicationId() {
        return this.myApplicationId;
    }
}

