/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.retention.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.RunningEmulatorCatalog;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.retention.actions.FindEmulatorAndSetupRetentionKt;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.testartifacts.instrumented.RetentionConstantsKt;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/retention/actions/FindEmulatorAndSetupRetention;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.testRetention"})
public final class FindEmulatorAndSetupRetention
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(dataContext, project2, project2, "Loading retained test failure", true){
            final /* synthetic */ DataContext $dataContext;
            final /* synthetic */ Project $project;

            public void onFinished() {
                block0: {
                    Runnable runnable2 = (Runnable)this.$dataContext.getData(RetentionConstantsKt.RETENTION_ON_FINISH_KEY);
                    if (runnable2 == null) break block0;
                    runnable2.run();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void adbDevice;
                Ref.ObjectRef $this$forEach$iv;
                Object v2;
                String deviceName;
                block24: {
                    AvdInfo avdInfo;
                    AvdManager avdManager;
                    indicator.setIndeterminate(false);
                    indicator.setFraction(0.0);
                    deviceName = (String)this.$dataContext.getData(RetentionConstantsKt.DEVICE_NAME_KEY);
                    RunningEmulatorCatalog catalog = RunningEmulatorCatalog.Companion.getInstance();
                    AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                    LogWrapper logWrapper = new LogWrapper(FindEmulatorAndSetupRetentionKt.access$getLOG$p());
                    AvdManager avdManager2 = avdManager = AvdManager.getInstance((AndroidSdkHandler)androidSdkHandler, (ILogger)((ILogger)logWrapper));
                    AvdInfo avdInfo2 = avdInfo = avdManager2 != null ? avdManager2.getAvd(deviceName, true) : null;
                    if (avdInfo == null) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Cannot find valid AVD with name: " + deviceName);
                        return;
                    }
                    if (!avdManager.isAvdRunning(avdInfo, (ILogger)logWrapper)) {
                        ListenableFuture<IDevice> deviceFuture = AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(this.$project, avdInfo);
                        IDevice device = (IDevice)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)deviceFuture));
                        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Boolean, Exception>(device){
                            final /* synthetic */ IDevice $device;

                            public final Boolean compute() {
                                return this.$device.isOnline();
                            }
                            {
                                this.$device = iDevice;
                            }
                        }));
                    }
                    Set emulatorControllers = (Set)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)catalog.updateNow()));
                    Iterable iterable = emulatorControllers;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        EmulatorController it = (EmulatorController)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getEmulatorId().getAvdId(), (Object)deviceName)) continue;
                        v2 = t;
                        break block24;
                    }
                    v2 = null;
                }
                EmulatorController emulatorController = v2;
                if (emulatorController == null) {
                    FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to find or launch to AVD with device name: " + deviceName);
                    return;
                }
                if (emulatorController.getConnectionState() != EmulatorController.ConnectionState.CONNECTED) {
                    EmulatorController.connectGrpc$default(emulatorController, 0, 1, null);
                }
                String emulatorSerialString = "emulator-" + emulatorController.getEmulatorId().getSerialPort();
                String string = (String)this.$dataContext.getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_ID_KEY);
                if (string == null) {
                    return;
                }
                String snapshotId = string;
                File file2 = (File)this.$dataContext.getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_FILE_KEY);
                if (file2 == null) {
                    return;
                }
                File snapshotFile = file2;
                Boolean bl = (Boolean)this.$dataContext.getData(RetentionConstantsKt.RETENTION_AUTO_CONNECT_DEBUGGER_KEY);
                if (bl == null) {
                    bl = false;
                }
                boolean shouldAttachDebugger = bl;
                String string2 = (String)this.$dataContext.getData(RetentionConstantsKt.PACKAGE_NAME_KEY);
                if (string2 == null) {
                    return;
                }
                String packageName = string2;
                if (!shouldAttachDebugger) {
                    if (!FindEmulatorAndSetupRetentionKt.access$pushAndLoadSync(emulatorController, snapshotId, snapshotFile, indicator)) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to import snapshots. Please try to boot emulator (" + deviceName + ") with the same " + "command line parameters as you run the test.");
                    }
                    return;
                }
                Sequence sequence = AndroidDebugBridge.getBridge();
                if (sequence != null && (sequence = sequence.getDevices()) != null && (sequence = ArraysKt.asSequence((Object[])sequence)) != null && (sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<IDevice, Boolean>(emulatorSerialString){
                    final /* synthetic */ String $emulatorSerialString;

                    public final boolean invoke(IDevice it) {
                        return Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)this.$emulatorSerialString);
                    }
                    {
                        this.$emulatorSerialString = string;
                        super(1);
                    }
                }))) != null) {
                    $this$forEach$iv = sequence;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        IDevice it = (IDevice)element$iv;
                        boolean bl4 = false;
                        Client client = it.getClient(packageName);
                        if (client != null) {
                            client.kill();
                        }
                    }
                }
                $this$forEach$iv = new Ref.ObjectRef();
                $this$forEach$iv.element = null;
                CountDownLatch deviceReadySignal = new CountDownLatch(1);
                AndroidDebugBridge.IDeviceChangeListener deviceChangeListener2 = new AndroidDebugBridge.IDeviceChangeListener(emulatorSerialString, (Ref.ObjectRef)adbDevice, deviceReadySignal){
                    final /* synthetic */ String $emulatorSerialString;
                    final /* synthetic */ Ref.ObjectRef $adbDevice;
                    final /* synthetic */ CountDownLatch $deviceReadySignal;

                    public void deviceDisconnected(@NotNull IDevice device) {
                    }

                    public void deviceConnected(@NotNull IDevice device) {
                        if (Intrinsics.areEqual((Object)this.$emulatorSerialString, (Object)device.getSerialNumber())) {
                            this.$adbDevice.element = device;
                            this.$deviceReadySignal.countDown();
                            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
                        }
                    }

                    public void deviceChanged(@NotNull IDevice device, int changeMask) {
                    }
                    {
                        this.$emulatorSerialString = $captured_local_variable$0;
                        this.$adbDevice = $captured_local_variable$1;
                        this.$deviceReadySignal = $captured_local_variable$2;
                    }
                };
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceChangeListener2);
                try {
                    if (!FindEmulatorAndSetupRetentionKt.access$pushAndLoadSync(emulatorController, snapshotId, snapshotFile, indicator)) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to import snapshots. Please try to boot emulator (" + deviceName + ") with the same " + "command line parameters as you run the test.");
                        return;
                    }
                    indicator.setFraction(0.7);
                    FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Snapshot loaded.");
                    ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)deviceReadySignal);
                }
                finally {
                    AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceChangeListener2);
                }
                if ((IDevice)adbDevice.element == null) {
                    FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to connect to device.");
                    return;
                }
                IDevice iDevice = (IDevice)adbDevice.element;
                if (iDevice == null) {
                    Intrinsics.throwNpe();
                }
                IDevice targetDevice = iDevice;
                ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Boolean, Exception>(targetDevice, packageName){
                    final /* synthetic */ IDevice $targetDevice;
                    final /* synthetic */ String $packageName;

                    public final Boolean compute() {
                        Boolean bl;
                        if (this.$targetDevice.getClient(this.$packageName) == null) {
                            Thread.sleep(10L);
                            bl = false;
                        } else {
                            bl = true;
                        }
                        return bl;
                    }
                    {
                        this.$targetDevice = iDevice;
                        this.$packageName = string;
                    }
                }));
                indicator.setFraction(0.8);
                CountDownLatch debugSessionReadySignal = new CountDownLatch(1);
                MessageBusConnection messageBusConnection = this.$project.getMessageBus().connect();
                try {
                    messageBusConnection.subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(messageBusConnection, debugSessionReadySignal){
                        final /* synthetic */ MessageBusConnection $messageBusConnection;
                        final /* synthetic */ CountDownLatch $debugSessionReadySignal;

                        public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
                            if (currentSession != null) {
                                this.$messageBusConnection.disconnect();
                                this.$debugSessionReadySignal.countDown();
                            }
                        }
                        {
                            this.$messageBusConnection = $captured_local_variable$0;
                            this.$debugSessionReadySignal = $captured_local_variable$1;
                        }
                    });
                    FindEmulatorAndSetupRetentionKt.access$connectDebugger(targetDevice, this.$dataContext);
                    ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)debugSessionReadySignal);
                    indicator.setFraction(0.9);
                }
                catch (Exception exception) {
                    messageBusConnection.disconnect();
                    throw (Throwable)exception;
                }
                XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.getProject()).getCurrentSession();
                if (xDebugSession == null) {
                    Intrinsics.throwNpe();
                }
                XDebugSession currentSession = xDebugSession;
                CountDownLatch pauseSignal = new CountDownLatch(1);
                currentSession.addSessionListener(new XDebugSessionListener(currentSession, pauseSignal){
                    final /* synthetic */ XDebugSession $currentSession;
                    final /* synthetic */ CountDownLatch $pauseSignal;

                    public void sessionPaused() {
                        this.$currentSession.removeSessionListener((XDebugSessionListener)this);
                        this.$pauseSignal.countDown();
                    }

                    public void settingsChanged() {
                        this.$currentSession.pause();
                    }
                    {
                        this.$currentSession = $captured_local_variable$0;
                        this.$pauseSignal = $captured_local_variable$1;
                    }
                });
                currentSession.pause();
                ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)pauseSignal);
                FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Ready for debugging.");
            }
            {
                this.$dataContext = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        String snapshotId = (String)event.getDataContext().getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_ID_KEY);
        File snapshotFile = (File)event.getDataContext().getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_FILE_KEY);
        event.getPresentation().setEnabledAndVisible(snapshotId != null && snapshotFile != null);
    }
}

