/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicStyleResourceItem
extends BasicValueResourceItemBase
implements StyleResourceValue {
    private static final Logger LOG = Logger.getInstance(BasicStyleResourceItem.class);
    @Nullable
    private final String myParentStyle;
    @NotNull
    private final Table<ResourceNamespace, String, StyleItemResourceValue> myStyleItemTable;

    public BasicStyleResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String parentStyle, @NotNull Collection<StyleItemResourceValue> styleItems) {
        super(ResourceType.STYLE, name, sourceFile, visibility);
        this.myParentStyle = parentStyle;
        ImmutableTable.Builder tableBuilder = ImmutableTable.builder();
        HashMap<ResourceReference, StyleItemResourceValue> duplicateCheckMap = new HashMap<ResourceReference, StyleItemResourceValue>();
        for (StyleItemResourceValue styleItem : styleItems) {
            ResourceReference attr2 = styleItem.getAttr();
            if (attr2 == null) continue;
            StyleItemResourceValue previouslyDefined = duplicateCheckMap.put(attr2, styleItem);
            if (previouslyDefined == null) {
                tableBuilder.put((Object)attr2.getNamespace(), (Object)attr2.getName(), (Object)styleItem);
                continue;
            }
            if (previouslyDefined.equals(styleItem)) continue;
            LOG.warn("Conflicting definitions of \"" + styleItem.getAttrName() + "\" in style \"" + name + "\"");
        }
        this.myStyleItemTable = tableBuilder.build();
    }

    @Nullable
    public String getParentStyleName() {
        return this.myParentStyle;
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceNamespace namespace, @NotNull String name) {
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)namespace, (Object)name);
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceReference attr2) {
        assert (attr2.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)attr2.getNamespace(), (Object)attr2.getName());
    }

    @NotNull
    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.myStyleItemTable.values();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicStyleResourceItem other = (BasicStyleResourceItem)obj;
        return Objects.equals(this.myParentStyle, other.myParentStyle) && this.myStyleItemTable.equals(other.myStyleItemTable);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myParentStyle);
        stream.writeInt(this.myStyleItemTable.size());
        for (StyleItemResourceValue styleItem : this.myStyleItemTable.values()) {
            stream.writeString(styleItem.getAttrName());
            stream.writeString(styleItem.getValue());
            int index2 = namespaceResolverIndexes.getInt((Object)styleItem.getNamespaceResolver());
            assert (index2 >= 0);
            stream.writeInt(index2);
        }
    }

    @NotNull
    static BasicStyleResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        LoadableResourceRepository repository = sourceFile.getRepository();
        ResourceNamespace namespace = repository.getNamespace();
        String libraryName = repository.getLibraryName();
        String parentStyle = stream.readString();
        int n = stream.readInt();
        ArrayList<StyleItemResourceValue> styleItems = n == 0 ? Collections.emptyList() : new ArrayList<StyleItemResourceValue>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            String attrName = stream.readString();
            if (attrName == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            String value2 = stream.readString();
            ResourceNamespace.Resolver itemResolver = namespaceResolvers.get(stream.readInt());
            StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(namespace, attrName, value2, libraryName);
            styleItem.setNamespaceResolver(itemResolver);
            styleItems.add((StyleItemResourceValue)styleItem);
        }
        BasicStyleResourceItem item = new BasicStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

