/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicArrayResourceItem
extends BasicValueResourceItemBase
implements ArrayResourceValue {
    @NotNull
    private final List<String> myElements;
    private final int myDefaultIndex;

    public BasicArrayResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull List<String> elements, int defaultIndex) {
        super(ResourceType.ARRAY, name, sourceFile, visibility);
        this.myElements = elements;
        assert (elements.isEmpty() || defaultIndex < elements.size());
        this.myDefaultIndex = defaultIndex;
    }

    public int getElementCount() {
        return this.myElements.size();
    }

    @NotNull
    public String getElement(int index2) {
        return this.myElements.get(index2);
    }

    public Iterator<String> iterator() {
        return this.myElements.iterator();
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myElements.isEmpty() ? null : this.myElements.get(this.myDefaultIndex);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicArrayResourceItem other = (BasicArrayResourceItem)obj;
        return this.myElements.equals(other.myElements);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeInt(this.myElements.size());
        for (String element2 : this.myElements) {
            stream.writeString(element2);
        }
        stream.writeInt(this.myDefaultIndex);
    }

    @NotNull
    static BasicArrayResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        int n = stream.readInt();
        ArrayList<String> elements = n == 0 ? Collections.emptyList() : new ArrayList<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            elements.add(stream.readString());
        }
        int defaultIndex = stream.readInt();
        if (!elements.isEmpty() && defaultIndex >= elements.size()) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        BasicArrayResourceItem item = new BasicArrayResourceItem(name, sourceFile, visibility, elements, defaultIndex);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

