/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ResourceFolder;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.CachingData;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.NamespaceResolver;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.RepositoryLoader;
import com.android.tools.idea.resources.base.ResourceSerializationUtil;
import com.android.tools.idea.resources.base.ResourceSourceFileImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NullableLazyValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarSourceResourceRepository
extends AbstractAarResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "3";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final Logger LOG = Logger.getInstance(AarSourceResourceRepository.class);
    @NotNull
    protected final Path myResourceDirectoryOrFile;
    protected boolean myLoadedFromCache;
    @NotNull
    private final String mySourceFileProtocol;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final String myResourceUrlPrefix;
    @NotNull
    private final NullableLazyValue<String> myManifestPackageName;

    protected AarSourceResourceRepository(@NotNull RepositoryLoader loader, @Nullable String libraryName) {
        super(loader.getNamespace(), libraryName);
        this.myResourceDirectoryOrFile = loader.getResourceDirectoryOrFile();
        this.mySourceFileProtocol = loader.getSourceFileProtocol();
        this.myResourcePathPrefix = loader.getResourcePathPrefix();
        this.myResourceUrlPrefix = loader.getResourceUrlPrefix();
        this.myManifestPackageName = NullableLazyValue.createValue(() -> {
            try {
                PathString manifestPath = this.getSourceFile("../AndroidManifest.xml", true);
                return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestPath);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                LOG.error("Failed to read manifest AndroidManifest.xml for " + this.getDisplayName(), (Throwable)e);
                return null;
            }
        });
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull Path resourceDirectoryOrFile, @NotNull String libraryName) {
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, libraryName, null);
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull Path resourceDirectoryOrFile, @NotNull String libraryName, @Nullable CachingData cachingData) {
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, null, ResourceNamespace.RES_AUTO, libraryName, cachingData);
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull ResourceFolder resourceFolder, @NotNull String libraryName, @Nullable CachingData cachingData) {
        Path resDir = resourceFolder.getRoot().toPath();
        Preconditions.checkArgument((resDir != null ? 1 : 0) != 0);
        return AarSourceResourceRepository.create(resDir, resourceFolder.getResources(), ResourceNamespace.RES_AUTO, libraryName, cachingData);
    }

    @NotNull
    private static AarSourceResourceRepository create(@NotNull Path resourceDirectoryOrFile, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace, @NotNull String libraryName, @Nullable CachingData cachingData) {
        Executor executor;
        Loader loader = new Loader(resourceDirectoryOrFile, resourceFilesAndFolders, namespace);
        AarSourceResourceRepository repository = new AarSourceResourceRepository(loader, libraryName);
        if (cachingData != null && resourceFilesAndFolders == null && repository.loadFromPersistentCache(cachingData)) {
            return repository;
        }
        loader.loadRepositoryContents(repository);
        repository.populatePublicResourcesMap();
        repository.freezeResources();
        if (cachingData != null && resourceFilesAndFolders == null && (executor = cachingData.getCacheCreationExecutor()) != null) {
            executor.execute(() -> repository.createPersistentCache(cachingData));
        }
        return repository;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        return this.myResourceDirectoryOrFile;
    }

    @NotNull
    public static AarSourceResourceRepository createForTest(@NotNull Path resourceDirectoryOrFile, @NotNull ResourceNamespace namespace, @NotNull String libraryName) {
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, null, namespace, libraryName, null);
    }

    @Nullable
    public String getPackageName() {
        String packageName = this.myNamespace.getPackageName();
        return packageName == null ? (String)this.myManifestPackageName.getValue() : packageName;
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return new PathString(this.mySourceFileProtocol, this.myResourcePathPrefix + relativeResourcePath);
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        return this.myResourceUrlPrefix + relativeResourcePath;
    }

    private boolean loadFromPersistentCache(@NotNull CachingData cachingData) {
        byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, stream));
        return this.loadFromPersistentCache(cachingData.getCacheFile(), header);
    }

    private void createPersistentCache(@NotNull CachingData cachingData) {
        byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, stream));
        ResourceSerializationUtil.createPersistentCache(cachingData.getCacheFile(), header, stream -> this.writeToStream(stream, config -> true));
    }

    protected void writeCacheHeaderContent(@NotNull CachingData cachingData, @NotNull Base128OutputStream stream) throws IOException {
        stream.write(CACHE_FILE_HEADER);
        stream.writeString(CACHE_FILE_FORMAT_VERSION);
        stream.writeString(this.myResourceDirectoryOrFile.toString());
        stream.writeString(cachingData.getContentVersion());
        stream.writeString(cachingData.getCodeVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromPersistentCache(@NotNull Path cacheFile, @NotNull byte[] fileHeader) {
        try (Base128InputStream stream = new Base128InputStream(cacheFile);){
            if (!stream.validateContents(fileHeader)) {
                boolean bl2 = false;
                return bl2;
            }
            this.loadFromStream(stream, Maps.newHashMapWithExpectedSize((int)1000), null);
            this.populatePublicResourcesMap();
            this.freezeResources();
            this.myLoadedFromCache = true;
            boolean bl = true;
            return bl;
        }
        catch (NoSuchFileException e) {
            return false;
        }
        catch (ProcessCanceledException e) {
            this.cleanupAfterFailedLoadingFromCache();
            throw e;
        }
        catch (Throwable e) {
            this.cleanupAfterFailedLoadingFromCache();
            LOG.warn("Failed to load resources from cache file " + cacheFile.toString(), e);
            return false;
        }
    }

    protected void cleanupAfterFailedLoadingFromCache() {
        this.myResources.clear();
    }

    void writeToStream(@NotNull Base128OutputStream stream, @NotNull Predicate<FolderConfiguration> configFilter) throws IOException {
        ResourceSerializationUtil.writeResourcesToStream(this.myResources, stream, configFilter);
    }

    protected void loadFromStream(@NotNull Base128InputStream stream, @NotNull Map<String, String> stringCache, @Nullable Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) throws IOException {
        ResourceSerializationUtil.readResourcesFromStream(stream, stringCache, namespaceResolverCache, this, item -> this.addResourceItem((ResourceItem)item));
    }

    boolean isLoadedFromCache() {
        return this.myLoadedFromCache;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResourceDirectoryOrFile;
    }

    private static class Loader
    extends RepositoryLoader<AarSourceResourceRepository> {
        @NotNull
        private Set<String> myRTxtIds = ImmutableSet.of();

        Loader(@NotNull Path resourceDirectoryOrFile, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace) {
            super(resourceDirectoryOrFile, resourceFilesAndFolders, namespace);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean loadIdsFromRTxt() {
            if (this.myZipFile == null) {
                Path rDotTxt = this.myResourceDirectoryOrFile.resolveSibling("R.txt");
                if (!Files.exists(rDotTxt, new LinkOption[0])) return false;
                try {
                    SymbolTable symbolTable = SymbolIo.readFromAaptNoValues((File)rDotTxt.toFile(), null);
                    this.myRTxtIds = Loader.computeIds(symbolTable);
                    return true;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Failed to load id resources from " + rDotTxt.toString(), (Throwable)e);
                    return false;
                }
            }
            ZipEntry zipEntry = this.myZipFile.getEntry("R.txt");
            if (zipEntry == null) return false;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.myZipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));){
                SymbolTable symbolTable = SymbolIo.readFromAaptNoValues((BufferedReader)reader, (String)("R.txt in " + this.myResourceDirectoryOrFile), null);
                this.myRTxtIds = Loader.computeIds(symbolTable);
                boolean bl = true;
                return bl;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Failed to load id resources from R.txt in " + this.myResourceDirectoryOrFile, (Throwable)e);
            }
            return false;
        }

        @Override
        protected void finishLoading(@NotNull AarSourceResourceRepository repository) {
            super.finishLoading(repository);
            this.createResourcesForRTxtIds(repository);
        }

        private void createResourcesForRTxtIds(@NotNull AarSourceResourceRepository repository) {
            if (!this.myRTxtIds.isEmpty()) {
                RepositoryConfiguration configuration = this.getConfiguration(repository, ResourceItem.DEFAULT_CONFIGURATION);
                ResourceSourceFileImpl sourceFile = new ResourceSourceFileImpl(null, configuration);
                for (String name : this.myRTxtIds) {
                    this.addIdResourceItem(name, sourceFile);
                }
                this.addValueFileResources();
            }
        }

        private static Set<String> computeIds(@NotNull SymbolTable symbolTable) {
            return symbolTable.getSymbols().row((Object)ResourceType.ID).values().stream().map(s -> s.getCanonicalName()).collect(Collectors.toSet());
        }

        @Override
        protected void loadPublicResourceNames() {
            if (this.myZipFile == null) {
                Path file2 = this.myResourceDirectoryOrFile.resolveSibling("public.txt");
                try (BufferedReader reader = Files.newBufferedReader(file2);){
                    this.readPublicResourceNames(reader);
                }
                catch (NoSuchFileException e) {
                    this.myDefaultVisibility = ResourceVisibility.PUBLIC;
                }
                catch (IOException e) {
                    LOG.warn("Error reading " + file2.toString(), (Throwable)e);
                }
            } else {
                ZipEntry zipEntry = this.myZipFile.getEntry("public.txt");
                if (zipEntry == null) {
                    this.myDefaultVisibility = ResourceVisibility.PUBLIC;
                } else {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.myZipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));){
                        this.readPublicResourceNames(reader);
                    }
                    catch (IOException e) {
                        LOG.warn("Error reading public.txt from " + this.myResourceDirectoryOrFile, (Throwable)e);
                    }
                }
            }
        }

        @Override
        protected void addResourceItem(@NotNull BasicResourceItem item, @NotNull AarSourceResourceRepository repository) {
            repository.addResourceItem((ResourceItem)item);
        }

        private void readPublicResourceNames(@NotNull BufferedReader reader) throws IOException {
            String line2;
            while ((line2 = reader.readLine()) != null) {
                ResourceType type;
                int delimiterPos = (line2 = line2.trim()).indexOf(32);
                if (delimiterPos <= 0 || delimiterPos + 1 >= line2.length() || (type = ResourceType.fromXmlTagName((String)line2.substring(0, delimiterPos))) == null) continue;
                String name = line2.substring(delimiterPos + 1);
                this.addPublicResourceName(type, name);
            }
        }
    }
}

