/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.StyleableResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiResourceItem
implements ResourceItem {
    @NotNull
    private final String myName;
    @NotNull
    private final ResourceType myType;
    @NotNull
    private ResourceFolderRepository myOwner;
    @Nullable
    private ResourceValue myResourceValue;
    @Nullable
    private PsiResourceFile mySourceFile;
    @Nullable
    private final WeakReference<XmlTag> myOriginalTag;
    @Nullable
    private SmartPsiElementPointer<PsiFile> myFilePointer;
    @Nullable
    private SmartPsiElementPointer<XmlTag> myTagPointer;
    @Nullable
    private AsyncInitializationData myAsyncInitData;

    private PsiResourceItem(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceFolderRepository owner, @Nullable XmlTag tag, @NotNull PsiFile file2, boolean calledFromPsiListener) {
        this.myName = name;
        this.myType = type;
        this.myOriginalTag = tag == null ? null : new WeakReference<XmlTag>(tag);
        this.myOwner = owner;
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)file2.getProject());
        if (calledFromPsiListener) {
            AsyncInitializationData initData;
            this.myAsyncInitData = initData = new AsyncInitializationData(file2, tag);
            Application application = ApplicationManager.getApplication();
            application.executeOnPooledThread(() -> application.runReadAction(() -> {
                try {
                    SmartPsiElementPointer filePointer = pointerManager.createSmartPsiElementPointer((PsiElement)initData.psiFile);
                    SmartPsiElementPointer tagPointer = initData.xmlTag == null ? null : pointerManager.createSmartPsiElementPointer((PsiElement)initData.xmlTag, initData.psiFile);
                    AsyncInitializationData asyncInitializationData = initData;
                    synchronized (asyncInitializationData) {
                        this.myFilePointer = filePointer;
                        this.myTagPointer = tagPointer;
                    }
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    // empty catch block
                }
                this.myAsyncInitData = null;
            }));
        } else {
            this.myFilePointer = pointerManager.createSmartPsiElementPointer((PsiElement)file2);
            this.myTagPointer = tag == null ? null : pointerManager.createSmartPsiElementPointer((PsiElement)tag, file2);
        }
    }

    @NotNull
    public static PsiResourceItem forXmlTag(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceFolderRepository owner, @NotNull XmlTag tag, boolean calledFromPsiListener) {
        return new PsiResourceItem(name, type, owner, tag, tag.getContainingFile(), calledFromPsiListener);
    }

    @NotNull
    public static PsiResourceItem forFile(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceFolderRepository owner, @NotNull PsiFile file2, boolean calledFromPsiListener) {
        return new PsiResourceItem(name, type, owner, null, file2, calledFromPsiListener);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public ResourceType getType() {
        return this.myType;
    }

    @NotNull
    public ResourceFolderRepository getRepository() {
        return this.myOwner;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myOwner.getNamespace();
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public ResourceReference getReferenceToSelf() {
        return new ResourceReference(this.getNamespace(), this.myType, this.myName);
    }

    @NotNull
    public FolderConfiguration getConfiguration() {
        PsiResourceFile source = this.getSourceFile();
        assert (source != null) : "getConfiguration called on a PsiResourceItem with no source";
        return source.getFolderConfiguration();
    }

    @NotNull
    public String getKey() {
        String qualifiers = this.getConfiguration().getQualifierString();
        if (!qualifiers.isEmpty()) {
            return this.myType.getName() + '-' + qualifiers + '/' + this.myName;
        }
        return this.myType.getName() + '/' + this.myName;
    }

    @Nullable
    public PsiResourceFile getSourceFile() {
        if (this.mySourceFile != null) {
            return this.mySourceFile;
        }
        PsiFile psiFile2 = this.getPsiFile();
        if (psiFile2 == null) {
            return null;
        }
        PsiElement parent = AndroidPsiUtils.getPsiParentSafely((PsiElement)psiFile2);
        if (!(parent instanceof PsiDirectory)) {
            return null;
        }
        String name = ((PsiDirectory)parent).getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
        if (folderType == null) {
            return null;
        }
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)name);
        if (folderConfiguration == null) {
            return null;
        }
        return new PsiResourceFile(psiFile2, (Iterable<PsiResourceItem>)ImmutableList.of((Object)this), folderType, new RepositoryConfiguration(this.myOwner, folderConfiguration));
    }

    public void setSourceFile(@Nullable PsiResourceFile sourceFile) {
        this.mySourceFile = sourceFile;
    }

    @Nullable
    public ResourceValue getResourceValue() {
        if (this.myResourceValue == null) {
            XmlTag tag = this.getTag();
            if (tag == null) {
                String path2;
                PsiResourceFile source = this.getSourceFile();
                assert (source != null) : "getResourceValue called on a PsiResourceItem with no source";
                ResourceType type = this.getType();
                Density density = type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                VirtualFile virtualFile = source.getVirtualFile();
                String string = path2 = virtualFile == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).getAbsolutePath();
                this.myResourceValue = density != null ? new DensityBasedResourceValueImpl(this.getNamespace(), this.myType, this.myName, path2, density, null) : new ResourceValueImpl(this.getNamespace(), this.myType, this.myName, path2, null);
            } else {
                this.myResourceValue = this.parseXmlToResourceValueSafe(tag);
            }
        }
        return this.myResourceValue;
    }

    @Nullable
    public PathString getSource() {
        PsiFile psiFile2 = this.getPsiFile();
        if (psiFile2 == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        return virtualFile == null ? null : new PathString(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
    }

    public boolean isFileBased() {
        return this.myOriginalTag == null;
    }

    @Nullable
    private Density getFolderDensity() {
        FolderConfiguration configuration = this.getConfiguration();
        DensityQualifier densityQualifier = configuration.getDensityQualifier();
        if (densityQualifier != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    @Nullable
    private ResourceValue parseXmlToResourceValueSafe(@Nullable XmlTag tag) {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return this.parseXmlToResourceValue(tag);
        }
        return (ResourceValue)application.runReadAction(() -> this.parseXmlToResourceValue(tag));
    }

    @Nullable
    private ResourceValue parseXmlToResourceValue(final @Nullable XmlTag tag) {
        Object value2;
        if (tag == null || !tag.isValid()) {
            return null;
        }
        switch (this.myType) {
            case STYLE: {
                String parent = PsiResourceItem.getAttributeValue(tag, "parent");
                value2 = PsiResourceItem.parseStyleValue(tag, new StyleResourceValueImpl(this.getNamespace(), this.myName, parent, null));
                break;
            }
            case STYLEABLE: {
                value2 = this.parseDeclareStyleable(tag, new StyleableResourceValueImpl(this.getNamespace(), this.myName, null, null));
                break;
            }
            case ATTR: {
                value2 = PsiResourceItem.parseAttrValue(tag, new AttrResourceValueImpl(this.getNamespace(), this.myName, null));
                break;
            }
            case ARRAY: {
                value2 = PsiResourceItem.parseArrayValue(tag, new ArrayResourceValueImpl(this.getNamespace(), this.myName, null){

                    protected int getDefaultIndex() {
                        String index2 = tag.getAttributeValue("index", "http://schemas.android.com/tools");
                        if (index2 != null) {
                            return Integer.parseInt(index2);
                        }
                        return super.getDefaultIndex();
                    }
                });
                break;
            }
            case PLURALS: {
                value2 = PsiResourceItem.parsePluralsValue(tag, new PluralsResourceValueImpl(this.getNamespace(), this.myName, null, null){

                    public String getValue() {
                        String value2;
                        String quantity = tag.getAttributeValue("quantity", "http://schemas.android.com/tools");
                        if (quantity != null && (value2 = this.getValue(quantity)) != null) {
                            return value2;
                        }
                        return super.getValue();
                    }
                });
                break;
            }
            case STRING: {
                value2 = PsiResourceItem.parseTextValue(tag, new PsiTextResourceValue(this.getNamespace(), this.myName, null, null, null));
                break;
            }
            default: {
                value2 = PsiResourceItem.parseValue(tag, new ResourceValueImpl(this.getNamespace(), this.myType, this.myName, null));
            }
        }
        value2.setNamespaceResolver(IdeResourcesUtil.getNamespaceResolver((XmlElement)tag));
        return value2;
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag, @NotNull String attributeName) {
        return tag.getAttributeValue(attributeName);
    }

    @NotNull
    private StyleableResourceValueImpl parseDeclareStyleable(@NotNull XmlTag tag, @NotNull StyleableResourceValueImpl declareStyleable) {
        for (XmlTag child : tag.getSubTags()) {
            ResourceReference resolvedAttr;
            ResourceUrl url;
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name) || (url = ResourceUrl.parseAttrReference((String)name)) == null || (resolvedAttr = url.resolve(this.getNamespace(), IdeResourcesUtil.getNamespaceResolver((XmlElement)tag))) == null) continue;
            AttrResourceValueImpl attr = PsiResourceItem.parseAttrValue(child, new AttrResourceValueImpl(resolvedAttr, null));
            declareStyleable.addValue((AttrResourceValue)attr);
        }
        return declareStyleable;
    }

    @NotNull
    private static StyleResourceValueImpl parseStyleValue(@NotNull XmlTag tag, @NotNull StyleResourceValueImpl styleValue) {
        for (XmlTag child : tag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name)) continue;
            String value2 = ValueXmlHelper.unescapeResourceString((String)IdeResourcesUtil.getTextContent(child), (boolean)true, (boolean)true);
            StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(styleValue.getNamespace(), name, value2, styleValue.getLibraryName());
            itemValue.setNamespaceResolver(IdeResourcesUtil.getNamespaceResolver((XmlElement)child));
            styleValue.addItem((StyleItemResourceValue)itemValue);
        }
        return styleValue;
    }

    @NotNull
    private static AttrResourceValueImpl parseAttrValue(@NotNull XmlTag attrTag, @NotNull AttrResourceValueImpl attrValue) {
        attrValue.setDescription(PsiResourceItem.getDescription(attrTag));
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String formatString = PsiResourceItem.getAttributeValue(attrTag, "format");
        if (formatString != null) {
            formats.addAll(AttributeFormat.parse((String)formatString));
        }
        for (XmlTag child : attrTag.getSubTags()) {
            String tagName = child.getName();
            if ("enum".equals(tagName)) {
                formats.add(AttributeFormat.ENUM);
            } else if ("flag".equals(tagName)) {
                formats.add(AttributeFormat.FLAGS);
            }
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null) continue;
            Integer numericValue = null;
            String value2 = PsiResourceItem.getAttributeValue(child, "value");
            if (value2 != null) {
                try {
                    numericValue = Long.decode(value2).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            attrValue.addValue(name, numericValue, PsiResourceItem.getDescription(child));
        }
        attrValue.setFormats(formats);
        return attrValue;
    }

    @Nullable
    private static String getDescription(@NotNull XmlTag tag) {
        XmlComment comment = XmlUtil.findPreviousComment((PsiElement)tag);
        if (comment != null) {
            String text2 = comment.getCommentText();
            return text2.trim();
        }
        return null;
    }

    @NotNull
    private static ArrayResourceValueImpl parseArrayValue(@NotNull XmlTag tag, @NotNull ArrayResourceValueImpl arrayValue) {
        for (XmlTag child : tag.getSubTags()) {
            String text2 = ValueXmlHelper.unescapeResourceString((String)IdeResourcesUtil.getTextContent(child), (boolean)true, (boolean)true);
            arrayValue.addElement(text2);
        }
        return arrayValue;
    }

    @NotNull
    private static PluralsResourceValueImpl parsePluralsValue(@NotNull XmlTag tag, @NotNull PluralsResourceValueImpl value2) {
        for (XmlTag child : tag.getSubTags()) {
            String quantity = child.getAttributeValue("quantity");
            if (quantity == null) continue;
            String text2 = ValueXmlHelper.unescapeResourceString((String)IdeResourcesUtil.getTextContent(child), (boolean)true, (boolean)true);
            value2.addPlural(quantity, text2);
        }
        return value2;
    }

    @NotNull
    private static ResourceValueImpl parseValue(@NotNull XmlTag tag, @NotNull ResourceValueImpl value2) {
        String text2 = IdeResourcesUtil.getTextContent(tag);
        text2 = ValueXmlHelper.unescapeResourceString((String)text2, (boolean)true, (boolean)true);
        value2.setValue(text2);
        return value2;
    }

    @NotNull
    private static PsiTextResourceValue parseTextValue(@NotNull XmlTag tag, @NotNull PsiTextResourceValue value2) {
        String text2 = IdeResourcesUtil.getTextContent(tag);
        text2 = ValueXmlHelper.unescapeResourceString((String)text2, (boolean)true, (boolean)true);
        value2.setValue(text2);
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlTag getTag() {
        AsyncInitializationData initData = this.myAsyncInitData;
        if (initData == null) {
            return PsiResourceItem.validElementOrNull(this.myTagPointer == null ? null : (XmlTag)this.myTagPointer.getElement());
        }
        AsyncInitializationData asyncInitializationData = initData;
        synchronized (asyncInitializationData) {
            return PsiResourceItem.validElementOrNull(this.myTagPointer != null ? (XmlTag)this.myTagPointer.getElement() : initData.xmlTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiFile getPsiFile() {
        AsyncInitializationData initData = this.myAsyncInitData;
        if (initData == null) {
            return PsiResourceItem.validElementOrNull(this.myFilePointer == null ? null : (PsiFile)this.myFilePointer.getElement());
        }
        AsyncInitializationData asyncInitializationData = initData;
        synchronized (asyncInitializationData) {
            return PsiResourceItem.validElementOrNull(this.myFilePointer != null ? (PsiFile)this.myFilePointer.getElement() : initData.psiFile);
        }
    }

    private static <E extends PsiElement> E validElementOrNull(@Nullable E psiElement) {
        return psiElement == null || !psiElement.isValid() ? null : (E)psiElement;
    }

    public boolean wasTag(@NotNull XmlTag tag) {
        return this.myOriginalTag != null && tag == this.myOriginalTag.get() || tag == this.getTag();
    }

    public boolean recomputeValue() {
        if (this.myResourceValue == null) {
            return false;
        }
        this.myResourceValue = null;
        return true;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        PsiFile file2;
        MoreObjects.ToStringHelper helper2 = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.myName).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.myType);
        XmlTag tag = this.getTag();
        if (tag != null) {
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                helper2.add("tag", (Object)IdeResourcesUtil.getTextContent(tag));
            } else {
                helper2.add("tag", ReadAction.compute(() -> IdeResourcesUtil.getTextContent(tag)));
            }
        }
        if ((file2 = this.getPsiFile()) != null) {
            helper2.add("file", (Object)file2.getName());
        }
        return helper2.toString();
    }

    private class PsiTextResourceValue
    extends TextResourceValueImpl {
        PsiTextResourceValue(@NotNull ResourceNamespace namespace, @Nullable String name, @Nullable String textValue, @Nullable String rawXmlValue, String libraryName) {
            super(namespace, name, textValue, rawXmlValue, libraryName);
        }

        public String getRawXmlValue() {
            return (String)ReadAction.compute(() -> {
                XmlTag tag = PsiResourceItem.this.getTag();
                if (tag == null || !tag.isValid()) {
                    return this.getValue();
                }
                return tag.getValue().getText();
            });
        }
    }

    private static class AsyncInitializationData {
        @NotNull
        final PsiFile psiFile;
        @Nullable
        final XmlTag xmlTag;

        private AsyncInitializationData(@NotNull PsiFile file2, @Nullable XmlTag tag) {
            this.psiFile = file2;
            this.xmlTag = tag;
        }
    }
}

