/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.projectmodel.ResourceFolder;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.res.AndroidPluginVersion;
import com.android.tools.idea.resources.aar.AarProtoResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.resources.aar.AarSourceResourceRepository;
import com.android.tools.idea.resources.aar.CachingData;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\tRN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "", "()V", "myProtoRepositories", "Lcom/google/common/cache/Cache;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lcom/android/tools/idea/resources/aar/AarProtoResourceRepository;", "mySourceRepositories", "Lcom/android/projectmodel/ResourceFolder;", "Lcom/android/tools/idea/resources/aar/AarSourceResourceRepository;", "clear", "", "createCachingData", "Lcom/android/tools/idea/resources/aar/CachingData;", "library", "Lcom/android/projectmodel/ExternalLibrary;", "getProtoRepository", "getSourceRepository", "removeProtoRepository", "resApkFile", "removeSourceRepository", "resourceFolder", "Companion", "intellij.android.core"})
public final class AarResourceRepositoryCache {
    private final Cache<Path, AarProtoResourceRepository> myProtoRepositories = CacheBuilder.newBuilder().softValues().build();
    private final Cache<ResourceFolder, AarSourceResourceRepository> mySourceRepositories = CacheBuilder.newBuilder().softValues().build();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AarSourceResourceRepository getSourceRepository(@NotNull ExternalLibrary library) {
        Object object = library.getLocation();
        if (object == null || (object = object.getFileName()) == null) {
            object = library.getAddress();
        }
        Object libraryName = object;
        ResourceFolder resourceFolder = library.getResFolder();
        if (resourceFolder == null) {
            throw (Throwable)new IllegalArgumentException("No resources for " + (String)libraryName);
        }
        ResourceFolder resFolder = resourceFolder;
        if (resFolder.getRoot().toPath() == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find resource directory " + resFolder.getRoot() + " for " + (String)libraryName);
        }
        return (AarSourceResourceRepository)AarResourceRepositoryCache.Companion.getRepository(resFolder, (String)libraryName, this.mySourceRepositories, (Function0)new Function0<AarSourceResourceRepository>(this, resFolder, (String)libraryName, library){
            final /* synthetic */ AarResourceRepositoryCache this$0;
            final /* synthetic */ ResourceFolder $resFolder;
            final /* synthetic */ String $libraryName;
            final /* synthetic */ ExternalLibrary $library;

            public final AarSourceResourceRepository invoke() {
                return AarSourceResourceRepository.create(this.$resFolder, this.$libraryName, AarResourceRepositoryCache.access$createCachingData(this.this$0, this.$library));
            }
            {
                this.this$0 = aarResourceRepositoryCache;
                this.$resFolder = resourceFolder;
                this.$libraryName = string;
                this.$library = externalLibrary;
                super(0);
            }
        });
    }

    @NotNull
    public final AarProtoResourceRepository getProtoRepository(@NotNull ExternalLibrary library) {
        Object object = library.getLocation();
        if (object == null || (object = object.getFileName()) == null) {
            object = library.getAddress();
        }
        Object libraryName = object;
        PathString pathString = library.getResApkFile();
        if (pathString == null) {
            throw (Throwable)new IllegalArgumentException("No res.apk for " + (String)libraryName);
        }
        PathString resApkPath = pathString;
        Path path2 = resApkPath.toPath();
        if (path2 == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find " + resApkPath + " for " + (String)libraryName);
        }
        Path resApkFile = path2;
        return (AarProtoResourceRepository)AarResourceRepositoryCache.Companion.getRepository(resApkFile, (String)libraryName, this.myProtoRepositories, (Function0)new Function0<AarProtoResourceRepository>(resApkFile, (String)libraryName){
            final /* synthetic */ Path $resApkFile;
            final /* synthetic */ String $libraryName;

            public final AarProtoResourceRepository invoke() {
                return AarProtoResourceRepository.create(this.$resApkFile, this.$libraryName);
            }
            {
                this.$resApkFile = path2;
                this.$libraryName = string;
                super(0);
            }
        });
    }

    public final void removeProtoRepository(@NotNull Path resApkFile) {
        this.myProtoRepositories.invalidate((Object)resApkFile);
    }

    public final void removeSourceRepository(@NotNull ResourceFolder resourceFolder) {
        this.mySourceRepositories.invalidate((Object)resourceFolder);
    }

    public final void clear() {
        this.myProtoRepositories.invalidateAll();
        this.mySourceRepositories.invalidateAll();
    }

    private final CachingData createCachingData(ExternalLibrary library) {
        FileTime fileTime;
        ResourceFolder resFolder = library.getResFolder();
        if (resFolder == null || resFolder.getResources() != null) {
            return null;
        }
        try {
            Path path2 = resFolder.getRoot().toPath();
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            fileTime = Files.getLastModifiedTime(path2, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        FileTime modificationTime = fileTime;
        PathString pathString = library.getLocation();
        if (pathString != null) {
            fileTime = pathString;
            boolean e = false;
            boolean bl = false;
            FileTime it = fileTime;
            boolean bl2 = false;
            try {
                Comparable comparable = modificationTime;
                Path path3 = it.toPath();
                if (path3 == null) {
                    Intrinsics.throwNpe();
                }
                modificationTime = (FileTime)RangesKt.coerceAtLeast((Comparable)comparable, (Comparable)Files.getLastModifiedTime(path3, new LinkOption[0]));
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        }
        String contentVersion = modificationTime.toString();
        String string = AndroidPluginVersion.getAndroidPluginVersion();
        if (string == null) {
            return null;
        }
        String codeVersion = string;
        PathString path4 = resFolder.getRoot();
        String pathHash = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)path4.getPortablePath()).toString();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%s_%s.dat";
        Object[] objectArray = new Object[2];
        Object object = library.getLocation();
        if (object == null || (object = object.getFileName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        objectArray[1] = pathHash;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        String filename = string3;
        Path cacheFile = Paths.get(PathManager.getSystemPath(), "caches/resources", filename);
        return new CachingData(cacheFile, contentVersion, codeVersion, AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor());
    }

    private AarResourceRepositoryCache() {
    }

    public static final /* synthetic */ CachingData access$createCachingData(AarResourceRepositoryCache $this, ExternalLibrary library) {
        return $this.createCachingData(library);
    }

    @NotNull
    public static final AarResourceRepositoryCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JO\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\n\"\b\b\u0001\u0010\t*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/res/AarResourceRepositoryCache$Companion;", "", "()V", "instance", "Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "getRepository", "T", "K", "Lcom/android/tools/idea/resources/aar/AarResourceRepository;", "key", "libraryName", "", "cache", "Lcom/google/common/cache/Cache;", "factory", "Lkotlin/Function0;", "(Ljava/lang/Object;Ljava/lang/String;Lcom/google/common/cache/Cache;Lkotlin/jvm/functions/Function0;)Lcom/android/tools/idea/resources/aar/AarResourceRepository;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final AarResourceRepositoryCache getInstance() {
            return (AarResourceRepositoryCache)ServiceManager.getService(AarResourceRepositoryCache.class);
        }

        private final <K, T extends AarResourceRepository> T getRepository(K key, String libraryName, Cache<K, T> cache, Function0<? extends T> factory2) {
            AarResourceRepository aarRepository2 = (AarResourceRepository)CacheUtils.getAndUnwrap(cache, key, (Function0)new Function0<T>(factory2){
                final /* synthetic */ Function0 $factory;

                @NotNull
                public final T invoke() {
                    return (T)((AarResourceRepository)this.$factory.invoke());
                }
                {
                    this.$factory = function0;
                    super(0);
                }
            });
            if (Intrinsics.areEqual((Object)libraryName, (Object)aarRepository2.getLibraryName()) ^ true) {
                boolean bl = false;
                boolean bl2 = false;
                if (_Assertions.ENABLED) {
                    boolean bl3 = false;
                    String string = "Library name mismatch: " + libraryName + " vs " + aarRepository2.getLibraryName();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Logger logger2 = Logger.getInstance(AarResourceRepositoryCache.class);
                logger2.error((Throwable)new Exception("Library name mismatch: " + libraryName + " vs " + aarRepository2.getLibraryName()));
            }
            return (T)aarRepository2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

