/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.rendering.webp.WebpConversionDialog;
import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.android.tools.idea.rendering.webp.WebpConvertedFile;
import com.android.tools.idea.rendering.webp.WebpPreviewDialog;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConvertToWebpAction
extends DumbAwareAction {
    @Nls(capitalization=Nls.Capitalization.Title)
    public static final String TITLE = "Converting Images to WebP";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Module module2 = (Module)e.getData(LangDataKeys.MODULE);
        if (module2 == null) {
            module2 = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        }
        int minSdkVersion2 = Integer.MAX_VALUE;
        if (module2 != null) {
            AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(module2);
            if (info2 != null) {
                minSdkVersion2 = Math.min(minSdkVersion2, info2.getMinSdkVersion().getFeatureLevel());
            }
        } else {
            Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (modules != null) {
                for (Module m : modules) {
                    AndroidModuleInfo info3 = AndroidModuleInfo.getInstance(m);
                    if (info3 == null) continue;
                    minSdkVersion2 = Math.min(minSdkVersion2, info3.getMinSdkVersion().getFeatureLevel());
                }
            }
        }
        VirtualFile[] files2 = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        this.perform(project, minSdkVersion2, files2);
    }

    public void perform(@NotNull Project project, int minSdkVersion2, VirtualFile[] files2) {
        WebpConversionSettings settings = new WebpConversionSettings();
        settings.skipTransparentImages = minSdkVersion2 < 18;
        settings.allowLossless = minSdkVersion2 >= 18;
        boolean singleFile = files2.length == 1 && ConvertToWebpAction.isEligibleForConversion(files2[0], null);
        WebpConversionDialog dialog2 = new WebpConversionDialog(project, minSdkVersion2, settings, singleFile);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.toSettings(settings);
        this.convert(project, settings, true, Arrays.asList(files2));
    }

    private static boolean isResourceDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2.isDirectory()) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)file2.getName());
            if (folderType != null) {
                return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
            }
            return IdeResourcesUtil.isLocalResourceDirectory(file2, project);
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && e.getProject() != null) {
            for (VirtualFile file2 : files2) {
                boolean directory = file2.isDirectory();
                if ((!directory || !ConvertToWebpAction.isResourceDirectory(file2, e.getProject())) && (directory || !ConvertToWebpAction.isEligibleForConversion(file2, null))) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void convert(@NotNull Project project, @NotNull WebpConversionSettings settings, boolean showBalloon2, @NotNull Collection<VirtualFile> files2) {
        boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();
        WebpConversionTask task2 = new WebpConversionTask(project, settings, showBalloon2 && !isUnitTest, files2);
        if (isUnitTest) {
            task2.run((ProgressIndicator)new DumbProgressIndicator());
            settings.previewConversion = false;
            task2.onFinished();
        } else {
            ProgressManager.getInstance().run((Task)task2);
        }
    }

    public static boolean isEligibleForConversion(@Nullable VirtualFile file2, @Nullable WebpConversionSettings settings) {
        if (file2 != null && !file2.isDirectory()) {
            String name = file2.getName();
            if (name.endsWith(".png")) {
                if (settings != null && settings.skipNinePatches && SdkUtils.endsWithIgnoreCase((String)name, (String)".9.png")) {
                    return false;
                }
                if (settings != null && settings.skipTransparentImages) {
                    try {
                        BufferedImage image = ImageIO.read(file2.getInputStream());
                        if (image != null && ImageUtils.isNonOpaque((BufferedImage)image)) {
                            return false;
                        }
                    }
                    catch (IOException image) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name, (String)".jpg") || SdkUtils.endsWith((CharSequence)name, (CharSequence)".jpeg")) {
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name, (String)".bmp")) {
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name, (String)".gif")) {
                ImageReader is = ImageIO.getImageReadersBySuffix("GIF").next();
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(file2.getInputStream());
                    is.setInput(iis);
                    return is.getNumImages(true) == 1;
                }
                catch (IOException ignore) {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isNinePatchFile(@NotNull VirtualFile file2) {
        return file2.getName().endsWith(".9.png") && !file2.isDirectory();
    }

    static String formatSize(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " bytes";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = Character.toString("KMGTPE".charAt(exp - 1));
        return String.format(Locale.US, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    private static void refreshFolders(List<VirtualFile> toRefresh) {
        for (VirtualFile dir : toRefresh) {
            dir.refresh(true, true);
        }
    }

    @NotNull
    private static List<VirtualFile> computeParentFolders(@NotNull List<WebpConvertedFile> files2) {
        ArrayList toRefresh = Lists.newArrayList();
        for (WebpConvertedFile file2 : files2) {
            VirtualFile parent = file2.sourceFile.getParent();
            if (parent == null || toRefresh.contains(parent)) continue;
            toRefresh.add(parent);
        }
        return toRefresh;
    }

    static class WebpConversionTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final boolean myShowBalloon;
        private final Collection<VirtualFile> myFiles;
        private final WebpConversionSettings mySettings;
        private int myNinePatchCount;
        private int myLauncherIconCount;
        private int myTransparentCount;
        private int myFileCount;
        private long mySaved;
        private int mySkipped;
        private List<VirtualFile> myParentFolders;
        private List<WebpConvertedFile> myConvertedFiles;

        public WebpConversionTask(Project project, WebpConversionSettings settings, boolean showBalloon2, Collection<VirtualFile> files2) {
            super(project, ConvertToWebpAction.TITLE, true);
            this.mySettings = settings;
            this.myProject = project;
            this.myShowBalloon = showBalloon2;
            this.myFiles = files2;
        }

        public void onFinished() {
            if (this.mySettings.previewConversion && !this.mySettings.lossless && !this.myConvertedFiles.isEmpty()) {
                WebpPreviewDialog dialog2 = new WebpPreviewDialog(this, this.myProject, this.mySettings, this.myConvertedFiles);
                if (!dialog2.showAndGet()) {
                    return;
                }
                this.encode(this.myConvertedFiles, true);
            } else {
                this.encode(this.myConvertedFiles, false);
            }
            this.writeImages((Object)this, this.myProject, this.myConvertedFiles);
            if (this.myShowBalloon) {
                StringBuilder sb = new StringBuilder();
                if (this.myFiles.size() > 1 || this.myFileCount == 0) {
                    sb.append(Integer.toString(this.myFileCount)).append(" files were converted");
                }
                if (this.mySaved > 0L || this.myTransparentCount == 0 && this.myNinePatchCount == 0 && this.mySkipped == 0) {
                    sb.append("<br/>").append(ConvertToWebpAction.formatSize(this.mySaved)).append(" saved");
                }
                if (this.myNinePatchCount > 0) {
                    sb.append("<br>").append(Integer.toString(this.myNinePatchCount)).append(" 9-patch files were skipped");
                }
                if (this.myLauncherIconCount > 0) {
                    sb.append("<br>").append(Integer.toString(this.myLauncherIconCount)).append(" launcher icons were skipped");
                }
                if (this.myTransparentCount > 0) {
                    sb.append("<br>").append(Integer.toString(this.myTransparentCount)).append(" transparent images were skipped");
                }
                if (this.mySkipped > 0) {
                    sb.append("<br>").append(Integer.toString(this.mySkipped)).append(" files were skipped because there was no net space savings");
                }
                String message2 = sb.toString();
                new NotificationGroup("Convert to WebP", NotificationDisplayType.BALLOON, true, null, null, null, PluginId.getId((String)"org.jetbrains.android")).createNotification(message2, NotificationType.INFORMATION).notify(this.myProject);
            }
            ConvertToWebpAction.refreshFolders(this.myParentFolders);
        }

        private void writeImages(Object requestor, Project project, List<WebpConvertedFile> files2) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (WebpConvertedFile convertedFile : files2) {
                    try {
                        if (convertedFile.encoded == null) {
                            ++this.myTransparentCount;
                            continue;
                        }
                        if (this.mySettings.skipLargerImages && convertedFile.saved < 0L) {
                            ++this.mySkipped;
                            continue;
                        }
                        this.mySaved += convertedFile.saved;
                        ++this.myFileCount;
                        convertedFile.apply(requestor);
                    }
                    catch (IOException e) {
                        Logger.getInstance(ConvertToWebpAction.class).warn((Throwable)e);
                    }
                }
            });
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            LinkedList<VirtualFile> images = new LinkedList<VirtualFile>(this.myFiles);
            this.myConvertedFiles = this.findImages(progressIndicator, images);
            this.myParentFolders = ConvertToWebpAction.computeParentFolders(this.myConvertedFiles);
        }

        void encode(@NotNull List<WebpConvertedFile> files2, boolean skipAlreadyEncoded) {
            for (WebpConvertedFile file2 : files2) {
                if (skipAlreadyEncoded && file2.encoded != null) continue;
                if (this.mySettings.skipNinePatches && ConvertToWebpAction.isNinePatchFile(file2.sourceFile)) {
                    assert (false) : file2;
                    continue;
                }
                if (!file2.convert(this.mySettings)) {
                    assert (false) : file2;
                    continue;
                }
                if (this.mySettings.skipLargerImages && file2.saved < 0L) {
                    ++this.mySkipped;
                    continue;
                }
                this.mySaved += file2.saved;
                ++this.myFileCount;
            }
        }

        private Set<String> getLauncherIconNames(LinkedList<VirtualFile> roots) {
            HashSet modules = Sets.newHashSet();
            for (VirtualFile virtualFile : roots) {
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.myProject);
                if (module2 == null) continue;
                modules.add(module2);
            }
            if (modules.isEmpty()) {
                modules.addAll(Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()));
            }
            HashSet facets = Sets.newHashSet();
            for (Module module2 : modules) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                if (facet2 == null) continue;
                facets.add(facet2);
            }
            HashSet hashSet = Sets.newHashSet();
            for (AndroidFacet facet2 : facets) {
                Element element2;
                Document document = MergedManifestManager.getSnapshot(facet2).getDocument();
                if (document == null || document.getDocumentElement() == null || (element2 = XmlUtils.getFirstSubTagByName((Node)document.getDocumentElement(), (String)"application")) == null) continue;
                WebpConversionTask.addIcons(hashSet, element2);
                for (Element child : XmlUtils.getSubTags((Node)element2)) {
                    String tagName = child.getTagName();
                    if (!tagName.equals("activity") && !tagName.equals("activity-alias") && !tagName.equals("service") && !tagName.equals("provider") && !tagName.equals("receiver")) continue;
                    WebpConversionTask.addIcons(hashSet, element2);
                }
            }
            hashSet.add("ic_launcher_round");
            hashSet.add("ic_launcher");
            return hashSet;
        }

        private static void addIcons(Set<String> names, Element element2) {
            String icon2 = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
            if (icon2 != null) {
                if (icon2.startsWith("@drawable/")) {
                    names.add(icon2.substring("@drawable/".length()));
                } else if (icon2.startsWith("@mipmap/")) {
                    names.add(icon2.substring("@mipmap/".length()));
                }
            }
            if ((icon2 = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "roundIcon")) != null) {
                if (icon2.startsWith("@drawable/")) {
                    names.add(icon2.substring("@drawable/".length()));
                } else if (icon2.startsWith("@mipmap/")) {
                    names.add(icon2.substring("@mipmap/".length()));
                }
            }
        }

        @NotNull
        private List<WebpConvertedFile> findImages(@NotNull ProgressIndicator progressIndicator, @NotNull LinkedList<VirtualFile> images) {
            ArrayList files2 = Lists.newArrayList();
            Set<String> launcherIconNames = this.getLauncherIconNames(images);
            while (!images.isEmpty()) {
                progressIndicator.checkCanceled();
                VirtualFile file2 = images.pop();
                progressIndicator.setText(file2.getPath());
                if (file2.isDirectory()) {
                    for (VirtualFile f : file2.getChildren()) {
                        images.push(f);
                    }
                    continue;
                }
                if (!ConvertToWebpAction.isEligibleForConversion(file2, null)) continue;
                if (launcherIconNames.contains(Lint.getBaseName((String)file2.getName())) && file2.getParent() != null && (file2.getParent().getName().startsWith("drawable") || file2.getParent().getName().startsWith("mipmap"))) {
                    ++this.myLauncherIconCount;
                    continue;
                }
                if (ConvertToWebpAction.isEligibleForConversion(file2, this.mySettings)) {
                    WebpConvertedFile convertedFile = WebpConvertedFile.create(file2, this.mySettings);
                    if (convertedFile == null) continue;
                    files2.add(convertedFile);
                    continue;
                }
                if (this.mySettings.skipNinePatches && ConvertToWebpAction.isNinePatchFile(file2)) {
                    ++this.myNinePatchCount;
                    continue;
                }
                ++this.myTransparentCount;
            }
            return files2;
        }
    }
}

