/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.google.common.base.Suppliers;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    private final Function<ClassVisitor, ClassVisitor> myProjectClassesTransformationProvider;
    private final Function<ClassVisitor, ClassVisitor> myNonProjectClassesTransformationProvider;
    private final Object myJarClassLoaderLock = new Object();
    private final Function<String, String> myNonProjectClassNameLookup;
    private Supplier<UrlClassLoader> myJarClassLoader = Suppliers.memoize(() -> this.createJarClassLoader(this.getExternalJars()));
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(@Nullable ClassLoader parent, @NotNull Function<ClassVisitor, ClassVisitor> projectClassesTransformationProvider, @NotNull Function<ClassVisitor, ClassVisitor> nonProjectClassesTransformationProvider, @NotNull Function<String, String> nonProjectClassNameLookup) {
        super(parent);
        this.myProjectClassesTransformationProvider = projectClassesTransformationProvider;
        this.myNonProjectClassesTransformationProvider = nonProjectClassesTransformationProvider;
        this.myNonProjectClassNameLookup = nonProjectClassNameLookup;
    }

    public RenderClassLoader(@Nullable ClassLoader parent, @NotNull Function<ClassVisitor, ClassVisitor> transformationProvider) {
        this(parent, transformationProvider, transformationProvider, Function.identity());
    }

    public RenderClassLoader(@Nullable ClassLoader parent) {
        this(parent, Function.identity(), Function.identity(), Function.identity());
    }

    protected abstract List<URL> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        return this.loadClassFromNonProjectDependency(name);
    }

    @NotNull
    private UrlClassLoader createJarClassLoader(@NotNull List<URL> urls) {
        return new UrlClassLoader(UrlClassLoader.build().parent((ClassLoader)this).urls(urls).setLogErrorOnMissingJar(false)){

            public Enumeration<URL> getResources(String name) throws IOException {
                return this.findResources(name);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    protected Class<?> loadClassFromNonProjectDependency(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        Throwable throwable;
        InputStream is;
        block22: {
            block23: {
                UrlClassLoader jarClassLoaders;
                Object object = this.myJarClassLoaderLock;
                synchronized (object) {
                    jarClassLoaders = this.myJarClassLoader.get();
                }
                String diskLookupName = this.myNonProjectClassNameLookup.apply(name);
                this.myInsideJarClassLoader = true;
                is = jarClassLoaders.getResourceAsStream(diskLookupName.replace('.', '/') + ".class");
                throwable = null;
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                byte[] data = ByteStreams.toByteArray((InputStream)is);
                if (!ClassConverter.isValidClassFile(data)) {
                    throw new ClassFormatError(name);
                }
                byte[] rewritten = ClassConverter.rewriteClass(data, this.myNonProjectClassesTransformationProvider);
                clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
                if (is == null) break block22;
                if (throwable == null) break block23;
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block22;
            }
            is.close();
        }
        this.myInsideJarClassLoader = false;
        return clazz;
        catch (Throwable throwable3) {
            try {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    LOG.debug((Throwable)e);
                    this.myInsideJarClassLoader = false;
                }
            }
            catch (Throwable throwable6) {
                this.myInsideJarClassLoader = false;
                throw throwable6;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ClassNotFoundException(%s)", name));
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        try {
            byte[] data = classFile.contentsToByteArray();
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    protected Class<?> loadClass(@NotNull String fqcn, @NotNull byte[] data) {
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = ClassConverter.rewriteClass(data, this.myProjectClassesTransformationProvider);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Defining class '%s' from disk file", LogAnonymizerUtil.anonymizeClassName((String)fqcn)));
            }
            return this.defineClassAndPackage(fqcn, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            LOG.debug((Throwable)inner);
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
    }

    @NotNull
    protected Class<?> defineClassAndPackage(@NotNull String name, @NotNull byte[] b, int offset2, int len) {
        String packageName;
        Package pkg;
        int i2 = name.lastIndexOf(46);
        if (i2 > 0 && (pkg = this.getPackage(packageName = name.substring(0, i2))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return this.defineClass(name, b, offset2, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean areDependenciesUpToDate() {
        List currentDependencies;
        List<URL> updatedDependencies = this.getExternalJars();
        Object object = this.myJarClassLoaderLock;
        synchronized (object) {
            currentDependencies = this.myJarClassLoader.get().getUrls();
        }
        if (updatedDependencies.size() != currentDependencies.size()) {
            return false;
        }
        return currentDependencies.containsAll(updatedDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Object object = this.myJarClassLoaderLock;
        synchronized (object) {
            return this.myJarClassLoader.get().getResources(name);
        }
    }
}

