/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class ClassConverter {
    private static final int ourCurrentJdkClassVersion = ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);

    @NotNull
    static byte[] rewriteClass(@NotNull byte[] classData, @NotNull Function<ClassVisitor, ClassVisitor> getTransformations) {
        ClassWriter classWriter = new ClassWriter(1);
        ClassVisitor classVisitor = getTransformations.apply((ClassVisitor)classWriter);
        ClassReader reader = new ClassReader(classData);
        reader.accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    public static int jdkToClassVersion(@NotNull String version2) {
        JavaVersion javaVersion = JavaVersion.tryParse((String)version2);
        return javaVersion != null ? javaVersion.feature + 44 : -1;
    }

    public static String classVersionToJdk(int version2) {
        if (version2 >= 53) {
            return Integer.toString(version2 - 53 + 9);
        }
        return "1." + Integer.toString(version2 - 44);
    }

    public static int findHighestMajorVersion(Collection<Throwable> list) {
        int result2 = 0;
        for (Throwable t : list) {
            if (!(t instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)t;
            result2 = Math.max(result2, error.getMajor());
        }
        return result2;
    }

    public static String getCurrentJdkVersion() {
        String version2 = SystemInfo.JAVA_VERSION;
        int suffix = version2.indexOf(95);
        if (suffix != -1) {
            version2 = version2.substring(0, suffix);
        }
        return version2;
    }

    public static int getCurrentClassVersion() {
        return ourCurrentJdkClassVersion;
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        return Ints.fromBytes((byte)classData[0], (byte)classData[1], (byte)classData[2], (byte)classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[6], (byte)classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[4], (byte)classData[5]);
    }
}

