/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final Icon NONE = AndroidIcons.Android;
    @VisibleForTesting
    static final int MAX_WIDTH = JBUI.scale((int)16);
    @VisibleForTesting
    static final int MAX_HEIGHT = JBUI.scale((int)16);
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private Map<String, Long> myModificationStampCache = Maps.newHashMap();
    private boolean myRetina;

    @NotNull
    public static GutterIconCache getInstance() {
        return ourInstance;
    }

    @VisibleForTesting
    boolean isIconUpToDate(@NotNull VirtualFile file2) {
        String path2 = file2.getPath();
        if (this.myModificationStampCache.containsKey(path2)) {
            return this.myModificationStampCache.get(path2).longValue() == file2.getModificationStamp() && !FileDocumentManager.getInstance().isFileModified(file2);
        }
        return false;
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file2, @Nullable RenderResources resolver, @NotNull AndroidFacet facet2) {
        String path2;
        Icon myIcon;
        boolean isRetina = UIUtil.isRetina();
        if (this.myRetina != isRetina) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path2 = file2.getPath())) == null || !this.isIconUpToDate(file2)) {
            myIcon = GutterIconFactory.createIcon(file2, resolver, MAX_WIDTH, MAX_HEIGHT, facet2);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path2, myIcon);
            this.myModificationStampCache.put(path2, file2.getModificationStamp());
        }
        return myIcon != NONE ? myIcon : null;
    }
}

