/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.SdkSyncUtil;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.post.ComposeInBetaChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.MemorySettingsPostSyncChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.projectsystem.gradle.sync.AndroidModuleDataServiceKt;
import com.android.tools.idea.run.RunConfigurationChecker;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J@\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J6\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J6\u0010\u001a\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/sync/AndroidModuleDataService;", "Lcom/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService;", "Lcom/android/tools/idea/gradle/project/model/AndroidModuleModel;", "()V", "myModuleValidatorFactory", "Lcom/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$Factory;", "(Lcom/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$Factory;)V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "modelsByModuleName", "", "", "onSuccessImport", "imported", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "postProcess", "", "intellij.android.projectSystem.gradle.sync"})
public final class AndroidModuleDataService
extends ModuleModelDataService<AndroidModuleModel> {
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;

    @NotNull
    public Key<AndroidModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.ANDROID_MODEL;
    }

    @Override
    public void importData(@NotNull Collection<? extends DataNode<AndroidModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, ? extends AndroidModuleModel> modelsByModuleName) {
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(project);
        for (Module module2 : modelsProvider.getModules()) {
            AndroidModuleModel androidModel = modelsByModuleName.get(module2.getName());
            if (androidModel != null) {
                AndroidFacet androidFacet = (AndroidFacet)modelsProvider.getModifiableFacetModel(module2).getFacetByType(AndroidFacet.ID);
                if (androidFacet == null) {
                    androidFacet = AndroidModuleDataServiceKt.access$createAndroidFacet(module2, modelsProvider);
                }
                AndroidFacet androidFacet2 = androidFacet;
                androidModel.setModule(module2);
                AndroidModuleDataServiceKt.access$configureFacet(androidFacet2, androidModel);
                LanguageLevel languageLevel = androidModel.getJavaLanguageLevel();
                if (languageLevel != null) {
                    ((LanguageLevelModuleExtension)modelsProvider.getModifiableRootModel(module2).getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(languageLevel);
                }
                moduleValidator.validate(module2, androidModel);
                continue;
            }
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module2);
            Facets.removeAllFacets(facetModel, AndroidFacet.ID);
        }
        Map<String, ? extends AndroidModuleModel> map2 = modelsByModuleName;
        int n = 0;
        if (!map2.isEmpty()) {
            moduleValidator.fixAndReportFoundIssues();
        }
    }

    public void postProcess(@NotNull Collection<DataNode<AndroidModuleModel>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        super.postProcess(toImport, projectData, project, modelsProvider);
        for (DataNode<AndroidModuleModel> nodeToImport : toImport) {
            Module mainIdeModule;
            DataNode mainModuleDataNode;
            if (ExternalSystemApiUtil.findParent(nodeToImport, (Key)ProjectKeys.MODULE) == null) {
                continue;
            }
            ModuleData mainModuleData = (ModuleData)mainModuleDataNode.getData();
            if (modelsProvider.findIdeModule(mainModuleData) == null) {
                continue;
            }
            AndroidModuleModel androidModel = (AndroidModuleModel)nodeToImport.getData();
            Sdk sdkToUse = SdkSyncUtil.computeSdkReloadingAsNeeded(AndroidSdks.getInstance(), project, androidModel.getAndroidProject().getName(), androidModel.getAndroidProject().getCompileTarget(), androidModel.getAndroidProject().getBootClasspath(), IdeSdks.getInstance());
            if (sdkToUse == null) continue;
            modelsProvider.getModifiableRootModel(mainIdeModule).setSdk(sdkToUse);
        }
    }

    public void onSuccessImport(@NotNull Collection<? extends DataNode<AndroidModuleModel>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        GradleProjectInfo.getInstance(project).setNewProject(false);
        GradleProjectInfo.getInstance(project).setImportedProject(false);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                if (GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(this.$project, null, null, 6, null)) {
                    GradlePluginUpgrade.recommendPluginUpgrade(this.$project);
                }
            }
            {
                this.$project = project;
            }
        });
        if (IdeInfo.getInstance().isAndroidStudio()) {
            ComposeInBetaChecker.checkIfComposeProject(project);
            MemorySettingsPostSyncChecker.checkSettings(project, new TimeBasedReminder(project, "memory.settings.postsync", TimeUnit.DAYS.toMillis(1L)));
        }
        new ProjectStructureUsageTracker(project).trackProjectStructure();
        SupportedModuleChecker.getInstance().checkForSupportedModules(project);
        ConflictSet.findConflicts(project).showSelectionConflicts();
        new ProjectSetup(project).setUpProject(false);
        AndroidModuleDataServiceKt.access$modifyJUnitRunConfigurations(project);
        RunConfigurationChecker.getInstance(project).ensureRunConfigsInvokeBuild();
        ProjectStructure.getInstance(project).analyzeProjectStructure();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, project, "Setting up modules..."){
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                ModuleSetup.setUpModules(this.$project);
            }
            {
                this.$project = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2);
            }
        });
    }

    @VisibleForTesting
    public AndroidModuleDataService(@NotNull AndroidModuleValidator.Factory myModuleValidatorFactory) {
        this.myModuleValidatorFactory = myModuleValidatorFactory;
    }

    public AndroidModuleDataService() {
        this(new AndroidModuleValidator.Factory());
    }
}

