/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEventResult;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueFileEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.Failure;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncMessages
implements Disposable {
    private Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final HashMap<Object, List<NotificationData>> myCurrentNotifications = new HashMap();
    @NotNull
    private final HashMap<Object, List<Failure>> myShownFailures = new HashMap();
    @NotNull
    private static final String PENDING_TASK_ID = "Pending taskId";

    protected AbstractSyncMessages(@NotNull Project project) {
        this.myProject = project;
    }

    public int getErrorCount() {
        return this.countNotifications(notification -> notification.getNotificationCategory() == NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        return this.countNotifications(notification -> notification.getTitle().equals(groupName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getErrorDescription() {
        LinkedHashSet<String> errorGroups = new LinkedHashSet<String>();
        Object object = this.myLock;
        synchronized (object) {
            for (List<NotificationData> notificationDataList : this.myCurrentNotifications.values()) {
                for (NotificationData notificationData : notificationDataList) {
                    if (notificationData.getNotificationCategory() != NotificationCategory.ERROR) continue;
                    errorGroups.add(notificationData.getTitle());
                }
            }
        }
        return String.join((CharSequence)", ", errorGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countNotifications(@NotNull Predicate<NotificationData> condition) {
        int total = 0;
        Object object = this.myLock;
        synchronized (object) {
            for (List<NotificationData> notificationDataList : this.myCurrentNotifications.values()) {
                for (NotificationData notificationData : notificationDataList) {
                    if (!condition.test(notificationData)) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentNotifications.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentNotifications.clear();
        }
    }

    public void report(@NotNull SyncMessage message2) {
        String title = message2.getGroup();
        String text2 = StringUtil.join((String[])message2.getText(), (String)"\n");
        NotificationCategory category = message2.getType().convertToCategory();
        PositionInFile position = message2.getPosition();
        NotificationData notification = this.createNotification(title, text2, category, position);
        Navigatable navigatable = message2.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message2.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text2, quickFixes);
        }
        this.report(notification, ContainerUtil.map(quickFixes, it -> new AndroidSyncIssueQuickFix((NotificationHyperlink)it)));
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text2, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            return new NotificationData(title, text2, category, source, filePath, position.line, position.column, false);
        }
        return new NotificationData(title, text2, category, source);
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text2, @NotNull List<NotificationHyperlink> quickFixes) {
        String message2 = text2;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i2 = 0; i2 < hyperlinkCount; ++i2) {
                b.append(quickFixes.get(i2).toHtml());
                if (i2 >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message2 = message2 + '\n' + b.toString();
        }
        notification.setMessage(message2);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NotNull NotificationData notification, @NotNull List<? extends BuildIssueQuickFix> quickFixes) {
        Object taskId = GradleSyncState.getInstance(this.myProject).getExternalSystemTaskId();
        if (taskId == null) {
            taskId = PENDING_TASK_ID;
        } else {
            this.showNotification(notification, taskId, quickFixes);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentNotifications.computeIfAbsent(taskId, key -> new ArrayList()).add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotification(@NotNull NotificationData notification, @NotNull Object taskId, @NotNull List<? extends BuildIssueQuickFix> quickFixes) {
        AndroidSyncIssueEvent issueEvent;
        String title = notification.getTitle();
        String[] lines2 = notification.getMessage().split(SystemProperties.getLineSeparator());
        if (lines2.length > 0) {
            title = lines2[0];
        }
        if ((issueEvent = notification.getFilePath() != null ? new AndroidSyncIssueFileEvent(taskId, notification, title, quickFixes) : new AndroidSyncIssueEvent(taskId, notification, title, quickFixes)).getKind() == MessageEvent.Kind.ERROR) {
            Object object = this.myLock;
            synchronized (object) {
                this.myShownFailures.computeIfAbsent(taskId, key -> new ArrayList()).addAll(((AndroidSyncIssueEventResult)issueEvent.getResult()).getFailures());
            }
        } else {
            ((SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class)).onEvent(taskId, (BuildEvent)issueEvent);
        }
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    public void dispose() {
        this.myProject = null;
    }
}

