/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurations {
    @NotNull
    public static AndroidRunConfigurations getInstance() {
        return (AndroidRunConfigurations)ServiceManager.getService(AndroidRunConfigurations.class);
    }

    public void createRunConfiguration(@NotNull AndroidFacet facet2) {
        Module module2 = facet2.getModule();
        ConfigurationFactory configurationFactory = AndroidRunConfigurationType.getInstance().getFactory();
        List configurations = RunManager.getInstance((Project)module2.getProject()).getConfigurationsList(configurationFactory.getType());
        for (RunConfiguration configuration : configurations) {
            if (!(configuration instanceof AndroidRunConfiguration) || ((JavaRunConfigurationModule)((AndroidRunConfiguration)configuration).getConfigurationModule()).getModule() != module2) continue;
            return;
        }
        this.addRunConfiguration(facet2, TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX);
    }

    public void addRunConfiguration(@NotNull AndroidFacet facet2, @Nullable TargetSelectionMode targetSelectionMode) {
        Module module2 = facet2.getModule();
        RunManager runManager = RunManager.getInstance((Project)module2.getProject());
        String projectNameInExternalSystemStyle = PathUtil.suggestFileName((String)module2.getProject().getName(), (boolean)true, (boolean)false);
        String configurationName = StringsKt.removePrefix((String)module2.getName(), (CharSequence)(projectNameInExternalSystemStyle + "."));
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(configurationName, AndroidRunConfigurationType.class);
        AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
        configuration.setModule(module2);
        if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4) {
            configuration.setLaunchUrl(InstantApps.getDefaultInstantAppUrl(facet2));
        } else {
            configuration.MODE = LaunchUtils.isWatchFaceApp(facet2) ? "do_nothing" : "default_activity";
        }
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
        if (!module2.getProject().isDisposed()) {
            runManager.addConfiguration(settings);
            runManager.setSelectedConfiguration(settings);
        }
    }
}

