/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectInfo {
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidProjectInfo getInstance(@NotNull Project project) {
        return (AndroidProjectInfo)ServiceManager.getService((Project)project, AndroidProjectInfo.class);
    }

    public AndroidProjectInfo(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<Module> getAllModulesOfProjectType(int projectType) {
        List androidModules = ProjectFacetManager.getInstance((Project)this.myProject).getModulesWithFacet(AndroidFacet.ID);
        return ContainerUtil.filter((Collection)androidModules, module2 -> {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            return facet2 != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == projectType;
        });
    }

    public boolean requiresAndroidModel() {
        List androidFacets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
        return ContainerUtil.exists((Iterable)androidFacets, f -> AndroidModel.isRequired(f));
    }

    public boolean isApkProject() {
        if (ApkDebugging.isMarkedAsApkDebuggingProject(this.myProject)) {
            return true;
        }
        if (ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(ApkFacet.getFacetTypeId())) {
            ApkDebugging.markAsApkDebuggingProject(this.myProject);
            return true;
        }
        return false;
    }

    public boolean requiredAndroidModelMissing() {
        List androidFacets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
        return ContainerUtil.exists((Iterable)androidFacets, f -> AndroidModel.isRequired(f) && AndroidModel.get(f) == null);
    }

    public boolean isLegacyIdeaAndroidProject() {
        List androidFacets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
        return ContainerUtil.exists((Iterable)androidFacets, f -> !AndroidModel.isRequired(f));
    }
}

