/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.analytics;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.util.DeviceUtils;
import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Energy;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.analytics.energy.EnergyRangeMetadata;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AdtUiBoxSelectionMetadata;
import com.google.wireless.android.sdk.stats.AdtUiTrackGroupMetadata;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CpuApiTracingMetadata;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuImportTraceMetadata;
import com.google.wireless.android.sdk.stats.CpuProfilingConfig;
import com.google.wireless.android.sdk.stats.CpuStartupProfilingMetadata;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.EnergyEvent;
import com.google.wireless.android.sdk.stats.EnergyEventCount;
import com.google.wireless.android.sdk.stats.EnergyEventMetadata;
import com.google.wireless.android.sdk.stats.EnergyRangeMetadata;
import com.google.wireless.android.sdk.stats.FilterMetadata;
import com.google.wireless.android.sdk.stats.MemoryInstanceFilterMetadata;
import com.google.wireless.android.sdk.stats.ProfilerSessionCreationMetaData;
import com.google.wireless.android.sdk.stats.ProfilerSessionSelectionMetaData;
import com.google.wireless.android.sdk.stats.TraceProcessorDaemonManagerStats;
import com.google.wireless.android.sdk.stats.TraceProcessorDaemonQueryStats;
import com.google.wireless.android.sdk.stats.TransportFailureMetadata;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFeatureTracker
implements FeatureTracker {
    @Nullable
    private Common.Device myActiveDevice;
    @Nullable
    private Common.Process myActiveProcess;
    @NotNull
    private final Project myTrackingProject;
    private final ImmutableMap<Class<? extends Stage>, AndroidProfilerEvent.Stage> STAGE_MAP = ImmutableMap.builder().put(NullMonitorStage.class, (Object)AndroidProfilerEvent.Stage.NULL_STAGE).put(StudioMonitorStage.class, (Object)AndroidProfilerEvent.Stage.OVERVIEW_STAGE).put(CpuProfilerStage.class, (Object)AndroidProfilerEvent.Stage.CPU_STAGE).put(CpuCaptureStage.class, (Object)AndroidProfilerEvent.Stage.CPU_CAPTURE_STAGE).put(MemoryProfilerStage.class, (Object)AndroidProfilerEvent.Stage.MEMORY_STAGE).put(NetworkProfilerStage.class, (Object)AndroidProfilerEvent.Stage.NETWORK_STAGE).put(EnergyProfilerStage.class, (Object)AndroidProfilerEvent.Stage.ENERGY_STAGE).build();
    private final ImmutableMap<Common.SessionMetaData.SessionType, ProfilerSessionCreationMetaData.SessionType> SESSION_TYPE_MAP = ImmutableMap.of((Object)Common.SessionMetaData.SessionType.FULL, (Object)ProfilerSessionCreationMetaData.SessionType.FULL_SESSION, (Object)Common.SessionMetaData.SessionType.MEMORY_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.MEMORY_CAPTURE, (Object)Common.SessionMetaData.SessionType.CPU_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.CPU_CAPTURE);
    private final ImmutableMap<SessionsManager.SessionCreationSource, ProfilerSessionCreationMetaData.CreationSource> SESSION_CREATION_SOURCE_MAP = ImmutableMap.of((Object)SessionsManager.SessionCreationSource.MANUAL, (Object)ProfilerSessionCreationMetaData.CreationSource.MANUAL);
    private final ImmutableMap<Class<? extends SessionArtifact>, ProfilerSessionSelectionMetaData.ArtifactType> SESSION_ARTIFACT_MAP = ImmutableMap.of(SessionItem.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_SESSION, HprofSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_HPROF, CpuCaptureSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_CPU_CAPTURE, LegacyAllocationsSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_LEGACY_ALLOCATIONS);
    private final ImmutableMap<Class<? extends Exception>, TransportFailureMetadata.FailureType> TRANSPORT_FAILURE_MAP = ImmutableMap.builder().put(TimeoutException.class, (Object)TransportFailureMetadata.FailureType.TIMEOUT).put(InterruptedException.class, (Object)TransportFailureMetadata.FailureType.INTERRUPTED).put(IOException.class, (Object)TransportFailureMetadata.FailureType.IO).put(SyncException.class, (Object)TransportFailureMetadata.FailureType.SYNC).put(ShellCommandUnresponsiveException.class, (Object)TransportFailureMetadata.FailureType.SHELL_COMMAND_UNRESPONSIVE).put(AdbCommandRejectedException.class, (Object)TransportFailureMetadata.FailureType.ADB_COMMAND_REJECTED).build();
    private static final ImmutableMap<CpuCaptureMetadata.CaptureStatus, CpuCaptureMetadata.CaptureStatus> CPU_CAPTURE_STATUS_MAP = ImmutableMap.builder().put((Object)CpuCaptureMetadata.CaptureStatus.SUCCESS, (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING, (Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING).put((Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE).build();
    private final ImmutableMap<Class<? extends CaptureObjectInstanceFilter>, MemoryInstanceFilterMetadata.FilterType> MEMORY_INSTANCE_FILTER_MAP = ImmutableMap.builder().put(ActivityFragmentLeakInstanceFilter.class, (Object)MemoryInstanceFilterMetadata.FilterType.ACTIVITY_FRAGMENT_LEAKS).put(ProjectClassesInstanceFilter.class, (Object)MemoryInstanceFilterMetadata.FilterType.PROJECT_CLASSES).build();
    @NotNull
    private AndroidProfilerEvent.Stage myCurrStage = AndroidProfilerEvent.Stage.UNKNOWN_STAGE;

    public StudioFeatureTracker(@NotNull Project trackingProject) {
        this.myTrackingProject = trackingProject;
    }

    public void trackPreTransportDaemonStarts(@NotNull Common.Device transportDevice) {
        this.newTracker(AndroidProfilerEvent.Type.PRE_TRANSPORT_DAEMON_STARTS).setDevice(transportDevice).track();
    }

    public void trackTransportDaemonFailed(@NotNull Common.Device transportDevice, Exception exception) {
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_DAEMON_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackTransportProxyCreationFailed(@NotNull Common.Device transportDevice, Exception exception) {
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_PROXY_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackProfilerInitializationFailed() {
        this.track(AndroidProfilerEvent.Type.PROFILER_INITIALIZATION_FAILED);
    }

    public void trackEnterStage(@NotNull Class<? extends Stage> stage) {
        this.myCurrStage = (AndroidProfilerEvent.Stage)this.STAGE_MAP.getOrDefault(stage, (Object)AndroidProfilerEvent.Stage.UNKNOWN_STAGE);
        this.track(AndroidProfilerEvent.Type.STAGE_ENTERED);
    }

    public void trackRunWithProfiling() {
        this.track(AndroidProfilerEvent.Type.RUN_WITH_PROFILING);
    }

    public void trackAutoProfilingRequested() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_REQUESTED);
    }

    public void trackAutoProfilingSucceeded() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_SUCCEEDED);
    }

    public void trackProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackAdvancedProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.ADVANCED_PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackChangeDevice(@Nullable Common.Device device) {
        if (this.myActiveDevice != device) {
            this.myActiveDevice = device;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_DEVICE).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackChangeProcess(@Nullable Common.Process process) {
        if (this.myActiveProcess != process) {
            this.myActiveProcess = process;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_PROCESS).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackSessionDropdownClicked() {
        this.track(AndroidProfilerEvent.Type.SESSION_DROPDOWN_CLICKED);
    }

    public void trackCreateSession(Common.SessionMetaData.SessionType sessionType, SessionsManager.SessionCreationSource sourceType) {
        ProfilerSessionCreationMetaData.Builder builder2 = ProfilerSessionCreationMetaData.newBuilder().setCreatedType((ProfilerSessionCreationMetaData.SessionType)this.SESSION_TYPE_MAP.getOrDefault((Object)sessionType, (Object)ProfilerSessionCreationMetaData.SessionType.UNKNOWN_SESSION)).setCreationSource((ProfilerSessionCreationMetaData.CreationSource)this.SESSION_CREATION_SOURCE_MAP.getOrDefault((Object)sourceType, (Object)ProfilerSessionCreationMetaData.CreationSource.UNKNOWN_SOURCE));
        this.newTracker(AndroidProfilerEvent.Type.SESSION_CREATED).setSessionCreationMetadata(builder2.build()).track();
    }

    public void trackStopSession() {
        this.track(AndroidProfilerEvent.Type.SESSION_STOPPED);
    }

    public void trackSessionsPanelStateChanged(boolean isExpanded) {
        this.track(isExpanded ? AndroidProfilerEvent.Type.SESSION_UI_EXPANDED : AndroidProfilerEvent.Type.SESSION_UI_COLLAPSED);
    }

    public void trackSessionsPanelResized() {
        this.track(AndroidProfilerEvent.Type.SESSION_UI_RESIZED);
    }

    public void trackSessionArtifactSelected(@NotNull SessionArtifact artifact, boolean isSessionLive) {
        ProfilerSessionSelectionMetaData.Builder builder2 = ProfilerSessionSelectionMetaData.newBuilder().setSelectedType((ProfilerSessionSelectionMetaData.ArtifactType)this.SESSION_ARTIFACT_MAP.getOrDefault(artifact.getClass(), (Object)ProfilerSessionSelectionMetaData.ArtifactType.UNKNOWN_ARTIFACT_TYPE)).setIsSessionAlive(isSessionLive);
        this.newTracker(AndroidProfilerEvent.Type.SESSION_ARTIFACT_SELECTED).setSessionSelectionMetadata(builder2.build()).track();
    }

    public void trackGoBack() {
        this.track(AndroidProfilerEvent.Type.GO_BACK);
    }

    public void trackSelectMonitor() {
        this.track(AndroidProfilerEvent.Type.SELECT_MONITOR);
    }

    public void trackZoomIn() {
        this.track(AndroidProfilerEvent.Type.ZOOM_IN);
    }

    public void trackZoomOut() {
        this.track(AndroidProfilerEvent.Type.ZOOM_OUT);
    }

    public void trackResetZoom() {
        this.track(AndroidProfilerEvent.Type.ZOOM_RESET);
    }

    public void trackZoomToSelection() {
        this.track(AndroidProfilerEvent.Type.ZOOM_TO_SELECTION);
    }

    public void trackToggleStreaming() {
        this.track(AndroidProfilerEvent.Type.GO_LIVE);
    }

    public void trackNavigateToCode() {
        this.track(AndroidProfilerEvent.Type.NAVIGATE_TO_CODE);
    }

    public void trackSelectCpuKernelElement() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_CLICKED);
    }

    public void trackToggleCpuKernelHideablePanel() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_TOGGLED);
    }

    public void trackToggleCpuThreadsHideablePanel() {
        this.track(AndroidProfilerEvent.Type.THREADS_VIEW_TOGGLED);
    }

    public void trackSelectRange() {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_RANGE).setDevice(this.myActiveDevice).track();
    }

    public void trackCaptureTrace(@NotNull com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_TRACE).setDevice(this.myActiveDevice).setCpuCaptureMetadata(cpuCaptureMetadata).track();
    }

    public void trackImportTrace(@NotNull Cpu.CpuTraceType profilerType, boolean success2) {
        CpuImportTraceMetadata.Builder metadata = CpuImportTraceMetadata.newBuilder();
        metadata.setImportStatus(success2 ? CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_SUCCESS : CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_FAILURE);
        switch (profilerType) {
            case ART: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ART_TECHNOLOGY);
                break;
            }
            case SIMPLEPERF: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.SIMPLEPERF_TECHNOLOGY);
                break;
            }
            case ATRACE: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ATRACE_TECHNOLOGY);
                break;
            }
            default: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.UNKNOWN_TECHNOLOGY);
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.CPU_IMPORT_TRACE).setDevice(this.myActiveDevice).setCpuImportTraceMetadata(metadata.build()).track();
    }

    public void trackCpuStartupProfiling(@NotNull Common.Device device, @NotNull ProfilingConfiguration configuration) {
        this.newTracker(AndroidProfilerEvent.Type.CPU_STARTUP_PROFILING).setDevice(device).setCpuStartupProfilingConfiguration(configuration).track();
    }

    public void trackCpuApiTracing(boolean sampling, boolean pathProvided, int bufferSize, int flags, int intervalUs) {
        CpuApiTracingMetadata metadata = CpuApiTracingMetadata.newBuilder().setUseSampling(sampling).setArgTracePath(pathProvided).setArgBufferSize(bufferSize).setArgFlags(flags).setArgIntervalUs(intervalUs).build();
        this.newTracker(AndroidProfilerEvent.Type.CPU_API_TRACING).setDevice(this.myActiveDevice).setCpuApiTracingMetadata(metadata).track();
    }

    public void trackSelectThread() {
        this.track(AndroidProfilerEvent.Type.SELECT_THREAD);
    }

    public void trackSelectCaptureTopDown() {
        this.track(AndroidProfilerEvent.Type.SELECT_TOP_DOWN);
    }

    public void trackSelectCaptureBottomUp() {
        this.track(AndroidProfilerEvent.Type.SELECT_BOTTOM_UP);
    }

    public void trackSelectCaptureFlameChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_FLAME_CHART);
    }

    public void trackSelectCaptureCallChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_CALL_CHART);
    }

    public void trackForceGc() {
        this.track(AndroidProfilerEvent.Type.FORCE_GC);
    }

    public void trackDumpHeap() {
        this.track(AndroidProfilerEvent.Type.SNAPSHOT_HPROF);
    }

    public void trackRecordAllocations() {
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_ALLOCATIONS).setDevice(this.myActiveDevice).track();
    }

    public void trackExportHeap() {
        this.track(AndroidProfilerEvent.Type.EXPORT_HPROF);
    }

    public void trackExportAllocation() {
        this.track(AndroidProfilerEvent.Type.EXPORT_ALLOCATION);
    }

    public void trackChangeClassArrangment() {
        this.track(AndroidProfilerEvent.Type.ARRANGE_CLASSES);
    }

    public void trackSelectMemoryStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_STACK);
    }

    public void trackSelectMemoryReferences() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_REFERENCES);
    }

    public void trackSelectMemoryHeap(@NotNull String heapName) {
        AndroidProfilerEvent.MemoryHeap heapType;
        switch (heapName) {
            case "default": {
                heapType = AndroidProfilerEvent.MemoryHeap.DEFAULT_HEAP;
                break;
            }
            case "app": {
                heapType = AndroidProfilerEvent.MemoryHeap.APP_HEAP;
                break;
            }
            case "image": {
                heapType = AndroidProfilerEvent.MemoryHeap.IMAGE_HEAP;
                break;
            }
            case "zygote": {
                heapType = AndroidProfilerEvent.MemoryHeap.ZYGOTE_HEAP;
                break;
            }
            case "JNI": {
                heapType = AndroidProfilerEvent.MemoryHeap.JNI_HEAP;
                break;
            }
            case "Native": {
                heapType = AndroidProfilerEvent.MemoryHeap.NATIVE_HEAP;
                break;
            }
            default: {
                StudioFeatureTracker.getLogger().error("Attempt to report selection of unknown heap name: " + heapName);
                return;
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_MEMORY_HEAP).setMemoryHeapId(heapType).track();
    }

    public void trackSelectNetworkRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTION);
    }

    public void trackSelectNetworkDetailsOverview() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_OVERVIEW);
    }

    public void trackSelectNetworkDetailsHeaders() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_HEADERS);
    }

    public void trackSelectNetworkDetailsResponse() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_RESPONSE);
    }

    public void trackSelectNetworkDetailsRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_REQUEST);
    }

    public void trackSelectNetworkDetailsStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_STACK);
    }

    public void trackSelectNetworkDetailsError() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_ERROR);
    }

    public void trackSelectNetworkConnectionsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_CONNECTION_VIEW);
    }

    public void trackSelectNetworkThreadsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_THREADS_VIEW);
    }

    public void trackOpenProfilingConfigDialog() {
        this.track(AndroidProfilerEvent.Type.OPEN_CPU_CONFIG_DIALOG);
    }

    public void trackCreateCustomProfilingConfig() {
        this.track(AndroidProfilerEvent.Type.CREATE_CPU_CONFIG);
    }

    public void trackSelectEnergyRange(@NotNull EnergyRangeMetadata rangeMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_RANGE).setEnergyRangeMetadata(rangeMetadata).track();
    }

    public void trackSelectEnergyEvent(@NotNull EnergyEventMetadata eventMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_EVENT).setEnergyEventMetadata(eventMetadata).track();
    }

    public void trackFilterMetadata(@NotNull FilterMetadata filterMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.FILTER).setFilterMetadata(filterMetadata).track();
    }

    public void trackMemoryProfilerInstanceFilter(@NotNull CaptureObjectInstanceFilter filter2) {
        MemoryInstanceFilterMetadata.Builder builder2 = MemoryInstanceFilterMetadata.newBuilder().setFilterType((MemoryInstanceFilterMetadata.FilterType)this.MEMORY_INSTANCE_FILTER_MAP.getOrDefault(filter2.getClass(), (Object)MemoryInstanceFilterMetadata.FilterType.UNKNOWN_FILTER_TYPE));
        this.newTracker(AndroidProfilerEvent.Type.MEMORY_INSTANCE_FILTER).setMemoryInstanceFilterMetadata(builder2.build()).track();
    }

    public void trackTraceProcessorDaemonSpawnAttempt(boolean successful, long timeToSpawnMs) {
        TraceProcessorDaemonManagerStats stats = TraceProcessorDaemonManagerStats.newBuilder().setTimeToSpawnMs(timeToSpawnMs).build();
        AndroidProfilerEvent.Type type = successful ? AndroidProfilerEvent.Type.TPD_MANAGER_SPAWN_OK : AndroidProfilerEvent.Type.TPD_MANAGER_SPAWN_FAILED;
        this.newTracker(type).setTraceProcessorDaemonManagerStats(stats).track();
    }

    public void trackTraceProcessorLoadTrace(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs, long traceSizeBytes) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).setTraceSizeBytes(traceSizeBytes).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_LOAD_TRACE).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackTraceProcessorProcessMetadata(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_PROCESS_METADATA).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackTraceProcessorCpuData(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_LOAD_CPU_DATA).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackTraceProcessorMemoryData(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_LOAD_MEMORY_DATA).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackMoveTrackGroupUp(@NotNull String title) {
        this.trackTrackGroupAction(title, AdtUiTrackGroupMetadata.TrackGroupActionType.MOVE_UP);
    }

    public void trackMoveTrackGroupDown(@NotNull String title) {
        this.trackTrackGroupAction(title, AdtUiTrackGroupMetadata.TrackGroupActionType.MOVE_DOWN);
    }

    public void trackExpandTrackGroup(@NotNull String title) {
        this.trackTrackGroupAction(title, AdtUiTrackGroupMetadata.TrackGroupActionType.EXPAND);
    }

    public void trackCollapseTrackGroup(@NotNull String title) {
        this.trackTrackGroupAction(title, AdtUiTrackGroupMetadata.TrackGroupActionType.COLLAPSE);
    }

    private void trackTrackGroupAction(@NotNull String title, @NotNull AdtUiTrackGroupMetadata.TrackGroupActionType actionType) {
        this.newTracker(AndroidProfilerEvent.Type.TRACK_GROUP_ACTION).setTrackGroupMetadata(AdtUiTrackGroupMetadata.newBuilder().setTitle(title).setActionType(actionType).build()).track();
    }

    public void trackSelectBox(long durationUs, int trackCount) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_BOX).setBoxSelectionMetadata(AdtUiBoxSelectionMetadata.newBuilder().setDurationUs(durationUs).setTrackCount(trackCount).build()).track();
    }

    @NotNull
    private Tracker newTracker(AndroidProfilerEvent.Type eventType) {
        return new Tracker(this.myTrackingProject, eventType, this.myCurrStage);
    }

    private void track(AndroidProfilerEvent.Type eventType) {
        this.newTracker(eventType).track();
    }

    private static Logger getLogger() {
        return Logger.getInstance(StudioFeatureTracker.class);
    }

    private static final class Tracker {
        @NotNull
        private final AndroidProfilerEvent.Type myEventType;
        @NotNull
        private final AndroidProfilerEvent.Stage myCurrStage;
        @NotNull
        private final Project myTrackingProject;
        @Nullable
        private Common.Device myDevice;
        @Nullable
        private com.android.tools.profilers.cpu.CpuCaptureMetadata myCpuCaptureMetadata;
        @Nullable
        private CpuImportTraceMetadata myCpuImportTraceMetadata;
        @Nullable
        private FilterMetadata myFeatureMetadata;
        @Nullable
        private CpuApiTracingMetadata myCpuApiTracingMetadata;
        @Nullable
        private EnergyRangeMetadata myEnergyRangeMetadata;
        @Nullable
        private EnergyEventMetadata myEnergyEventMetadata;
        @Nullable
        private ProfilerSessionCreationMetaData mySessionCreationMetadata;
        @Nullable
        private ProfilerSessionSelectionMetaData mySessionArtifactMetadata;
        @Nullable
        private ProfilingConfiguration myCpuStartupProfilingConfiguration;
        @Nullable
        private TransportFailureMetadata myTransportFailureMetadata;
        @Nullable
        private MemoryInstanceFilterMetadata myMemoryInstanceFilterMetadata;
        @Nullable
        private TraceProcessorDaemonManagerStats myTraceProcessorDaemonManagerStats;
        @Nullable
        private TraceProcessorDaemonQueryStats myTraceProcessorDaemonQueryStats;
        @Nullable
        private AdtUiTrackGroupMetadata myTrackGroupMetadata;
        @Nullable
        private AdtUiBoxSelectionMetadata myBoxSelectionMetadata;
        private AndroidProfilerEvent.MemoryHeap myMemoryHeap = AndroidProfilerEvent.MemoryHeap.UNKNOWN_HEAP;

        public Tracker(@NotNull Project trackingProject, @NotNull AndroidProfilerEvent.Type eventType, @NotNull AndroidProfilerEvent.Stage stage) {
            this.myEventType = eventType;
            this.myCurrStage = stage;
            this.myTrackingProject = trackingProject;
        }

        @NotNull
        public Tracker setDevice(@Nullable Common.Device device) {
            this.myDevice = device;
            return this;
        }

        @NotNull
        public Tracker setCpuCaptureMetadata(@Nullable com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
            this.myCpuCaptureMetadata = cpuCaptureMetadata;
            return this;
        }

        @NotNull
        public Tracker setCpuImportTraceMetadata(CpuImportTraceMetadata cpuImportTraceMetadata) {
            this.myCpuImportTraceMetadata = cpuImportTraceMetadata;
            return this;
        }

        @NotNull
        public Tracker setCpuStartupProfilingConfiguration(@Nullable ProfilingConfiguration configuration) {
            this.myCpuStartupProfilingConfiguration = configuration;
            return this;
        }

        @NotNull
        public Tracker setCpuApiTracingMetadata(@Nullable CpuApiTracingMetadata metadata) {
            this.myCpuApiTracingMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setFilterMetadata(@Nullable FilterMetadata filterMetadata) {
            this.myFeatureMetadata = filterMetadata;
            return this;
        }

        @NotNull
        public Tracker setEnergyRangeMetadata(@Nullable EnergyRangeMetadata energyRangeMetadata) {
            this.myEnergyRangeMetadata = energyRangeMetadata;
            return this;
        }

        @NotNull
        public Tracker setEnergyEventMetadata(@Nullable EnergyEventMetadata energyEventMetadata) {
            this.myEnergyEventMetadata = energyEventMetadata;
            return this;
        }

        @NotNull
        public Tracker setMemoryHeapId(AndroidProfilerEvent.MemoryHeap heap) {
            this.myMemoryHeap = heap;
            return this;
        }

        @NotNull
        public Tracker setSessionCreationMetadata(ProfilerSessionCreationMetaData metadata) {
            this.mySessionCreationMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setSessionSelectionMetadata(ProfilerSessionSelectionMetaData metadata) {
            this.mySessionArtifactMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setTransportFailureMetadata(TransportFailureMetadata metadata) {
            this.myTransportFailureMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setMemoryInstanceFilterMetadata(MemoryInstanceFilterMetadata metadata) {
            this.myMemoryInstanceFilterMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setTraceProcessorDaemonManagerStats(TraceProcessorDaemonManagerStats traceProcessorDaemonManagerStats) {
            this.myTraceProcessorDaemonManagerStats = traceProcessorDaemonManagerStats;
            return this;
        }

        @NotNull
        public Tracker setTraceProcessorDaemonQueryStats(TraceProcessorDaemonQueryStats traceProcessorDaemonQueryStats) {
            this.myTraceProcessorDaemonQueryStats = traceProcessorDaemonQueryStats;
            return this;
        }

        @NotNull
        public Tracker setTrackGroupMetadata(AdtUiTrackGroupMetadata trackGroupMetadata) {
            this.myTrackGroupMetadata = trackGroupMetadata;
            return this;
        }

        @NotNull
        private Tracker setBoxSelectionMetadata(AdtUiBoxSelectionMetadata boxSelectionMetadata) {
            this.myBoxSelectionMetadata = boxSelectionMetadata;
            return this;
        }

        public void track() {
            AndroidProfilerEvent.Builder profilerEvent = AndroidProfilerEvent.newBuilder().setStage(this.myCurrStage).setType(this.myEventType);
            this.populateCpuCaptureMetadata(profilerEvent);
            this.populateFilterMetadata(profilerEvent);
            this.populateEnergyRangeMetadata(profilerEvent);
            this.populateEnergyEventMetadata(profilerEvent);
            this.populateMemoryInstanceFilterMetadata(profilerEvent);
            switch (this.myEventType) {
                case SELECT_MEMORY_HEAP: {
                    profilerEvent.setMemoryHeap(this.myMemoryHeap);
                    break;
                }
                case SESSION_CREATED: {
                    profilerEvent.setSessionStartMetadata(this.mySessionCreationMetadata);
                    break;
                }
                case SESSION_ARTIFACT_SELECTED: {
                    profilerEvent.setSessionArtifactMetadata(this.mySessionArtifactMetadata);
                    break;
                }
                case TRANSPORT_DAEMON_FAILED: 
                case TRANSPORT_PROXY_FAILED: {
                    assert (this.myTransportFailureMetadata != null);
                    profilerEvent.setTransportFailureMetadata(this.myTransportFailureMetadata);
                    break;
                }
                case CPU_API_TRACING: {
                    profilerEvent.setCpuApiTracingMetadata(this.myCpuApiTracingMetadata);
                    break;
                }
                case CPU_STARTUP_PROFILING: {
                    profilerEvent.setCpuStartupProfilingMetadata(CpuStartupProfilingMetadata.newBuilder().setProfilingConfig(Tracker.toStatsCpuProfilingConfig(this.myCpuStartupProfilingConfiguration)));
                    break;
                }
                case CPU_IMPORT_TRACE: {
                    assert (this.myCpuImportTraceMetadata != null);
                    profilerEvent.setCpuImportTraceMetadata(this.myCpuImportTraceMetadata);
                    break;
                }
                case TPD_MANAGER_SPAWN_OK: 
                case TPD_MANAGER_SPAWN_FAILED: {
                    profilerEvent.setTpdManagerStats(this.myTraceProcessorDaemonManagerStats);
                    break;
                }
                case TPD_QUERY_LOAD_TRACE: 
                case TPD_QUERY_PROCESS_METADATA: 
                case TPD_QUERY_LOAD_CPU_DATA: 
                case TPD_QUERY_LOAD_MEMORY_DATA: {
                    profilerEvent.setTpdQueryStats(this.myTraceProcessorDaemonQueryStats);
                    break;
                }
                case TRACK_GROUP_ACTION: {
                    profilerEvent.setTrackGroupMetadata(this.myTrackGroupMetadata);
                    break;
                }
                case SELECT_BOX: {
                    profilerEvent.setBoxSelectionMetadata(this.myBoxSelectionMetadata);
                    break;
                }
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setAndroidProfilerEvent(profilerEvent);
            if (this.myDevice != null) {
                event.setDeviceInfo(DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)this.myDevice.getSerial())).setBuildTags(this.myDevice.getBuildTags()).setBuildType(this.myDevice.getBuildType()).setBuildVersionRelease(this.myDevice.getVersion()).setBuildApiLevelFull(new AndroidVersion(this.myDevice.getApiLevel(), this.myDevice.getCodename()).getApiString()).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)this.myDevice.getCpuAbi())).setManufacturer(this.myDevice.getManufacturer()).setDeviceType(this.myDevice.getIsEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setMdnsConnectionType(DeviceUtils.isMdnsAutoConnectUnencrypted((String)this.myDevice.getSerial()) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED : (DeviceUtils.isMdnsAutoConnectTls((String)this.myDevice.getSerial()) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS : DeviceInfo.MdnsConnectionType.MDNS_NONE)).setModel(this.myDevice.getModel()).build());
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myTrackingProject));
        }

        private void populateEnergyRangeMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myEnergyRangeMetadata == null) {
                return;
            }
            EnergyRangeMetadata.Builder builder2 = com.google.wireless.android.sdk.stats.EnergyRangeMetadata.newBuilder();
            this.myEnergyRangeMetadata.getEventCounts().forEach(eventCount -> builder2.addEventCounts(EnergyEventCount.newBuilder().setType(Tracker.toEnergyType(eventCount.getKind())).setCount(eventCount.getCount()).build()));
            profilerEvent.setEnergyRangeMetadata(builder2.build());
        }

        private void populateEnergyEventMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myEnergyEventMetadata == null || this.myEnergyEventMetadata.getSubevents().isEmpty()) {
                return;
            }
            EnergyEventMetadata.Builder builder2 = com.google.wireless.android.sdk.stats.EnergyEventMetadata.newBuilder();
            List subevents = this.myEnergyEventMetadata.getSubevents();
            Common.Event firstEvent = (Common.Event)subevents.get(0);
            builder2.setType(Tracker.toEnergyType(firstEvent.getEnergyEvent()));
            EnergyEvent.Subtype eventSubtype = Tracker.toEnergySubtype(firstEvent.getEnergyEvent());
            if (eventSubtype != null) {
                builder2.setSubtype(eventSubtype);
            }
            for (Common.Event event : subevents) {
                builder2.addSubevents(Tracker.toEnergySubevent(event.getEnergyEvent()));
            }
            profilerEvent.setEnergyEventMetadata(builder2);
        }

        private void populateMemoryInstanceFilterMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myMemoryInstanceFilterMetadata == null) {
                return;
            }
            profilerEvent.setMemoryInstanceFilterMetadata(this.myMemoryInstanceFilterMetadata);
        }

        private void populateFilterMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myFeatureMetadata != null) {
                FilterMetadata.Builder filterMetadata = com.google.wireless.android.sdk.stats.FilterMetadata.newBuilder();
                filterMetadata.setFeaturesUsed((long)this.myFeatureMetadata.getFeaturesUsed());
                filterMetadata.setMatchedElements(this.myFeatureMetadata.getMatchedElementCount());
                filterMetadata.setTotalElements(this.myFeatureMetadata.getTotalElementCount());
                filterMetadata.setSearchLength(this.myFeatureMetadata.getFilterTextLength());
                switch (this.myFeatureMetadata.getView()) {
                    case UNKNOWN_FILTER_VIEW: {
                        filterMetadata.setActiveView(FilterMetadata.View.UNKNOWN_FILTER_VIEW);
                        break;
                    }
                    case CPU_TOP_DOWN: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_TOP_DOWN);
                        break;
                    }
                    case CPU_BOTTOM_UP: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_BOTTOM_UP);
                        break;
                    }
                    case CPU_FLAME_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_FLAME_CHART);
                        break;
                    }
                    case CPU_CALL_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_CALL_CHART);
                        break;
                    }
                    case MEMORY_CALLSTACK: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CALLSTACK);
                        break;
                    }
                    case MEMORY_PACKAGE: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_PACKAGE);
                        break;
                    }
                    case MEMORY_CLASS: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CLASS);
                        break;
                    }
                    case NETWORK_CONNECTIONS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_CONNECTIONS);
                        break;
                    }
                    case NETWORK_THREADS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_THREADS);
                    }
                }
                profilerEvent.setFilterMetadata(filterMetadata);
            }
        }

        private void populateCpuCaptureMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myCpuCaptureMetadata != null) {
                CpuCaptureMetadata.Builder captureMetadata = CpuCaptureMetadata.newBuilder().setCaptureDurationMs(this.myCpuCaptureMetadata.getCaptureDurationMs()).setRecordDurationMs(this.myCpuCaptureMetadata.getRecordDurationMs()).setTraceFileSizeBytes(this.myCpuCaptureMetadata.getTraceFileSizeBytes()).setParsingTimeMs(this.myCpuCaptureMetadata.getParsingTimeMs()).setStoppingTimeMs(this.myCpuCaptureMetadata.getStoppingTimeMs()).setCaptureStatus((CpuCaptureMetadata.CaptureStatus)CPU_CAPTURE_STATUS_MAP.getOrDefault((Object)this.myCpuCaptureMetadata.getStatus(), (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS));
                captureMetadata.setProfilingConfig(Tracker.toStatsCpuProfilingConfig(this.myCpuCaptureMetadata.getProfilingConfiguration()));
                if (this.myCpuCaptureMetadata.getProfilingConfiguration().getTraceType() == Cpu.CpuTraceType.ART) {
                    captureMetadata.setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC);
                }
                profilerEvent.setCpuCaptureMetadata(captureMetadata);
            }
        }

        @NotNull
        private static CpuProfilingConfig toStatsCpuProfilingConfig(@NotNull ProfilingConfiguration config) {
            CpuProfilingConfig.Builder cpuConfigInfo = CpuProfilingConfig.newBuilder();
            Cpu.CpuTraceConfiguration.UserOptions options2 = config.toProto();
            switch (config.getTraceType()) {
                case ART: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ART);
                    cpuConfigInfo.setMode(config instanceof ArtSampledConfiguration ? CpuProfilingConfig.Mode.SAMPLED : CpuProfilingConfig.Mode.INSTRUMENTED);
                    cpuConfigInfo.setSampleInterval(options2.getSamplingIntervalUs());
                    break;
                }
                case SIMPLEPERF: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.SIMPLE_PERF);
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.SAMPLED);
                    cpuConfigInfo.setSampleInterval(options2.getSamplingIntervalUs());
                    break;
                }
                case ATRACE: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ATRACE);
                    cpuConfigInfo.setSizeLimit(options2.getBufferSizeInMb());
                    break;
                }
                case PERFETTO: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.PERFETTO);
                    cpuConfigInfo.setSizeLimit(options2.getBufferSizeInMb());
                    break;
                }
            }
            return cpuConfigInfo.build();
        }

        @NotNull
        private static EnergyEvent.Type toEnergyType(@NotNull Energy.EnergyEventData energyEvent) {
            return Tracker.toEnergyType(EnergyDuration.Kind.from((Energy.EnergyEventData)energyEvent));
        }

        @NotNull
        private static EnergyEvent.Type toEnergyType(@NotNull EnergyDuration.Kind energyKind) {
            switch (energyKind) {
                case WAKE_LOCK: {
                    return EnergyEvent.Type.WAKE_LOCK;
                }
                case ALARM: {
                    return EnergyEvent.Type.ALARM;
                }
                case JOB: {
                    return EnergyEvent.Type.JOB;
                }
                case LOCATION: {
                    return EnergyEvent.Type.LOCATION;
                }
            }
            return EnergyEvent.Type.UNKNOWN_EVENT_TYPE;
        }

        @Nullable
        private static EnergyEvent.Subtype toEnergySubtype(@NotNull Energy.EnergyEventData eventData) {
            if (eventData.getMetadataCase() == Energy.EnergyEventData.MetadataCase.WAKE_LOCK_ACQUIRED) {
                Energy.WakeLockAcquired wakeLockAcquired = eventData.getWakeLockAcquired();
                switch (wakeLockAcquired.getLevel()) {
                    case PARTIAL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PARTIAL;
                    }
                    case SCREEN_DIM_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_DIM;
                    }
                    case SCREEN_BRIGHT_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_BRIGHT;
                    }
                    case FULL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_FULL;
                    }
                    case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PROXIMITY_SCREEN_OFF;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            if (eventData.getMetadataCase() == Energy.EnergyEventData.MetadataCase.ALARM_SET) {
                Energy.AlarmSet alarmSet = eventData.getAlarmSet();
                switch (alarmSet.getType()) {
                    case RTC: {
                        return EnergyEvent.Subtype.ALARM_RTC;
                    }
                    case RTC_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_RTC_WAKEUP;
                    }
                    case ELAPSED_REALTIME: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME;
                    }
                    case ELAPSED_REALTIME_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME_WAKEUP;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            return null;
        }

        @NotNull
        private static EnergyEvent.Subevent toEnergySubevent(@NotNull Energy.EnergyEventData eventData) {
            switch (eventData.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: {
                    return EnergyEvent.Subevent.WAKE_LOCK_ACQUIRED;
                }
                case WAKE_LOCK_RELEASED: {
                    return EnergyEvent.Subevent.WAKE_LOCK_RELEASED;
                }
                case ALARM_SET: {
                    return EnergyEvent.Subevent.ALARM_SET;
                }
                case ALARM_CANCELLED: {
                    return EnergyEvent.Subevent.ALARM_CANCELLED;
                }
                case ALARM_FIRED: {
                    return EnergyEvent.Subevent.ALARM_FIRED;
                }
                case JOB_SCHEDULED: {
                    return EnergyEvent.Subevent.JOB_SCHEDULED;
                }
                case JOB_STARTED: {
                    return EnergyEvent.Subevent.JOB_STARTED;
                }
                case JOB_STOPPED: {
                    return EnergyEvent.Subevent.JOB_STOPPED;
                }
                case JOB_FINISHED: {
                    return EnergyEvent.Subevent.JOB_FINISHED;
                }
                case LOCATION_UPDATE_REQUESTED: {
                    return EnergyEvent.Subevent.LOCATION_UPDATE_REQUESTED;
                }
                case LOCATION_UPDATE_REMOVED: {
                    return EnergyEvent.Subevent.LOCATION_UPDATE_REMOVED;
                }
                case LOCATION_CHANGED: {
                    return EnergyEvent.Subevent.LOCATION_CHANGED;
                }
            }
            return EnergyEvent.Subevent.UNKNOWN_ENERGY_SUBEVENT;
        }
    }
}

