/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.eventpreprocessor.EnergyUsagePreprocessor;
import com.android.tools.idea.profilers.eventpreprocessor.SimpleperfPipelinePreprocessor;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxyManager;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfSampleReporter;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerService
implements TransportDeviceManager.TransportDeviceManagerListener {
    private final int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);

    public static AndroidProfilerService getInstance() {
        return (AndroidProfilerService)ServiceManager.getService(AndroidProfilerService.class);
    }

    AndroidProfilerService() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TransportDeviceManager.TOPIC, (Object)this);
    }

    @Override
    public void onPreTransportDaemonStart(@NotNull Common.Device device) {
    }

    @Override
    public void onStartTransportDaemonFail(@NotNull Common.Device device, @NotNull Exception exception) {
    }

    @Override
    public void onTransportProxyCreationFail(@NotNull Common.Device device, @NotNull Exception exception) {
    }

    @Override
    public void customizeProxyService(@NotNull TransportProxy proxy) {
        ProfilerServiceProxyManager.registerCommandHandlers(proxy);
        if (((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()) {
            proxy.registerEventPreprocessor(new EnergyUsagePreprocessor(TransportService.getInstance().getLogService()));
        }
        SimpleperfPipelinePreprocessor traceProcessor = new SimpleperfPipelinePreprocessor((TracePreProcessor)new SimpleperfSampleReporter());
        proxy.registerEventPreprocessor(traceProcessor);
        proxy.registerDataPreprocessor(traceProcessor);
    }

    @Override
    public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder configBuilder) {
        configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()).setProfilerCustomEventVisualization(((Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get()).booleanValue())).setCpu(Transport.DaemonConfig.CpuConfig.newBuilder().setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC).setUsePerfetto(true));
    }

    @Override
    public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder configBuilder, @Nullable AndroidRunConfigurationBase runConfig) {
        int liveAllocationSamplingRate = ((Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get()).booleanValue() ? (this.shouldEnableMemoryLiveAllocation(runConfig) ? PropertiesComponent.getInstance().getInt(IntellijProfilerPreferences.getProfilerPropertyName("memory.live.allocation.mode"), MemoryProfilerStage.DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.NONE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()).setProfilerCustomEventVisualization(((Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get()).booleanValue())).setMem(Agent.AgentConfig.MemoryConfig.newBuilder().setUseLiveAlloc(((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue()).setMaxStackDepth(this.LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(((Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get()).booleanValue()).setSamplingRate(Memory.MemoryAllocSamplingData.newBuilder().setSamplingNumInterval(liveAllocationSamplingRate).build()).build()).setCpuApiTracingEnabled(true);
        if (runConfig != null && runConfig.getProfilerState().isNativeMemoryStartupProfilingEnabled()) {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.ON_COMMAND);
            configBuilder.setAttachCommand(Commands.Command.CommandType.STOP_NATIVE_HEAP_SAMPLE);
        } else if (runConfig != null && runConfig.getProfilerState().isCpuStartupProfilingEnabled()) {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.ON_COMMAND);
            configBuilder.setAttachCommand(Commands.Command.CommandType.STOP_CPU_TRACE);
        } else {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.INSTANT);
        }
    }

    private boolean shouldEnableMemoryLiveAllocation(@Nullable AndroidRunConfigurationBase runConfig) {
        if (runConfig == null) {
            return true;
        }
        ProfilerState state = runConfig.getProfilerState();
        if (state.isCpuStartupProfilingEnabled()) {
            String configName = runConfig.getProfilerState().STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
            CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(runConfig.getProject()).getConfigByName(configName);
            return startupConfig == null || !startupConfig.isDisableLiveAllocation();
        }
        return !state.isNativeMemoryStartupProfilingEnabled();
    }
}

