/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.ui;

import com.android.tools.idea.observable.core.OptionalProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class IconProperty
extends OptionalProperty<Icon>
implements PropertyChangeListener {
    @NotNull
    private final JComponent myComponent;

    public IconProperty(@NotNull JLabel label) {
        this.myComponent = label;
        label.addPropertyChangeListener("icon", this);
    }

    public IconProperty(@NotNull AbstractButton button2) {
        this.myComponent = button2;
        button2.addPropertyChangeListener("icon", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    @Override
    protected void setDirectly(@NotNull Optional<Icon> value2) {
        if (this.myComponent instanceof JLabel) {
            ((JLabel)this.myComponent).setIcon(value2.orElse(null));
        } else if (this.myComponent instanceof AbstractButton) {
            ((AbstractButton)this.myComponent).setIcon(value2.orElse(null));
        } else {
            throw new IllegalStateException("Unexpected icon component type: " + this.myComponent.getClass().getSimpleName());
        }
    }

    @Override
    @NotNull
    public Optional<Icon> get() {
        if (this.myComponent instanceof JLabel) {
            return Optional.ofNullable(((JLabel)this.myComponent).getIcon());
        }
        if (this.myComponent instanceof AbstractButton) {
            return Optional.ofNullable(((AbstractButton)this.myComponent).getIcon());
        }
        throw new IllegalStateException("Unexpected icon component type: " + this.myComponent.getClass().getSimpleName());
    }
}

