/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.adapters;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.android.utils.DecimalUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringToDoubleAdapterProperty
extends AdapterProperty<String, Double> {
    @NotNull
    private final DecimalFormat myFormat;
    @NotNull
    private final DecimalFormatSymbols mySymbols;

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty) {
        this(wrappedProperty, 1);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals) {
        this(wrappedProperty, numDecimals, numDecimals);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals, int maxDecimals) {
        this(wrappedProperty, StringToDoubleAdapterProperty.createFormat(numDecimals, maxDecimals));
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, @NotNull DecimalFormat format2) {
        super(wrappedProperty, 0.0);
        this.myFormat = format2;
        this.mySymbols = format2.getDecimalFormatSymbols();
    }

    private static DecimalFormat createFormat(int numDecimals, int maxDecimals) {
        Preconditions.checkArgument((maxDecimals >= numDecimals ? 1 : 0) != 0, (Object)"maxDecimals may not be less than numDecimals");
        String pattern = numDecimals == 0 ? "0" : "0." + Strings.repeat((String)"0", (int)numDecimals) + Strings.repeat((String)"#", (int)(maxDecimals - numDecimals));
        return new DecimalFormat(pattern, new DecimalFormatSymbols());
    }

    @Override
    @Nullable
    protected Double convertFromSourceType(@NotNull String value2) {
        ParsePosition pos;
        Number number = this.myFormat.parse(value2 = value2.trim(), pos = new ParsePosition(0));
        if (number == null || pos.getIndex() != value2.length()) {
            return null;
        }
        return number.doubleValue();
    }

    @Override
    @NotNull
    protected String convertFromDestType(@NotNull Double value2) {
        return DecimalUtils.trimInsignificantZeros((String)this.myFormat.format(value2), (DecimalFormatSymbols)this.mySymbols);
    }
}

