/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.AbstractObservableValue;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProperty<T>
extends AbstractObservableValue<T>
implements SettableValue<T> {
    @Nullable
    List<Constraint<T>> myConstraints;

    @NotNull
    public static List<AbstractProperty<?>> getAll(Object object) {
        ArrayList properties2 = new ArrayList();
        for (Field field2 : object.getClass().getDeclaredFields()) {
            if (!AbstractProperty.class.isAssignableFrom(field2.getType())) continue;
            try {
                boolean isFieldPrivate = !field2.isAccessible();
                field2.setAccessible(true);
                properties2.add((AbstractProperty)field2.get(object));
                if (!isFieldPrivate) continue;
                field2.setAccessible(false);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return properties2;
    }

    public final void addConstraint(@NotNull Constraint<T> constraint) {
        if (this.myConstraints == null) {
            this.myConstraints = new ArrayList<Constraint<T>>(1);
        }
        this.myConstraints.add(constraint);
        this.set(this.get());
    }

    @Override
    public final void set(@NotNull T value2) {
        if (this.myConstraints != null) {
            for (Constraint<T> c : this.myConstraints) {
                value2 = c.constrain(value2);
            }
        }
        if (!this.isValueEqual(value2)) {
            this.setNotificationsEnabled(false);
            this.setDirectly(value2);
            this.setNotificationsEnabled(true);
            this.notifyInvalidated();
        }
    }

    protected boolean isValueEqual(@Nullable T value2) {
        return Objects.equal(this.get(), value2);
    }

    @Override
    public final void set(@NotNull ObservableValue<T> value2) {
        this.set(value2.get());
    }

    public String toString() {
        return this.get().toString();
    }

    protected abstract void setDirectly(@NotNull T var1);

    public static interface Constraint<T> {
        @NotNull
        public T constrain(@NotNull T var1);
    }
}

