/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.DoubleProperty;
import com.android.tools.idea.observable.core.DoubleValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EdtInvocationManager;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class VectorAsset
extends BaseAsset {
    private static final String ERROR_EMPTY_PREVIEW = "Could not generate a preview";
    private static final VectorDrawableInfo SELECT_A_FILE = new VectorDrawableInfo(new Validator.Result(Validator.Severity.WARNING, "Please select a file"));
    @NotNull
    private final OptionalValueProperty<File> myPath = new OptionalValueProperty<File>(new File(System.getProperty("user.home")));
    @NotNull
    private final BoolProperty myAutoMirrored = new BoolValueProperty();
    @NotNull
    private final DoubleProperty myOutputWidth = new DoubleValueProperty();
    @NotNull
    private final DoubleProperty myOutputHeight = new DoubleValueProperty();
    @NotNull
    private final ObjectProperty<VectorDrawableInfo> myVectorDrawableInfo = new ObjectValueProperty<VectorDrawableInfo>(SELECT_A_FILE);

    public VectorAsset() {
        InvalidationListener listener2 = () -> {
            File file2 = (File)this.myPath.getValueOrNull();
            if (file2 != null) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    VectorDrawableInfo drawableInfo = VectorAsset.convertToVectorDrawable(file2);
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        if (this.isCurrentFile(file2)) {
                            this.myVectorDrawableInfo.set(drawableInfo);
                        }
                    });
                });
            } else {
                this.myVectorDrawableInfo.set(SELECT_A_FILE);
            }
        };
        this.myPath.addListener(listener2);
        listener2.onInvalidated();
    }

    public boolean isCurrentFile(@Nullable Object file2) {
        return Objects.equals(file2, this.myPath.getValueOrNull());
    }

    @NotNull
    public OptionalValueProperty<File> path() {
        return this.myPath;
    }

    @NotNull
    public BoolProperty autoMirrored() {
        return this.myAutoMirrored;
    }

    @NotNull
    public DoubleProperty outputWidth() {
        return this.myOutputWidth;
    }

    @NotNull
    public DoubleProperty outputHeight() {
        return this.myOutputHeight;
    }

    @NotNull
    public ObjectProperty<VectorDrawableInfo> getVectorDrawableInfo() {
        return this.myVectorDrawableInfo;
    }

    @NotNull
    private static VectorDrawableInfo convertToVectorDrawable(@NotNull File file2) {
        boolean valid2;
        String filename = file2.getName();
        if (!file2.exists()) {
            return new VectorDrawableInfo("File " + filename + " does not exist");
        }
        if (file2.isDirectory()) {
            return SELECT_A_FILE;
        }
        String xmlFileContent = null;
        StringBuilder errors2 = new StringBuilder();
        try {
            FileType fileType = FileType.fromFile(file2);
            switch (fileType) {
                case SVG: {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    String errorMessage = Svg2Vector.parseSvgToXml((File)file2, (OutputStream)outStream);
                    xmlFileContent = outStream.toString(StandardCharsets.UTF_8.name());
                    errors2.append(errorMessage);
                    break;
                }
                case LAYERED_IMAGE: {
                    xmlFileContent = new LayeredImageConverter().toVectorDrawableXml(file2);
                    break;
                }
                case VECTOR_DRAWABLE: {
                    xmlFileContent = new String(Files.readAllBytes(file2.toPath()), StandardCharsets.UTF_8);
                }
            }
        }
        catch (Exception e) {
            errors2.append("Error while parsing ").append(filename);
            String errorDetail = e.getLocalizedMessage();
            if (errorDetail != null) {
                errors2.append(" - ").append(errorDetail);
            }
            return new VectorDrawableInfo(errors2.toString());
        }
        double originalWidth = 0.0;
        double originalHeight = 0.0;
        if (!Strings.isNullOrEmpty((String)xmlFileContent)) {
            Document document = VectorAsset.parseXml(xmlFileContent, errors2.length() == 0 ? errors2 : null);
            if (document == null) {
                xmlFileContent = null;
            } else {
                Element root2 = document.getDocumentElement();
                originalWidth = VectorAsset.parseDoubleAttributeValue(root2, "android:width", "dp");
                originalHeight = VectorAsset.parseDoubleAttributeValue(root2, "android:height", "dp");
            }
        }
        boolean bl = valid2 = originalWidth > 0.0 && originalHeight > 0.0;
        if (!valid2 && errors2.length() == 0) {
            return new VectorDrawableInfo("The specified asset could not be parsed. Please choose another asset.");
        }
        Validator.Severity severity = !valid2 ? Validator.Severity.ERROR : (errors2.length() == 0 ? Validator.Severity.OK : Validator.Severity.WARNING);
        Validator.Result validityState = VectorAsset.createValidatorResult(severity, errors2.toString());
        return new VectorDrawableInfo(validityState, xmlFileContent, originalWidth, originalHeight);
    }

    @NotNull
    private static Validator.Result createValidatorResult(@NotNull Validator.Severity severity, @NotNull String errors2) {
        if (errors2.indexOf(10) < 0) {
            return new Validator.Result(severity, "The image may be incomplete: " + errors2);
        }
        String shortMessage = "<html>The image may be incomplete due to encountered <a href=\"issues\">issues</a></html>";
        return new Validator.Result(severity, shortMessage, errors2);
    }

    @NotNull
    public Preview generatePreview(int previewWidth) {
        File file2 = (File)this.myPath.getValueOrNull();
        VectorDrawableInfo drawableInfo = file2 == null ? SELECT_A_FILE : VectorAsset.convertToVectorDrawable(file2);
        return VectorAsset.generatePreview(drawableInfo, previewWidth, null);
    }

    @NotNull
    public static Preview generatePreview(@NotNull VectorDrawableInfo drawableInfo, int previewSize, @Nullable VdOverrideInfo overrideInfo) {
        String overriddenXml;
        Preconditions.checkArgument((previewSize > 0 ? 1 : 0) != 0);
        Validator.Result validityState = drawableInfo.getValidityState();
        if (!drawableInfo.isValid()) {
            return new Preview(validityState);
        }
        String xmlFileContent = drawableInfo.getXmlContent();
        assert (xmlFileContent != null);
        Document document = VectorAsset.parseXml(xmlFileContent, null);
        assert (document != null);
        StringBuilder errors2 = new StringBuilder();
        if (overrideInfo != null && (overriddenXml = VdPreview.overrideXmlContent((Document)document, (VdOverrideInfo)overrideInfo, (StringBuilder)errors2)) != null) {
            xmlFileContent = overriddenXml;
        }
        BufferedImage image = null;
        VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createFromMaxDimension((int)previewSize);
        try {
            image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xmlFileContent, (StringBuilder)errors2);
        }
        catch (Throwable e) {
            Logger.getInstance(VectorAsset.class).error(e);
        }
        if (validityState.getSeverity() == Validator.Severity.OK && errors2.length() != 0) {
            validityState = image == null ? new Validator.Result(Validator.Severity.ERROR, ERROR_EMPTY_PREVIEW) : VectorAsset.createValidatorResult(Validator.Severity.WARNING, errors2.toString());
        }
        return new Preview(validityState, image, xmlFileContent);
    }

    @Nullable
    public static Document parseXml(@NotNull String xmlFileContent, StringBuilder errorLog) {
        try {
            DocumentBuilder builder2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder2.parse(new InputSource(new StringReader(xmlFileContent)));
        }
        catch (Exception e) {
            if (errorLog != null) {
                errorLog.append("Exception while parsing XML file:\n").append(e.getMessage());
            }
            return null;
        }
    }

    @NotNull
    public Preview generatePreview() {
        int previewSize = AssetStudioUtils.roundToInt(Math.max((Double)this.myOutputWidth.get(), (Double)this.myOutputHeight.get()));
        VdOverrideInfo overrideInfo = this.createOverrideInfo();
        return VectorAsset.generatePreview((VectorDrawableInfo)this.myVectorDrawableInfo.get(), previewSize, overrideInfo);
    }

    private static double parseDoubleAttributeValue(@NotNull Element element2, @NotNull String attributeName, @NotNull String expectedSuffix) {
        String value2 = element2.getAttribute(attributeName);
        if (value2 == null || !value2.endsWith(expectedSuffix)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value2.substring(0, value2.length() - expectedSuffix.length()));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    @NotNull
    public ListenableFuture<BufferedImage> toImage() {
        return FutureUtils.executeOnPooledThread(() -> this.generatePreview().getImage());
    }

    @NotNull
    public VdOverrideInfo createOverrideInfo() {
        double width = (Double)this.myOutputWidth.get();
        double height = (Double)this.myOutputHeight.get();
        if (width <= 0.0 || height <= 0.0) {
            width = 0.0;
            height = 0.0;
        }
        return new VdOverrideInfo(width, height, (Color)this.color().getValueOrNull(), (double)((Integer)this.opacityPercent().get()).intValue() / 100.0, ((Boolean)this.myAutoMirrored.get()).booleanValue());
    }

    private static enum FileType {
        SVG,
        LAYERED_IMAGE,
        VECTOR_DRAWABLE;


        @NotNull
        static FileType fromFile(@NotNull File file2) {
            String path2 = file2.getPath();
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".svg")) {
                return SVG;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".psd")) {
                return LAYERED_IMAGE;
            }
            return VECTOR_DRAWABLE;
        }
    }

    public static final class Preview {
        @NotNull
        private final Validator.Result myValidityState;
        @Nullable
        private final BufferedImage myImage;
        @Nullable
        private final String myXmlContent;

        public Preview(@NotNull String errorMessage) {
            this(Validator.Result.fromNullableMessage((String)errorMessage));
        }

        public Preview(@NotNull Validator.Result validityState) {
            this(validityState, null, null);
        }

        public Preview(@NotNull Validator.Result validityState, @Nullable BufferedImage image, @Nullable String xmlContent) {
            this.myValidityState = validityState;
            this.myImage = image;
            this.myXmlContent = xmlContent;
        }

        public boolean isValid() {
            return this.myValidityState.getSeverity() != Validator.Severity.ERROR;
        }

        @NotNull
        public Validator.Result getValidityState() {
            return this.myValidityState;
        }

        @Nullable
        public BufferedImage getImage() {
            return this.myImage;
        }

        @Nullable
        public String getXmlContent() {
            return this.myXmlContent;
        }
    }

    public static final class VectorDrawableInfo {
        @NotNull
        private final Validator.Result myValidityState;
        @Nullable
        private final String myXmlContent;
        private final double myOriginalWidth;
        private final double myOriginalHeight;

        private VectorDrawableInfo(@NotNull String errorMessage) {
            this(Validator.Result.fromNullableMessage((String)errorMessage));
        }

        private VectorDrawableInfo(@NotNull Validator.Result validityState) {
            this(validityState, null, 0.0, 0.0);
        }

        private VectorDrawableInfo(@NotNull Validator.Result validityState, @Nullable String xmlContent, double originalWidth, double originalHeight) {
            this.myValidityState = validityState;
            this.myXmlContent = xmlContent;
            this.myOriginalWidth = originalWidth;
            this.myOriginalHeight = originalHeight;
        }

        @Nullable
        public String getXmlContent() {
            return this.myXmlContent;
        }

        public boolean isValid() {
            return this.myOriginalWidth > 0.0 && this.myOriginalHeight > 0.0;
        }

        public double getOriginalWidth() {
            return this.myOriginalWidth;
        }

        public double getOriginalHeight() {
            return this.myOriginalHeight;
        }

        @NotNull
        public Validator.Result getValidityState() {
            return this.myValidityState;
        }
    }
}

