/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.Slow;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.ShapeInfo;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredImageConverter {
    private DecimalFormat myFormat;
    private final DecimalFormat myMiterFormat = new DecimalFormat("#.####");
    private final DecimalFormat myOpacityFormat = new DecimalFormat("#.##");

    LayeredImageConverter() {
    }

    @Slow
    @NotNull
    String toVectorDrawableXml(@NotNull File path2) throws IOException {
        FileInputStream in = new FileInputStream(path2);
        Image image = PixelProbe.probe((InputStream)in, (Decoder.Options)new Decoder.Options().decodeLayerImageData(false).decodeLayerTextData(false).decodeLayerAdjustmentData(false).decodeGuides(false));
        Rectangle2D.Double bounds2 = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
        this.myFormat = LayeredImageConverter.createDecimalFormat((float)bounds2.getWidth(), (float)bounds2.getHeight());
        Element vector = new Element("vector");
        this.extractPathLayers(vector, image.getLayers());
        vector.attribute("width", String.valueOf((int)bounds2.getWidth()) + "dp").attribute("height", String.valueOf((int)bounds2.getHeight()) + "dp").attribute("viewportWidth", String.valueOf((int)bounds2.getWidth())).attribute("viewportHeight", String.valueOf((int)bounds2.getHeight()));
        String xml = LayeredImageConverter.toVectorDrawable(vector);
        in.close();
        return xml;
    }

    private void extractPathLayers(@NotNull Element root2, @NotNull List<Layer> layers) {
        for (int i2 = 0; i2 < layers.size(); ++i2) {
            Layer layer = layers.get(i2);
            if (!layer.isVisible()) continue;
            Layer.Type type = layer.getType();
            if (type == Layer.Type.SHAPE) {
                Shape path2;
                if (layer.getShapeInfo().getStyle() == ShapeInfo.Style.NONE || (path2 = LayeredImageConverter.getTransformedPath(layer)).getBounds2D().isEmpty()) continue;
                Area clipPath = null;
                float opacityModifier = 1.0f;
                boolean fullyClipped = false;
                if (!layer.isClipBase()) {
                    for (int j = i2 + 1; j < layers.size(); ++j) {
                        Layer clipBase = layers.get(j);
                        if (!clipBase.isClipBase()) continue;
                        if (!clipBase.isVisible()) {
                            fullyClipped = true;
                            break;
                        }
                        if (clipBase.getType() != Layer.Type.SHAPE) break;
                        opacityModifier = clipBase.getOpacity();
                        Area source = new Area(path2);
                        clipPath = new Area(LayeredImageConverter.getTransformedPath(clipBase));
                        source.intersect(clipPath);
                        path2 = source;
                        break;
                    }
                }
                if (fullyClipped) continue;
                Element element2 = new Element("path");
                boolean hasFillOrStroke = this.extractFill(layer, element2, opacityModifier);
                if (!(hasFillOrStroke |= this.extractStroke(layer, path2, clipPath, root2, element2, opacityModifier))) continue;
                element2.attribute("name", StringUtil.escapeXml((String)layer.getName()));
                element2.attribute("pathData", LayeredImageConverter.toPathData(path2, this.myFormat));
                root2.childAtFront(element2);
                continue;
            }
            if (type != Layer.Type.GROUP) continue;
            this.extractPathLayers(root2, layer.getChildren());
        }
    }

    @NotNull
    private static Shape getTransformedPath(Layer layer) {
        Area area;
        List paths = layer.getShapeInfo().getPaths();
        if (paths.isEmpty()) {
            return new Path2D.Float();
        }
        Rectangle2D layerBounds = layer.getBounds();
        AffineTransform transform = AffineTransform.getTranslateInstance(layerBounds.getX(), layerBounds.getY());
        ShapeInfo.Path shapePath = (ShapeInfo.Path)paths.get(0);
        if (shapePath.getOp() == ShapeInfo.PathOp.SUBTRACT) {
            area = new Area(new Rectangle2D.Double(0.0, 0.0, layerBounds.getWidth(), layerBounds.getHeight()));
            area.subtract(new Area(shapePath.getPath()));
        } else {
            Path2D path2 = shapePath.getPath();
            if (paths.size() == 1) {
                path2.transform(transform);
                return path2;
            }
            area = new Area(path2);
        }
        block6: for (int i2 = 1; i2 < paths.size(); ++i2) {
            shapePath = (ShapeInfo.Path)paths.get(i2);
            switch (shapePath.getOp()) {
                case ADD: {
                    area.add(new Area(shapePath.getPath()));
                    continue block6;
                }
                case SUBTRACT: {
                    area.subtract(new Area(shapePath.getPath()));
                    continue block6;
                }
                case INTERSECT: {
                    area.intersect(new Area(shapePath.getPath()));
                    continue block6;
                }
                case EXCLUSIVE_OR: {
                    area.exclusiveOr(new Area(shapePath.getPath()));
                }
            }
        }
        area.transform(transform);
        return area;
    }

    private boolean extractStroke(@NotNull Layer layer, @NotNull Shape path2, @Nullable Area clipPath, @NotNull Element root2, @NotNull Element element2, float opacityModifier) {
        ShapeInfo shapeInfo = layer.getShapeInfo();
        if (shapeInfo.getStyle() != ShapeInfo.Style.FILL) {
            BasicStroke stroke;
            boolean isBasicStroke = shapeInfo.getStroke() instanceof BasicStroke;
            if (isBasicStroke && ((stroke = (BasicStroke)shapeInfo.getStroke()).getDashArray() != null || clipPath != null || shapeInfo.getStrokeAlignment() != ShapeInfo.Alignment.CENTER)) {
                this.extractStrokeAsPath(layer, path2, clipPath, root2, opacityModifier);
                return false;
            }
            Paint strokePaint = shapeInfo.getStrokePaint();
            Color color = Color.BLACK;
            if (strokePaint instanceof Color) {
                color = (Color)strokePaint;
            }
            float strokeAlpha = layer.getOpacity() * shapeInfo.getStrokeOpacity() * opacityModifier;
            element2.attribute("strokeColor", "#" + LayeredImageConverter.optimizedHex(color));
            if (strokeAlpha < 1.0f) {
                element2.attribute("strokeAlpha", this.myOpacityFormat.format(strokeAlpha));
            }
            if (isBasicStroke) {
                BasicStroke stroke2 = (BasicStroke)shapeInfo.getStroke();
                element2.attribute("strokeWidth", this.myFormat.format(stroke2.getLineWidth()));
                if (stroke2.getLineJoin() != 0) {
                    element2.attribute("strokeLineJoin", LayeredImageConverter.getJoinValue(stroke2.getLineJoin()));
                } else {
                    element2.attribute("strokeMiterLimit", this.myMiterFormat.format(stroke2.getMiterLimit()));
                }
                if (stroke2.getEndCap() != 0) {
                    element2.attribute("strokeLineCap", LayeredImageConverter.getCapValue(stroke2.getEndCap()));
                }
            } else {
                element2.attribute("strokeWidth", String.valueOf(0.0f));
            }
            return true;
        }
        return false;
    }

    private void extractStrokeAsPath(@NotNull Layer layer, @NotNull Shape path2, @Nullable Area clipPath, @NotNull Element root2, float opacityModifier) {
        ShapeInfo shapeInfo = layer.getShapeInfo();
        BasicStroke stroke = (BasicStroke)shapeInfo.getStroke();
        Shape strokedPath = null;
        switch (shapeInfo.getStrokeAlignment()) {
            case INSIDE: {
                strokedPath = LayeredImageConverter.copyStroke(stroke, 2.0f).createStrokedShape(path2);
                strokedPath = new Area(strokedPath);
                ((Area)strokedPath).intersect(new Area(path2));
                break;
            }
            case CENTER: {
                strokedPath = stroke.createStrokedShape(path2);
                if (clipPath == null) break;
                strokedPath = new Area(strokedPath);
                break;
            }
            case OUTSIDE: {
                strokedPath = LayeredImageConverter.copyStroke(stroke, 2.0f).createStrokedShape(path2);
                strokedPath = new Area(strokedPath);
                ((Area)strokedPath).subtract(new Area(path2));
            }
        }
        if (clipPath != null) {
            ((Area)strokedPath).intersect(new Area(clipPath));
        }
        Paint strokePaint = shapeInfo.getStrokePaint();
        Color color = Color.BLACK;
        if (strokePaint instanceof Color) {
            color = (Color)strokePaint;
        }
        float strokeAlpha = layer.getOpacity() * shapeInfo.getStrokeOpacity() * opacityModifier;
        Element element2 = new Element("path").attribute("name", StringUtil.escapeXml((String)layer.getName())).attribute("pathData", LayeredImageConverter.toPathData(strokedPath, this.myFormat)).attribute("fillColor", "#" + LayeredImageConverter.optimizedHex(color));
        if (strokeAlpha < 1.0f) {
            element2.attribute("fillAlpha", this.myOpacityFormat.format(strokeAlpha));
        }
        root2.childAtFront(element2);
    }

    private static String optimizedHex(Color color) {
        if (color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
            char r = Integer.toHexString(color.getRed()).charAt(0);
            return new String(new char[]{r, r, r});
        }
        return ColorUtil.toHex((Color)color);
    }

    @NotNull
    private static BasicStroke copyStroke(@NotNull BasicStroke stroke, float widthScale) {
        return new BasicStroke(stroke.getLineWidth() * widthScale, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase());
    }

    private boolean extractFill(@NotNull Layer layer, @NotNull Element element2, float opacityModifier) {
        ShapeInfo shapeInfo = layer.getShapeInfo();
        if (shapeInfo.getStyle() != ShapeInfo.Style.STROKE) {
            Paint fillPaint = shapeInfo.getFillPaint();
            Color color = Color.BLACK;
            if (fillPaint instanceof Color) {
                color = (Color)fillPaint;
            }
            float fillAlpha = layer.getOpacity() * shapeInfo.getFillOpacity() * opacityModifier;
            element2.attribute("fillColor", "#" + LayeredImageConverter.optimizedHex(color));
            if (fillAlpha < 1.0f) {
                element2.attribute("fillAlpha", this.myOpacityFormat.format(fillAlpha));
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static String getCapValue(int endCap) {
        switch (endCap) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return "inherit";
    }

    @NotNull
    private static String getJoinValue(int lineJoin) {
        switch (lineJoin) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
        }
        return "inherit";
    }

    @NotNull
    private static String toPathData(@NotNull Shape path2, @NotNull DecimalFormat format2) {
        StringBuilder buffer = new StringBuilder(1024);
        float[] coords = new float[6];
        PathIterator iterator = path2.getPathIterator(null);
        float lastX = 0.0f;
        float lastY = 0.0f;
        float firstX = 0.0f;
        float firstY = 0.0f;
        boolean implicitLineTo = false;
        while (!iterator.isDone()) {
            int segment = iterator.currentSegment(coords);
            switch (segment) {
                case 0: {
                    buffer.append('m');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format2));
                    firstX = lastX = coords[0];
                    firstY = lastY = coords[1];
                    implicitLineTo = true;
                    break;
                }
                case 1: {
                    if (coords[0] == lastX) {
                        if (coords[1] != lastY) {
                            buffer.append('v');
                            buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format2));
                            implicitLineTo = false;
                        }
                    } else if (coords[1] == lastY) {
                        if (coords[0] != lastX) {
                            buffer.append('h');
                            buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format2));
                            implicitLineTo = false;
                        }
                    } else if (coords[0] != lastX && coords[1] != lastY) {
                        buffer.append(implicitLineTo ? (char)' ' : 'l');
                        buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format2));
                        buffer.append(' ');
                        buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format2));
                    }
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 3: {
                    buffer.append('c');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[2] - lastX, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[3] - lastY, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[4] - lastX, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[5] - lastY, format2));
                    implicitLineTo = false;
                    lastX = coords[4];
                    lastY = coords[5];
                    break;
                }
                case 2: {
                    buffer.append('q');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[2] - lastX, format2));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[3] - lastY, format2));
                    implicitLineTo = false;
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                case 4: {
                    buffer.append('z');
                    lastX = firstX;
                    lastY = firstY;
                }
            }
            iterator.next();
        }
        return buffer.toString();
    }

    @NotNull
    private static DecimalFormat createDecimalFormat(float viewportWidth, float viewportHeight) {
        float minSize = Math.min(viewportHeight, viewportWidth);
        float exponent = Math.round(Math.log10(minSize));
        int decimalPlace = (int)Math.floor(exponent - 4.0f);
        String decimalFormatString = "#";
        if (decimalPlace < 0) {
            if (decimalPlace < -6) {
                decimalPlace = -6;
            }
            decimalFormatString = decimalFormatString + ".";
            for (int i2 = 0; i2 < -decimalPlace; ++i2) {
                decimalFormatString = decimalFormatString + "#";
            }
        }
        DecimalFormatSymbols fractionSeparator = new DecimalFormatSymbols();
        fractionSeparator.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(decimalFormatString, fractionSeparator);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat;
    }

    @NotNull
    private static String cleanup(float value2, @NotNull DecimalFormat format2) {
        if (value2 == (float)((long)value2)) {
            return String.valueOf((long)value2);
        }
        return format2.format(value2);
    }

    @NotNull
    private static String toVectorDrawable(@NotNull Element element2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        LayeredImageConverter.outputElement(element2, out, true, 0);
        out.flush();
        return stringWriter.toString();
    }

    private static void outputElement(@NotNull Element element2, @NotNull PrintWriter out, boolean isRoot, int indent) {
        LayeredImageConverter.indent(out, indent);
        out.write("<");
        out.write(element2.name);
        if (isRoot) {
            out.write(" xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        }
        out.write("\n");
        boolean hasChildren = !element2.children.isEmpty();
        LayeredImageConverter.outputAttributes(element2, out, ++indent);
        if (hasChildren) {
            out.write(">\n");
            LayeredImageConverter.outputChildren(element2, out, indent);
        } else {
            out.write(" />");
        }
        --indent;
        if (hasChildren) {
            LayeredImageConverter.indent(out, indent);
            out.write("</");
            out.write(element2.name);
            out.write(">");
        }
        out.write("\n");
    }

    private static void outputChildren(@NotNull Element element2, @NotNull PrintWriter out, int indent) {
        for (Element child : element2.children) {
            LayeredImageConverter.outputElement(child, out, false, indent);
        }
    }

    private static void outputAttributes(@NotNull Element element2, @NotNull PrintWriter out, int indent) {
        List<Attribute> attributes = element2.attributes;
        int size = attributes.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Attribute attribute = attributes.get(i2);
            LayeredImageConverter.indent(out, indent);
            out.write("android:");
            out.write(attribute.name);
            out.write("=\"");
            out.write(attribute.value);
            out.write("\"");
            if (i2 == size - 1) continue;
            out.write("\n");
        }
    }

    private static void indent(@NotNull PrintWriter out, int indent) {
        for (int i2 = 0; i2 < indent; ++i2) {
            out.write("    ");
        }
    }

    private static class Element {
        final String name;
        final List<Element> children = new ArrayList<Element>();
        final List<Attribute> attributes = new ArrayList<Attribute>();

        Element(@NotNull String name) {
            this.name = name;
        }

        Element attribute(@NotNull String name, @NotNull String value2) {
            this.attributes.add(new Attribute(name, value2));
            return this;
        }

        Element childAtFront(@NotNull Element child) {
            this.children.add(0, child);
            return this;
        }
    }

    private static class Attribute {
        final String name;
        final String value;

        Attribute(@NotNull String name, @NotNull String value2) {
            this.name = name;
            this.value = value2;
        }
    }
}

