/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.repository.Revision;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.RegularExpressionIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import java.io.File;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedRegularExpressionIncludeResolver
extends RegularExpressionIncludeResolver {
    @NotNull
    private final PackageType myKind;
    @NotNull
    private final String myPattern;
    @Nullable
    private final String myLibraryName;

    IndexedRegularExpressionIncludeResolver(@NotNull PackageType kind, @NotNull String pattern, @Nullable String libraryName) {
        this.myKind = kind;
        this.myPattern = pattern;
        this.myLibraryName = libraryName;
    }

    @Override
    @NotNull
    String getMatchRegexTemplate() {
        return this.myPattern;
    }

    private String groupOrNull(Matcher match2, String name) {
        if (this.myPattern.contains(String.format("?<%s>", name))) {
            return match2.group(name);
        }
        return null;
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        Matcher match2 = LexicalIncludePaths.matchFolderToRegex(this.getCompiledMatchPattern(), includeFolder);
        if (!match2.find()) {
            return null;
        }
        try {
            String relativeFolder = match2.group("relative");
            String libraryName = this.myLibraryName;
            if (libraryName == null) {
                libraryName = match2.group("library");
            }
            String homeFolder = match2.group("home");
            String description2 = this.myKind.myDescription;
            String version2 = this.groupOrNull(match2, "ndk");
            if (version2 != null) {
                Revision revision = Revision.parseRevision((String)version2);
                if (revision.getMinor() == 0) {
                    description2 = description2 + String.format(" r%s", revision.getMajor());
                } else {
                    char minor = (char)(97 + revision.getMinor());
                    description2 = description2 + String.format(" r%s%s", revision.getMajor(), Character.valueOf(minor));
                }
            }
            return new SimpleIncludeValue(this.myKind, description2, libraryName, relativeFolder, includeFolder, new File(homeFolder));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Pattern %s is missing a group name", this.myPattern), e);
        }
    }
}

