/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CDepSimplePackageIncludeResolver
extends IncludeResolver {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("^(.*/.*?/exploded)(/(.*?)/(.*?)/(.*?)/.*?\\.zip(/.*))$");

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        Matcher match2 = LexicalIncludePaths.matchFolderToRegex(PATTERN, includeFolder);
        if (match2.find()) {
            String homeFolder = match2.group(1);
            String relativeFolderName = match2.group(2);
            String simplePackageName = match2.group(4);
            return new SimpleIncludeValue(PackageType.CDepPackage, PackageType.CDepPackage.myDescription, simplePackageName, relativeFolderName, includeFolder, new File(homeFolder));
        }
        return null;
    }
}

