/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.model;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ShadowingIncludeValue
extends IncludeValue {
    @NotNull
    public final ImmutableList<SimpleIncludeValue> myIncludes;
    @NotNull
    public final ImmutableSet<String> myExcludes;

    public ShadowingIncludeValue(@NotNull Collection<SimpleIncludeValue> includes, @NotNull Collection<String> excludes) {
        this.myIncludes = ImmutableList.copyOf(includes);
        this.myExcludes = ImmutableSet.copyOf(excludes);
    }

    @Override
    @NotNull
    public String getSortKey() {
        return IncludeValue.SortOrderKey.SHADOWING_INCLUDE_EXPRESSION.myKey;
    }

    @NotNull
    public Collection<File> getIncludePathsInOrder() {
        return ContainerUtil.map(this.myIncludes, value2 -> value2.getIncludeFolder());
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShadowingIncludeValue)) {
            return false;
        }
        ShadowingIncludeValue that = (ShadowingIncludeValue)obj;
        return Objects.equals(this.myIncludes, that.myIncludes) && Objects.equals(this.myExcludes, that.myExcludes);
    }

    public int hashCode() {
        return Objects.hash(this.myIncludes, this.myExcludes);
    }
}

