/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.dex.DexFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;

class DexFileStructure {
    @NotNull
    private final Future<DexBackedDexFile> myDexFileFuture;
    @NotNull
    private final ApkPackages myPackages = new ApkPackages();
    private boolean myPackagesComputed;

    DexFileStructure(@NotNull VirtualFile dexFile) {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        this.myDexFileFuture = executor.submit(() -> DexFiles.getDexFile(dexFile));
    }

    @NotNull
    Collection<ApkPackage> getPackages() throws ExecutionException, InterruptedException {
        if (!this.myPackagesComputed) {
            this.myPackagesComputed = true;
            this.computePackages();
        }
        return this.myPackages.values();
    }

    private void computePackages() throws ExecutionException, InterruptedException {
        DexBackedDexFile dexFile = this.myDexFileFuture.get();
        Set definitions = dexFile.getClasses().stream().map(DexBackedClassDef::getType).collect(Collectors.toSet());
        int m = dexFile.getMethodCount();
        for (int i2 = 0; i2 < m; ++i2) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i2);
            String className2 = DebuggerUtilsEx.signatureToName((String)methodRef.getDefiningClass());
            String definition = "L" + className2.replace('.', '/') + ";";
            if (!definitions.contains(definition)) continue;
            this.myPackages.add(className2);
        }
    }

    @VisibleForTesting
    static class ApkPackages {
        @NotNull
        private final Map<String, ApkPackage> myPackagesByName = new HashMap<String, ApkPackage>();

        ApkPackages() {
        }

        void add(@NotNull String classFqn) {
            ApkPackage apkPackage;
            Pair<String, String> packageAndClassNames = ApkPackages.splitName(classFqn);
            String packageName = (String)packageAndClassNames.getFirst();
            List segments = Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)packageName);
            int segmentCount = segments.size();
            if (segmentCount == 0) {
                apkPackage = this.myPackagesByName.computeIfAbsent(packageName, s -> new ApkPackage("", null));
            } else {
                String first = (String)segments.get(0);
                ApkPackage existing2 = this.myPackagesByName.get(first);
                if (existing2 == null) {
                    ApkPackage newPackage = new ApkPackage(first, null);
                    this.myPackagesByName.put(first, newPackage);
                    apkPackage = segmentCount > 1 ? ApkPackages.addChildren(newPackage, segments, 1) : newPackage;
                } else {
                    apkPackage = ApkPackages.findOrCreateMatchingSubpackage(existing2, segments);
                }
            }
            apkPackage.addClass((String)packageAndClassNames.getSecond());
        }

        @NotNull
        private static Pair<String, String> splitName(@NotNull String classFqn) {
            int lastDotIndex = classFqn.lastIndexOf(46);
            if (lastDotIndex < 0) {
                return Pair.create((Object)"", (Object)classFqn);
            }
            return Pair.create((Object)classFqn.substring(0, lastDotIndex), (Object)classFqn.substring(lastDotIndex + 1));
        }

        @NotNull
        private static ApkPackage findOrCreateMatchingSubpackage(@NotNull ApkPackage apkPackage, @NotNull List<String> segments) {
            ApkPackage current = apkPackage;
            int segmentCount = segments.size();
            for (int i2 = 1; i2 < segmentCount; ++i2) {
                String segment = segments.get(i2);
                ApkPackage child = current.findSubpackage(segment);
                if (child == null) {
                    return ApkPackages.addChildren(current, segments, i2);
                }
                current = child;
            }
            return current;
        }

        @NotNull
        private static ApkPackage addChildren(@NotNull ApkPackage apkPackage, @NotNull List<String> segments, int index2) {
            ApkPackage current = apkPackage;
            int segmentCount = segments.size();
            for (int i2 = index2; i2 < segmentCount; ++i2) {
                String segment = segments.get(i2);
                current = current.addSubpackage(segment);
            }
            return current;
        }

        @NotNull
        Collection<ApkPackage> values() {
            return this.myPackagesByName.values();
        }

        @Nullable
        ApkPackage findPackage(@NotNull String name) {
            return this.myPackagesByName.get(name);
        }
    }
}

