/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiFileNode;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    @NotNull
    private static final String GENERATED_SUFFIX = " (generated)";
    @NotNull
    private final AndroidSourceType mySourceType;
    @NotNull
    private final Set<VirtualFile> mySourceRoots;
    @NotNull
    protected final AndroidProjectViewPane myProjectViewPane;

    AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidSourceType sourceType, @NotNull Set<VirtualFile> sources, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, (Object)androidFacet, settings);
        this.mySourceType = sourceType;
        this.mySourceRoots = sources;
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList children = new ArrayList();
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        for (PsiDirectory directory : this.getSourceFolders()) {
            Collection directoryChildren = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            children.addAll(this.annotateWithSourceProvider(directoryChildren));
        }
        return children;
    }

    @NotNull
    private Collection<AbstractTreeNode<?>> annotateWithSourceProvider(@NotNull Collection<AbstractTreeNode<?>> folderChildren) {
        ArrayList children = new ArrayList(folderChildren.size());
        assert (this.myProject != null);
        for (AbstractTreeNode<?> child : folderChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory folder = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                assert (folder != null);
                children.add((AbstractTreeNode<?>)new AndroidPsiDirectoryNode(this.myProject, folder, this.getSettings(), this.findSourceProvider(folder.getVirtualFile())));
                continue;
            }
            if (child instanceof PsiFileNode) {
                PsiFile file2 = (PsiFile)((PsiFileNode)child).getValue();
                assert (file2 != null);
                VirtualFile virtualFile = file2.getVirtualFile();
                children.add((AbstractTreeNode<?>)new AndroidPsiFileNode(this.myProject, file2, this.getSettings(), this.findSourceProvider(virtualFile)));
                continue;
            }
            children.add(child);
        }
        return children;
    }

    @Nullable
    private NamedIdeaSourceProvider findSourceProvider(@NotNull VirtualFile virtualFile) {
        AndroidFacet androidFacet = (AndroidFacet)this.getValue();
        assert (androidFacet != null);
        for (NamedIdeaSourceProvider provider2 : AndroidProjectViewPane.getSourceProviders(androidFacet)) {
            if (!SourceProvidersKt.containsFile(provider2, virtualFile)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    protected List<PsiDirectory> getSourceFolders() {
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(this.mySourceRoots.size());
        for (VirtualFile root2 : this.mySourceRoots) {
            PsiDirectory folder;
            if (!root2.isValid() || (folder = psiManager.findDirectory(root2)) == null) continue;
            folders.add(folder);
        }
        return folders;
    }

    protected void update(@NotNull PresentationData presentation) {
        Icon icon2;
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.mySourceType.isGenerated()) {
            presentation.addText(GENERATED_SUFFIX, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((icon2 = this.mySourceType.getIcon()) != null) {
            presentation.setIcon(icon2);
        }
        presentation.setPresentableText(this.toTestString(null));
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.isGenerated() ? this.mySourceType.getName() + GENERATED_SUFFIX : this.mySourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        for (VirtualFile root2 : this.mySourceRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)o;
        if (this.mySourceType != that.mySourceType) {
            return false;
        }
        return this.mySourceRoots.equals(that.mySourceRoots);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mySourceType, this.mySourceRoots});
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return this.getSourceFolders();
    }
}

