/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.gradle.project.facet.ndk.NativeSourceRootType;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNodeKt;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class AndroidJniFolderNode
extends ProjectViewNode<NdkModuleModel>
implements FolderGroupNode {
    @NotNull
    private final VirtualFile myBuildFileFolder;
    private final int myCachedHashCode;

    AndroidJniFolderNode(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings settings) {
        super(project, (Object)ndkModuleModel, settings);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        this.myBuildFileFolder = Objects.requireNonNull(fileSystem.findFileByIoFile(ndkModuleModel.getRootDirPath()));
        this.myCachedHashCode = this.myBuildFileFolder.hashCode();
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        AbstractTreeNode sourceNode;
        assert (this.myProject != null);
        Collection<AbstractTreeNode<?>> nativeSourceNodes = NdkModuleNodeKt.getNativeSourceNodes(this.myProject, this.getNdkModel(), this.getSettings());
        if (nativeSourceNodes.size() == 1 && (sourceNode = (AbstractTreeNode)Iterables.getOnlyElement(nativeSourceNodes)) instanceof PsiDirectoryNode) {
            return sourceNode.getChildren();
        }
        return nativeSourceNodes;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        List<VirtualFile> sourceFolders = this.getNativeSourceFolders();
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(sourceFolders.size());
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile sourceFolder : sourceFolders) {
            PsiDirectory psiSourceFolder;
            if (sourceFolder == null || (psiSourceFolder = psiManager.findDirectory(sourceFolder)) == null) continue;
            folders.add(psiSourceFolder);
        }
        return folders;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        List<VirtualFile> sourceFolders = this.getNativeSourceFolders();
        for (VirtualFile virtualFile : sourceFolders) {
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        NdkModuleModel moduleModel = (NdkModuleModel)this.getValue();
        if (moduleModel == null) {
            return false;
        }
        return NdkModuleNodeKt.containedInIncludeFolders(this.getProject(), moduleModel, file2);
    }

    private List<VirtualFile> getNativeSourceFolders() {
        assert (this.myProject != null);
        Module module2 = ModuleManager.getInstance((Project)this.myProject).findModuleByName(this.getNdkModel().getModuleName());
        assert (module2 != null);
        return ModuleRootManager.getInstance((Module)module2).getSourceRoots((JpsModuleSourceRootType)NativeSourceRootType.INSTANCE);
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2);
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(AndroidSourceType.CPP.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon2 = AndroidSourceType.CPP.getIcon();
        if (icon2 != null) {
            presentation.setIcon(icon2);
        }
        presentation.setPresentableText(AndroidSourceType.CPP.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return AndroidSourceType.CPP.getName();
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.CPP;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.CPP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidJniFolderNode that = (AndroidJniFolderNode)o;
        return Objects.equals(this.myBuildFileFolder, that.myBuildFileFolder);
    }

    public int hashCode() {
        return this.myCachedHashCode;
    }

    public String toString() {
        return "cpp";
    }

    @NotNull
    private NdkModuleModel getNdkModel() {
        NdkModuleModel value2 = (NdkModuleModel)this.getValue();
        assert (value2 != null);
        return value2;
    }
}

