/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNodeUtil;
import com.android.tools.idea.navigator.nodes.ModuleNodeUtils;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptsGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.ExternalBuildFilesGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNodeKt;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidViewProjectNode
extends ProjectViewNode<Project> {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidViewProjectNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, (Object)project, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ExternalBuildFilesGroupNode externalBuildFilesNode;
        PsiDirectory folder;
        boolean lastSyncFailed;
        assert (this.myProject != null);
        ViewSettings settings = this.getSettings();
        AndroidProjectSystem projectSystem2 = ProjectSystemService.getInstance(this.myProject).getProjectSystem();
        AndroidViewProjectNodeUtil.maybeWaitForAnySyncOutcomeInterruptibly(projectSystem2.getSyncManager());
        List<AbstractTreeNode<?>> children = ModuleNodeUtils.createChildModuleNodes(this.myProject, projectSystem2.getSubmodules(), this.myProjectViewPane, settings);
        boolean buildWithGradle = GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle();
        boolean bl = lastSyncFailed = !ProjectSystemUtil.getSyncManager(this.myProject).getLastSyncResult().isSuccessful();
        if (children.isEmpty() && buildWithGradle && lastSyncFailed && (folder = PsiManager.getInstance((Project)this.myProject).findDirectory(this.myProject.getBaseDir())) != null) {
            children.add((AbstractTreeNode<?>)new PsiDirectoryNode(this.myProject, folder, settings));
        }
        if (buildWithGradle) {
            children.add((AbstractTreeNode<?>)new AndroidBuildScriptsGroupNode(this.myProject, settings));
        }
        if (!((Boolean)StudioFlags.USE_CONTENT_ROOTS_FOR_NATIVE_PROJECT_VIEW.get()).booleanValue() && !(externalBuildFilesNode = new ExternalBuildFilesGroupNode(this.myProject, settings)).getChildren().isEmpty()) {
            children.add((AbstractTreeNode<?>)externalBuildFilesNode);
        }
        return children;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        assert (this.myProject != null);
        return String.format("%1$s", this.myProject.getName());
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        Project project = this.getProject();
        assert (project != null);
        presentation.setPresentableText(project.getName());
    }

    public boolean contains(@NotNull VirtualFile file2) {
        assert (this.myProject != null);
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile projectRootFolder = this.myProject.getBaseDir();
        if (index2.isInContent(file2) || index2.isInLibrary(file2) || projectRootFolder != null && VfsUtilCore.isAncestor((VirtualFile)projectRootFolder, (VirtualFile)file2, (boolean)false)) {
            return true;
        }
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkFacet ndkFacet = NdkFacet.getInstance(module2);
            if (ndkFacet == null || ndkFacet.getNdkModuleModel() == null) continue;
            return NdkModuleNodeKt.containedInIncludeFolders(this.myProject, ndkFacet.getNdkModuleModel(), file2);
        }
        return false;
    }
}

