/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.editor;

import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorProvider;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.naveditor.editor.NavEditor;
import com.android.tools.idea.naveditor.editor.NavToolbarActionGroups;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.navigation.NavigationDomFileDescription;
import org.jetbrains.annotations.NotNull;

public class NavEditorProvider
extends DesignerEditorProvider {
    public NavEditorProvider() {
        super(Collections.singletonList(NavigationFileType.getInstance()));
    }

    @Override
    @NotNull
    public DesignerEditor createDesignEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        return new NavEditor(file2, project);
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        return "nav-designer";
    }

    private static class NavigationFileType
    implements DesignerEditorFileType {
        private static NavigationFileType ourInstance;

        private NavigationFileType() {
        }

        @Override
        @NotNull
        public DefaultActionGroup getSelectionContextToolbar(@NotNull DesignSurface surface2, @NotNull List<? extends NlComponent> selection) {
            return surface2.getActionManager().getToolbarActions(selection);
        }

        @Override
        public void setTypePrerequisites(@NotNull NlModel model2) {
        }

        public static NavigationFileType getInstance() {
            if (ourInstance == null) {
                ourInstance = new NavigationFileType();
            }
            return ourInstance;
        }

        @Override
        public boolean isResourceTypeOf(@NotNull PsiFile file2) {
            return file2 instanceof XmlFile && NavigationDomFileDescription.isNavFile((XmlFile)file2);
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface2) {
            return new NavToolbarActionGroups(surface2);
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }
}

