/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.annotations.concurrency.Slow;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.project.SyncTimestampUtil;
import com.android.tools.idea.projectsystem.ManifestOverrides;
import com.android.tools.idea.projectsystem.MergedManifestContributors;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import gnu.trove.TObjectLongHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

final class MergedManifestInfo {
    private static final Logger LOG = Logger.getInstance(MergedManifestInfo.class);
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final org.w3c.dom.Document myDomDocument;
    @NotNull
    private final ModificationStamps myModificationStamps;
    private final long mySyncTimestamp;
    @Nullable
    private final ImmutableList<MergingReport.Record> myLoggingRecords;
    @Nullable
    private final Actions myActions;

    private MergedManifestInfo(@NotNull AndroidFacet facet2, @Nullable org.w3c.dom.Document domDocument, @NotNull ModificationStamps modificationStamps, long syncTimestamp, @Nullable ImmutableList<MergingReport.Record> loggingRecords, @Nullable Actions actions2) {
        this.myFacet = facet2;
        this.myDomDocument = domDocument;
        this.myModificationStamps = modificationStamps;
        this.mySyncTimestamp = syncTimestamp;
        this.myLoggingRecords = loggingRecords;
        this.myActions = actions2;
    }

    @Slow
    @NotNull
    public static MergedManifestInfo create(@NotNull AndroidFacet facet2) {
        Project project = facet2.getModule().getProject();
        long syncTimestamp = SyncTimestampUtil.getLastSyncTimestamp(project);
        MergedManifestContributors contributors = ProjectSystemUtil.getModuleSystem(facet2).getMergedManifestContributors();
        ModificationStamps modificationStamps = ModificationStamps.forFiles(project, contributors.allFiles);
        org.w3c.dom.Document document = null;
        ImmutableList<MergingReport.Record> loggingRecords = null;
        Actions actions2 = null;
        ParsedMergeResult result2 = MergedManifestInfo.mergeManifests(facet2, contributors);
        if (result2 != null) {
            document = result2.document;
            loggingRecords = result2.loggingRecords;
            actions2 = result2.actions;
        }
        return new MergedManifestInfo(facet2, document, modificationStamps, syncTimestamp, loggingRecords, actions2);
    }

    @Slow
    @Nullable
    private static ParsedMergeResult mergeManifests(@NotNull AndroidFacet facet2, @NotNull MergedManifestContributors manifests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = facet2.getModule().getProject();
        if (project.isDisposed() || manifests.primaryManifest == null) {
            return null;
        }
        try {
            MergingReport mergingReport = MergedManifestInfo.getMergedManifest(facet2, manifests.primaryManifest, manifests.flavorAndBuildTypeManifests, manifests.libraryManifests, manifests.navigationFiles);
            XmlDocument doc = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            if (doc != null) {
                return new ParsedMergeResult(doc.getXml(), (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
            }
            LOG.warn("getMergedManifestSupplier failed " + mergingReport.getReportString());
            return new ParsedMergeResult(null, (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
        }
        catch (ManifestMerger2.MergeFailureException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            throw new MergedManifestException.MergingError(facet2.getModule(), (Throwable)e);
        }
    }

    public boolean isUpToDate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Disposer.isDisposed((Disposable)this.myFacet)) {
            return true;
        }
        MergedManifestContributors manifests = ProjectSystemUtil.getModuleSystem(this.myFacet).getMergedManifestContributors();
        if (manifests.primaryManifest == null) {
            return true;
        }
        long lastSyncTimestamp = SyncTimestampUtil.getLastSyncTimestamp(this.myFacet.getModule().getProject());
        if (this.myDomDocument == null || this.mySyncTimestamp != lastSyncTimestamp) {
            return false;
        }
        return this.myModificationStamps.equals(ModificationStamps.forFiles(this.myFacet.getModule().getProject(), manifests.allFiles));
    }

    public boolean hasSevereError() {
        return this.myLoggingRecords != null && this.myLoggingRecords.stream().anyMatch(record -> record.getSeverity() == MergingReport.Record.Severity.ERROR);
    }

    @Nullable
    public org.w3c.dom.Document getXmlDocument() {
        return this.myDomDocument;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public ImmutableList<VirtualFile> getFiles() {
        return this.myModificationStamps.getFiles();
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        return this.myLoggingRecords == null ? ImmutableList.of() : this.myLoggingRecords;
    }

    @Nullable
    public Actions getActions() {
        return this.myActions;
    }

    @Slow
    @NotNull
    static MergingReport getMergedManifest(@NotNull AndroidFacet facet2, final @NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, final @NotNull List<VirtualFile> libManifests, @NotNull List<VirtualFile> navigationFiles) throws ManifestMerger2.MergeFailureException {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final File mainManifestFile = VfsUtilCore.virtualToIoFile((VirtualFile)primaryManifestFile);
        ILogger logger2 = NullLogger.getLogger();
        ManifestMerger2.MergeType mergeType = ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppOrFeature() ? ManifestMerger2.MergeType.APPLICATION : ManifestMerger2.MergeType.LIBRARY;
        ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifestFile, (ILogger)logger2, (ManifestMerger2.MergeType)mergeType);
        manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING});
        manifestMergerInvoker.addFlavorAndBuildTypeManifests(VfsUtilCore.virtualToIoFiles(flavorAndBuildTypeManifests).toArray(new File[0]));
        manifestMergerInvoker.addNavigationFiles((Iterable)VfsUtilCore.virtualToIoFiles(navigationFiles));
        ArrayList<Pair> libraryManifests = new ArrayList<Pair>();
        for (VirtualFile file2 : libManifests) {
            libraryManifests.add(Pair.of((Object)file2.getName(), (Object)VfsUtilCore.virtualToIoFile((VirtualFile)file2)));
        }
        manifestMergerInvoker.addBundleManifests(libraryManifests);
        ManifestOverrides overrides = ProjectSystemUtil.getModuleSystem(facet2.getModule()).getManifestOverrides();
        overrides.getPlaceholders().forEach((placeholder, value2) -> manifestMergerInvoker.setPlaceHolderValue(placeholder, value2));
        overrides.getDirectOverrides().forEach((property2, value2) -> manifestMergerInvoker.setOverride(property2, value2));
        if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
            manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
        }
        final Module module2 = facet2.getModule();
        final Project project = module2.getProject();
        final FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        manifestMergerInvoker.withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

            protected InputStream getInputStream(@NotNull File file2) throws IOException {
                MergedManifestSnapshot manifest;
                org.w3c.dom.Document document;
                Module moduleContainingManifest;
                ProgressManager.checkCanceled();
                VirtualFile vFile = file2 == mainManifestFile ? primaryManifestFile : VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (vFile == null) {
                    return new ByteArrayInputStream("<manifest/>".getBytes(StandardCharsets.UTF_8));
                }
                if (!libManifests.isEmpty() && (moduleContainingManifest = this.getAndroidModuleForManifest(vFile)) != null && !module2.equals(moduleContainingManifest) && (document = (manifest = MergedManifestManager.getFreshSnapshotInCallingThread(moduleContainingManifest)).getDocument()) != null) {
                    String text2 = XmlUtils.toXml((Node)document);
                    return new ByteArrayInputStream(text2.getBytes(StandardCharsets.UTF_8));
                }
                Document document2 = fileDocumentManager.getCachedDocument(vFile);
                if (document2 != null) {
                    return new CharSequenceInputStream(document2.getCharsSequence(), StandardCharsets.UTF_8);
                }
                return vFile.getInputStream();
            }

            @Nullable
            private Module getAndroidModuleForManifest(@NotNull VirtualFile vFile) {
                for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance((Module)m);
                    if (androidFacet == null) continue;
                    List<VirtualFile> manifestFiles = SourceProvidersKt.getManifestFiles(androidFacet);
                    for (VirtualFile manifestFile : manifestFiles) {
                        if (!vFile.equals(manifestFile)) continue;
                        return m;
                    }
                }
                return null;
            }
        });
        return manifestMergerInvoker.merge();
    }

    private static class ModificationStamps {
        @NotNull
        private final ImmutableList<VirtualFile> files;
        @NotNull
        private final TObjectLongHashMap<Object> modificationStamps;

        private ModificationStamps(@NotNull ImmutableList<VirtualFile> files2, @NotNull TObjectLongHashMap<Object> modificationStamps) {
            this.files = files2;
            this.modificationStamps = modificationStamps;
        }

        @NotNull
        public static ModificationStamps forFiles(@NotNull Project project, @NotNull List<VirtualFile> files2) {
            ImmutableList.Builder fileListBuilder = ImmutableList.builder();
            TObjectLongHashMap modificationStamps = new TObjectLongHashMap();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (VirtualFile file2 : files2) {
                fileListBuilder.add((Object)file2);
                try {
                    PsiFile psiFile2 = psiManager.findFile(file2);
                    if (psiFile2 == null) {
                        modificationStamps.put((Object)file2, file2.getModificationStamp());
                        continue;
                    }
                    modificationStamps.put((Object)psiFile2, psiFile2.getModificationStamp());
                }
                catch (ProcessCanceledException processCanceledException) {}
            }
            return new ModificationStamps((ImmutableList<VirtualFile>)fileListBuilder.build(), (TObjectLongHashMap<Object>)modificationStamps);
        }

        @NotNull
        public ImmutableList<VirtualFile> getFiles() {
            return this.files;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ModificationStamps)) {
                return false;
            }
            return this.modificationStamps.equals(((ModificationStamps)other).modificationStamps);
        }

        public int hashCode() {
            return this.modificationStamps.hashCode();
        }
    }

    private static class ParsedMergeResult {
        @Nullable
        final org.w3c.dom.Document document;
        @NotNull
        final ImmutableList<MergingReport.Record> loggingRecords;
        @NotNull
        final Actions actions;

        ParsedMergeResult(@Nullable org.w3c.dom.Document document, @NotNull ImmutableList<MergingReport.Record> loggingRecords, @NotNull Actions actions2) {
            this.document = document;
            this.loggingRecords = loggingRecords;
            this.actions = actions2;
        }
    }
}

