/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.viewer;

import com.android.tools.idea.mlkit.LoggingUtils;
import com.android.tools.idea.mlkit.MlModuleService;
import com.android.tools.idea.mlkit.lightpsi.LightModelClass;
import com.android.tools.idea.mlkit.viewer.HtmlUtils;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.android.utils.StringHelper;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.wireless.android.sdk.stats.MlModelBindingEvent;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class TfliteModelFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final String NAME = "TFLite Model File";
    private static final ImmutableList<String> TENSOR_TABLE_HEADER = ImmutableList.of((Object)"Name", (Object)"Type", (Object)"Description", (Object)"Shape", (Object)"Min / Max");
    private static final String LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
    private static final String INDENT = "    ";
    private static final Color CODE_PANE_BORDER_COLOR = new JBColor(0xC9C9C9, 2895664);
    private static final Color CODE_EDITOR_BG_COLOR = JBColor.namedColor((String)"MlModelBinding.Viewer.CodeEditor.background", (int)15856628, (int)4013889);
    private final Project myProject;
    private final VirtualFile myFile;
    @Nullable
    private final Module myModule;
    private final UiStyleTracker myUiStyleTracker;
    private final JBScrollPane myRootPane;
    @Nullable
    private JBTabbedPane myTabbedCodePaneForFocus;
    @Nullable
    private LightModelClass myLightModelClass;

    public TfliteModelFileEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        this.myProject = project;
        this.myFile = file2;
        this.myModule = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
        this.myUiStyleTracker = new UiStyleTracker();
        this.myLightModelClass = this.getLatestLightModelClass();
        this.myRootPane = new JBScrollPane((Component)this.createContentPanel());
        this.myRootPane.setFocusCycleRoot(true);
        this.myRootPane.setFocusTraversalPolicy((FocusTraversalPolicy)new EditorFocusTraversalPolicy());
        if (this.myLightModelClass != null) {
            LoggingUtils.logEvent(MlModelBindingEvent.EventType.MODEL_VIEWER_OPEN, this.myLightModelClass.getModelInfo());
        } else {
            LoggingUtils.logEvent(MlModelBindingEvent.EventType.MODEL_VIEWER_OPEN, file2);
        }
    }

    @NotNull
    private JComponent createContentPanel() {
        if (this.myFile.getLength() > 0xC800000L) {
            return TfliteModelFileEditor.createWarningMessagePanel("This file is over the maximum supported size 200 MB.");
        }
        try {
            JPanel contentPanel2 = TfliteModelFileEditor.createPanelWithYAxisBoxLayout(JBUI.Borders.empty((int)20));
            ModelInfo modelInfo = this.myLightModelClass != null ? this.myLightModelClass.getModelInfo() : ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(Files.readAllBytes(VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile).toPath())));
            if (!modelInfo.isMinParserVersionSatisfied()) {
                contentPanel2.add(TfliteModelFileEditor.createMetadataVersionTooHighSection());
            } else if (modelInfo.isMetadataExisted()) {
                contentPanel2.add(TfliteModelFileEditor.createModelSection(modelInfo));
                contentPanel2.add(TfliteModelFileEditor.createTensorsSection(modelInfo));
            } else {
                contentPanel2.add(TfliteModelFileEditor.createNoMetadataSection());
            }
            if (this.myLightModelClass != null) {
                contentPanel2.add(this.createSampleCodeSection(this.myLightModelClass, modelInfo));
            }
            return contentPanel2;
        }
        catch (TfliteModelException e) {
            return TfliteModelFileEditor.createWarningMessagePanel(e.getMessage());
        }
        catch (IOException e) {
            Logger.getInstance(TfliteModelFileEditor.class).error((Throwable)e);
            return TfliteModelFileEditor.createWarningMessagePanel("Error reading model file.");
        }
    }

    @Nullable
    private LightModelClass getLatestLightModelClass() {
        if (this.myModule != null) {
            return MlModuleService.getInstance(this.myModule).getLightModelClassList().stream().filter(lightModelClass -> lightModelClass.getModelFile().getUrl().equals(this.myFile.getUrl())).findFirst().orElse(null);
        }
        return null;
    }

    @NotNull
    private static JComponent createSectionHeader(@NotNull String title) {
        JBLabel titleLabel = new JBLabel(title);
        titleLabel.setAlignmentX(0.0f);
        titleLabel.setBackground(UIUtil.getTextFieldBackground());
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)0));
        Font font = titleLabel.getFont();
        titleLabel.setFont(font.deriveFont(font.getStyle() | 1).deriveFont((float)font.getSize() * 1.2f));
        return titleLabel;
    }

    @NotNull
    private static JComponent createNoMetadataSection() {
        JPanel sectionPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.empty());
        sectionPanel.add(TfliteModelFileEditor.createSectionHeader("Model"));
        JPanel sectionContentPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.empty((int)50, (int)100, (int)50, (int)0));
        sectionPanel.add(sectionContentPanel);
        JBLabel infoLabel = new JBLabel("No metadata found in this model");
        infoLabel.setAlignmentX(0.0f);
        infoLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
        sectionContentPanel.add((Component)infoLabel);
        HyperlinkLabel addMetadataLinkLabel = new HyperlinkLabel("Add metadata to your model");
        addMetadataLinkLabel.setAlignmentX(0.0f);
        addMetadataLinkLabel.setHyperlinkTarget("https://www.tensorflow.org/lite/convert/metadata");
        addMetadataLinkLabel.setIcon(AllIcons.General.ContextHelp);
        addMetadataLinkLabel.setMaximumSize(addMetadataLinkLabel.getPreferredSize());
        sectionContentPanel.add((Component)addMetadataLinkLabel);
        return sectionPanel;
    }

    @NotNull
    private static JComponent createMetadataVersionTooHighSection() {
        JPanel sectionPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.empty());
        sectionPanel.add(TfliteModelFileEditor.createSectionHeader("Model"));
        JBLabel infoLabel = new JBLabel("Model is not fully supported in current Android Studio or Android Gradle Plugin. Please update to the latest version to get the best experience.");
        infoLabel.setAlignmentX(0.0f);
        infoLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)20, (int)10, (int)0));
        sectionPanel.add((Component)infoLabel);
        return sectionPanel;
    }

    @NotNull
    private static JComponent createModelSection(@NotNull ModelInfo modelInfo) {
        JPanel sectionPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.empty());
        sectionPanel.add(TfliteModelFileEditor.createSectionHeader("Model"));
        JPanel modelTablePanel = TfliteModelFileEditor.createPanelWithFlowLayout((Border)JBUI.Borders.emptyLeft((int)20));
        TfliteModelFileEditor.addTable(modelTablePanel, TfliteModelFileEditor.getModelTableData(modelInfo), Collections.emptyList());
        sectionPanel.add(modelTablePanel);
        sectionPanel.setMaximumSize(sectionPanel.getPreferredSize());
        return sectionPanel;
    }

    @NotNull
    private static JComponent createTensorsSection(@NotNull ModelInfo modelInfo) {
        JPanel sectionContentPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.emptyLeft((int)20));
        JBLabel inputsLabel = new JBLabel("Inputs");
        inputsLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)0));
        sectionContentPanel.add((Component)inputsLabel);
        JBTable inputTensorTable = TfliteModelFileEditor.addTable(sectionContentPanel, TfliteModelFileEditor.getTensorTableData(modelInfo.getInputs()), TENSOR_TABLE_HEADER);
        inputTensorTable.setBorder(BorderFactory.createLineBorder((Color)JBColor.LIGHT_GRAY));
        JBLabel outputsLabel = new JBLabel("Outputs");
        outputsLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)6, (int)0));
        sectionContentPanel.add((Component)outputsLabel);
        JBTable outputTensorTable = TfliteModelFileEditor.addTable(sectionContentPanel, TfliteModelFileEditor.getTensorTableData(modelInfo.getOutputs()), TENSOR_TABLE_HEADER);
        outputTensorTable.setBorder(BorderFactory.createLineBorder((Color)JBColor.LIGHT_GRAY));
        for (int c = 0; c < TENSOR_TABLE_HEADER.size(); ++c) {
            TableColumn inputTensorTableColumn = inputTensorTable.getColumnModel().getColumn(c);
            TableColumn outputTensorTableColumn = outputTensorTable.getColumnModel().getColumn(c);
            int newColumnWidth = Math.max(inputTensorTableColumn.getPreferredWidth(), outputTensorTableColumn.getPreferredWidth());
            inputTensorTableColumn.setPreferredWidth(newColumnWidth);
            outputTensorTableColumn.setPreferredWidth(newColumnWidth);
        }
        JPanel sectionContentPanelContainer = TfliteModelFileEditor.createPanelWithFlowLayout((Border)JBUI.Borders.empty());
        sectionContentPanelContainer.add(sectionContentPanel);
        sectionContentPanelContainer.setMaximumSize(sectionContentPanelContainer.getPreferredSize());
        JPanel sectionPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.empty());
        sectionPanel.add(TfliteModelFileEditor.createSectionHeader("Tensors"));
        sectionPanel.add(sectionContentPanelContainer);
        return sectionPanel;
    }

    @NotNull
    private JComponent createSampleCodeSection(@NotNull PsiClass modelClass, @NotNull ModelInfo modelInfo) {
        JPanel sectionPanel = TfliteModelFileEditor.createPanelWithYAxisBoxLayout((Border)JBUI.Borders.empty());
        JComponent header = TfliteModelFileEditor.createSectionHeader("Sample Code");
        sectionPanel.add(header);
        JPanel codePaneContainer = TfliteModelFileEditor.createPanelWithFlowLayout((Border)JBUI.Borders.empty((int)8, (int)20, (int)0, (int)0));
        sectionPanel.add(codePaneContainer);
        JBTabbedPane tabbedCodePane = new JBTabbedPane();
        tabbedCodePane.setBackground(UIUtil.getTextFieldBackground());
        tabbedCodePane.setBorder(BorderFactory.createLineBorder(CODE_PANE_BORDER_COLOR));
        tabbedCodePane.setTabComponentInsets((Insets)JBUI.insets((int)0));
        String sampleKotlinCode = TfliteModelFileEditor.buildSampleCodeInKotlin(modelClass, modelInfo);
        tabbedCodePane.add("Kotlin", (Component)TfliteModelFileEditor.createCodeEditor(this.myProject, (FileType)KotlinFileType.INSTANCE, sampleKotlinCode));
        String sampleJavaCode = TfliteModelFileEditor.buildSampleCodeInJava(modelClass, modelInfo);
        tabbedCodePane.add("Java", (Component)TfliteModelFileEditor.createCodeEditor(this.myProject, (FileType)JavaFileType.INSTANCE, sampleJavaCode));
        codePaneContainer.add((Component)tabbedCodePane);
        this.myTabbedCodePaneForFocus = tabbedCodePane;
        return sectionPanel;
    }

    @NotNull
    private static EditorTextField createCodeEditor(@NotNull Project project, @NotNull FileType fileType, @NotNull String codeBody) {
        EditorTextField codeEditor = new EditorTextField(codeBody, project, fileType);
        codeEditor.setAlignmentX(0.0f);
        codeEditor.setBackground(CODE_EDITOR_BG_COLOR);
        codeEditor.setBorder(JBUI.Borders.customLine((Color)CODE_EDITOR_BG_COLOR, (int)12));
        codeEditor.setFont(new Font("Monospaced", 0, StartupUiUtil.getLabelFont().getSize()));
        codeEditor.setOneLineMode(false);
        codeEditor.getDocument().setReadOnly(true);
        return codeEditor;
    }

    @NotNull
    private static JComponent createWarningMessagePanel(@NotNull String message2) {
        JLabel messageLabel = new JLabel(message2);
        messageLabel.setBackground(UIUtil.getTextFieldBackground());
        messageLabel.setHorizontalAlignment(0);
        messageLabel.setVerticalAlignment(0);
        return messageLabel;
    }

    @NotNull
    private static JBTable addTable(@NotNull JPanel tableContainer, @NotNull List<List<String>> rowDataList, @NotNull List<String> headerData) {
        MetadataTableModel tableModel2 = new MetadataTableModel(rowDataList, headerData);
        final JBTable table2 = new JBTable((TableModel)tableModel2);
        table2.setAlignmentX(0.0f);
        table2.setAutoResizeMode(0);
        table2.setBackground(UIUtil.getTextFieldBackground());
        table2.setDefaultEditor(String.class, (TableCellEditor)new MetadataCellComponentProvider());
        table2.setDefaultRenderer(String.class, (TableCellRenderer)new MetadataCellComponentProvider());
        table2.setRowSelectionAllowed(false);
        table2.setShowGrid(false);
        table2.setShowColumns(true);
        table2.getTableHeader().setReorderingAllowed(false);
        table2.getTableHeader().setResizingAllowed(false);
        table2.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                int row = table2.rowAtPoint(event.getPoint());
                int column = table2.columnAtPoint(event.getPoint());
                if (row != -1 && column != -1 && table2.isCellEditable(row, column)) {
                    table2.editCellAt(row, column);
                } else {
                    table2.removeEditor();
                }
            }
        });
        if (!headerData.isEmpty()) {
            JTableHeader tableHeader = table2.getTableHeader();
            tableHeader.setAlignmentX(0.0f);
            tableHeader.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, (Color)JBColor.LIGHT_GRAY));
            tableHeader.setDefaultRenderer(new TableHeaderCellRenderer());
            tableContainer.add(tableHeader);
        }
        TableCellRenderer headerCellRenderer = table2.getTableHeader().getDefaultRenderer();
        int[] rowHeights = new int[table2.getRowCount()];
        for (int c = 0; c < table2.getColumnCount(); ++c) {
            TableColumn column = table2.getColumnModel().getColumn(c);
            int cellWidth = headerCellRenderer.getTableCellRendererComponent((JTable)table2, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)c).getPreferredSize().width;
            for (int r = 0; r < table2.getRowCount(); ++r) {
                TableCellRenderer cellRenderer2 = table2.getCellRenderer(r, c);
                Dimension preferredSize = table2.prepareRenderer(cellRenderer2, r, c).getPreferredSize();
                cellWidth = Math.max(cellWidth, preferredSize.width);
                rowHeights[r] = Math.max(rowHeights[r], preferredSize.height);
            }
            column.setPreferredWidth(cellWidth + JBUIScale.scale((int)4));
        }
        for (int r = 0; r < table2.getRowCount(); ++r) {
            table2.setRowHeight(r, rowHeights[r]);
        }
        tableContainer.add((Component)table2);
        return table2;
    }

    @NotNull
    private static List<List<String>> getModelTableData(@NotNull ModelInfo modelInfo) {
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        tableData.add(Lists.newArrayList((Object[])new String[]{"Name", modelInfo.getModelName()}));
        tableData.add(Lists.newArrayList((Object[])new String[]{"Description", TfliteModelFileEditor.breakIntoMultipleLines(modelInfo.getModelDescription(), 80)}));
        tableData.add(Lists.newArrayList((Object[])new String[]{"Version", modelInfo.getModelVersion()}));
        tableData.add(Lists.newArrayList((Object[])new String[]{"Author", modelInfo.getModelAuthor()}));
        tableData.add(Lists.newArrayList((Object[])new String[]{"License", TfliteModelFileEditor.breakIntoMultipleLines(modelInfo.getModelLicense(), 80)}));
        return tableData;
    }

    @NotNull
    private static List<List<String>> getTensorTableData(List<TensorInfo> tensorInfoList) {
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        for (TensorInfo tensorInfo : tensorInfoList) {
            TensorInfo.NormalizationParams params = tensorInfo.getNormalizationParams();
            String minMaxColumn = TfliteModelFileEditor.isValidMinMaxColumn(params) ? TfliteModelFileEditor.convertFloatArrayPairToString(params.getMin(), params.getMax()) : "[] / []";
            tableData.add(Lists.newArrayList((Object[])new String[]{tensorInfo.getName(), TfliteModelFileEditor.getTypeStringForDisplay(tensorInfo), TfliteModelFileEditor.breakIntoMultipleLines(tensorInfo.getDescription(), 60), Arrays.toString(tensorInfo.getShape()), minMaxColumn}));
        }
        return tableData;
    }

    @NotNull
    private static String getTypeStringForDisplay(@NotNull TensorInfo tensorInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (tensorInfo.getContentType() == TensorInfo.ContentType.IMAGE) {
            stringBuilder.append(tensorInfo.isRGBImage() ? TfliteModelFileEditor.formatUpperString(CaseFormat.UPPER_CAMEL, TensorInfo.ContentType.IMAGE.toString()) : TfliteModelFileEditor.formatUpperString(CaseFormat.UPPER_CAMEL, TensorInfo.ContentType.FEATURE.toString()));
        } else {
            stringBuilder.append(TfliteModelFileEditor.formatUpperString(CaseFormat.UPPER_CAMEL, tensorInfo.getContentType().toString()));
        }
        stringBuilder.append(String.format("%s<%s>", LINE_SEPARATOR, TfliteModelFileEditor.formatUpperString(CaseFormat.LOWER_CAMEL, tensorInfo.getDataType().toString())));
        return stringBuilder.toString();
    }

    @NotNull
    private static String formatUpperString(@NotNull CaseFormat caseFormat, @NotNull String content2) {
        return CaseFormat.UPPER_UNDERSCORE.to(caseFormat, content2);
    }

    private static boolean isValidMinMaxColumn(@NotNull TensorInfo.NormalizationParams params) {
        for (float min : params.getMin()) {
            if (Floats.compare((float)min, (float)Float.MIN_VALUE) == 0) continue;
            return true;
        }
        for (float max : params.getMax()) {
            if (Floats.compare((float)max, (float)Float.MAX_VALUE) == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String buildSampleCodeInJava(@NotNull PsiClass modelClass, @NotNull ModelInfo modelInfo) {
        boolean hasGroupInfo;
        StringBuilder codeBuilder = new StringBuilder("try {\n");
        String modelClassName = modelClass.getName();
        codeBuilder.append(INDENT).append(String.format("%s model = %s.newInstance(context);\n\n", modelClassName, modelClassName));
        PsiMethod processMethod = TfliteModelFileEditor.findUndeprecatedProcessMethod(modelClass);
        if (processMethod.getReturnType() != null) {
            codeBuilder.append(TfliteModelFileEditor.buildTensorInputSampleCodeInJava(processMethod, modelInfo));
            codeBuilder.append(INDENT).append("// Runs model inference and gets result.\n");
            String parameterNames = Arrays.stream(processMethod.getParameterList().getParameters()).map(PsiParameter::getName).collect(Collectors.joining(", "));
            codeBuilder.append(INDENT).append(String.format("%s.%s outputs = model.%s(%s);\n", modelClassName, processMethod.getReturnType().getPresentableText(), processMethod.getName(), parameterNames));
        }
        PsiClass outputsClass = TfliteModelFileEditor.getInnerOutputsClass(modelClass);
        boolean bl = hasGroupInfo = !modelInfo.getOutputTensorGroups().isEmpty();
        if (outputsClass != null) {
            if (!hasGroupInfo) {
                Iterator outputTensorNameIterator = modelInfo.getOutputs().stream().map(TensorInfo::getIdentifierName).iterator();
                List normalMethods = ContainerUtil.filter(Arrays.asList(outputsClass.getMethods()), method2 -> TfliteModelFileEditor.isOriginInfoMatched(method2, "normal method"));
                for (PsiMethod psiMethod : normalMethods) {
                    if (psiMethod.isDeprecated()) continue;
                    String tensorName = (String)outputTensorNameIterator.next();
                    codeBuilder.append(INDENT).append(String.format("%s %s = outputs.%s();\n", Objects.requireNonNull(psiMethod.getReturnType()).getPresentableText(), tensorName, psiMethod.getName()));
                    switch (psiMethod.getReturnType().getCanonicalText()) {
                        case "org.tensorflow.lite.support.label.TensorLabel": {
                            codeBuilder.append(INDENT).append(String.format("Map<String, Float> %sMap = %s.getMapWithFloatValue();\n", tensorName, tensorName));
                            break;
                        }
                        case "org.tensorflow.lite.support.image.TensorImage": {
                            codeBuilder.append(INDENT).append(String.format("Bitmap %sBitmap = %s.getBitmap();\n", tensorName, tensorName));
                        }
                    }
                }
            } else {
                Iterator groupNameIterator = modelInfo.getOutputTensorGroups().stream().map(TensorGroupInfo::getIdentifierName).iterator();
                List groupMethods = ContainerUtil.filter(Arrays.asList(outputsClass.getMethods()), method2 -> TfliteModelFileEditor.isOriginInfoMatched(method2, "group method"));
                for (PsiMethod psiMethod : groupMethods) {
                    String groupName = (String)groupNameIterator.next();
                    PsiClass groupClass = TfliteModelFileEditor.getInnerGroupClass(modelClass, psiMethod.getReturnType());
                    codeBuilder.append(INDENT).append(String.format("%s %s = outputs.%s().get(0);\n", groupClass.getName(), groupName, psiMethod.getName()));
                    codeBuilder.append("\n    ").append(String.format("// Gets result from %s.\n", groupClass.getName()));
                    Iterator tensorNameIterator = TfliteModelFileEditor.getTensorGroupInfoByIdentifierName(modelInfo, StringHelper.usLocaleDecapitalize((String)groupClass.getName())).getTensorNames().iterator();
                    for (PsiMethod groupMethod : groupClass.getMethods()) {
                        codeBuilder.append(INDENT).append(String.format("%s %s = %s.%s();\n", Objects.requireNonNull(groupMethod.getReturnType()).getPresentableText(), tensorNameIterator.next(), groupName, groupMethod.getName()));
                    }
                }
            }
            codeBuilder.append("\n");
        }
        codeBuilder.append(INDENT).append("// Releases model resources if no longer used.\n").append(INDENT).append("model.close();\n");
        codeBuilder.append("} catch (IOException e) {\n").append(INDENT).append("// TODO Handle the exception\n").append("}\n");
        return codeBuilder.toString();
    }

    private static boolean isOriginInfoMatched(@NotNull PsiMethod psiMethod, @NotNull String originInfo) {
        return psiMethod instanceof LightMethodBuilder && ((LightMethodBuilder)psiMethod).getOriginInfo().equals(originInfo);
    }

    @NotNull
    private static TensorGroupInfo getTensorGroupInfoByIdentifierName(@NotNull ModelInfo modelInfo, @NotNull String identifierName) {
        Optional<TensorGroupInfo> optional2 = modelInfo.getOutputTensorGroups().stream().filter(tensorGroupInfo -> tensorGroupInfo.getIdentifierName().equals(identifierName)).findFirst();
        if (!optional2.isPresent()) {
            Logger.getInstance(TfliteModelFileEditor.class).error(String.format("Model %s doesn't have tensor group with name: %s", modelInfo.getModelName(), identifierName));
        }
        return optional2.get();
    }

    @NotNull
    private static String buildSampleCodeInKotlin(@NotNull PsiClass modelClass, @NotNull ModelInfo modelInfo) {
        boolean hasGroupInfo;
        StringBuilder codeBuilder = new StringBuilder(String.format("val model = %s.newInstance(context)\n\n", modelClass.getName()));
        PsiMethod processMethod = TfliteModelFileEditor.findUndeprecatedProcessMethod(modelClass);
        if (processMethod.getReturnType() != null) {
            codeBuilder.append(TfliteModelFileEditor.buildTensorInputSampleCodeInKotlin(processMethod, modelInfo));
            String parameterNames = Arrays.stream(processMethod.getParameterList().getParameters()).map(PsiParameter::getName).collect(Collectors.joining(", "));
            codeBuilder.append("// Runs model inference and gets result.\n").append(String.format("val outputs = model.%s(%s)\n", processMethod.getName(), parameterNames));
        }
        PsiClass outputsClass = TfliteModelFileEditor.getInnerOutputsClass(modelClass);
        boolean bl = hasGroupInfo = !modelInfo.getOutputTensorGroups().isEmpty();
        if (outputsClass != null) {
            if (!hasGroupInfo) {
                Iterator outputTensorNameIterator = modelInfo.getOutputs().stream().map(TensorInfo::getIdentifierName).iterator();
                List normalMethods = ContainerUtil.filter(Arrays.asList(outputsClass.getMethods()), method2 -> TfliteModelFileEditor.isOriginInfoMatched(method2, "normal method"));
                for (PsiMethod psiMethod : normalMethods) {
                    if (psiMethod.isDeprecated()) continue;
                    String tensorName = (String)outputTensorNameIterator.next();
                    codeBuilder.append(String.format("val %s = outputs.%s\n", tensorName, TfliteModelFileEditor.convertToKotlinPropertyName(psiMethod.getName())));
                    switch (Objects.requireNonNull(psiMethod.getReturnType()).getCanonicalText()) {
                        case "org.tensorflow.lite.support.label.TensorLabel": {
                            codeBuilder.append(String.format("val %sMap = %s.mapWithFloatValue\n", tensorName, tensorName));
                            break;
                        }
                        case "org.tensorflow.lite.support.image.TensorImage": {
                            codeBuilder.append(String.format("val %sBitmap = %s.bitmap\n", tensorName, tensorName));
                        }
                    }
                }
            } else {
                Iterator groupNameIterator = modelInfo.getOutputTensorGroups().stream().map(TensorGroupInfo::getIdentifierName).iterator();
                List groupMethods = ContainerUtil.filter(Arrays.asList(outputsClass.getMethods()), method2 -> TfliteModelFileEditor.isOriginInfoMatched(method2, "group method"));
                for (PsiMethod psiMethod : groupMethods) {
                    String groupName = (String)groupNameIterator.next();
                    PsiClass groupClass = TfliteModelFileEditor.getInnerGroupClass(modelClass, psiMethod.getReturnType());
                    codeBuilder.append(String.format("val %s = outputs.%s.get(0)\n", groupName, TfliteModelFileEditor.convertToKotlinPropertyName(psiMethod.getName())));
                    Iterator tensorNameIterator = TfliteModelFileEditor.getTensorGroupInfoByIdentifierName(modelInfo, StringHelper.usLocaleDecapitalize((String)groupClass.getName())).getTensorNames().iterator();
                    codeBuilder.append("\n").append(String.format(String.format("// Gets result from %s.\n", groupClass.getName()), new Object[0]));
                    for (PsiMethod groupMethod : groupClass.getMethods()) {
                        codeBuilder.append(String.format("val %s = %s.%s;\n", tensorNameIterator.next(), groupName, TfliteModelFileEditor.convertToKotlinPropertyName(groupMethod.getName())));
                    }
                }
            }
            codeBuilder.append("\n");
        }
        codeBuilder.append("// Releases model resources if no longer used.\n").append("model.close()\n");
        return codeBuilder.toString();
    }

    @NotNull
    private static PsiMethod findUndeprecatedProcessMethod(@NotNull PsiClass psiClass) {
        PsiMethod[] methods2 = psiClass.findMethodsByName("process", false);
        return (PsiMethod)ContainerUtil.filter(Arrays.asList(methods2), method2 -> !method2.isDeprecated()).get(0);
    }

    @NotNull
    private static String convertToKotlinPropertyName(String getterMethodName) {
        return StringHelper.usLocaleDecapitalize((String)getterMethodName.substring(3));
    }

    @NotNull
    private static String buildTensorInputSampleCodeInJava(@NotNull PsiMethod processMethod, @NotNull ModelInfo modelInfo) {
        StringBuilder codeBuilder = new StringBuilder("    // Creates inputs for reference.\n");
        Iterator tensorInfoIterator = modelInfo.getInputs().iterator();
        block8: for (PsiParameter parameter : processMethod.getParameterList().getParameters()) {
            TensorInfo tensorInfo = (TensorInfo)tensorInfoIterator.next();
            switch (parameter.getType().getCanonicalText()) {
                case "org.tensorflow.lite.support.image.TensorImage": {
                    codeBuilder.append(INDENT).append(String.format("TensorImage %s = TensorImage.fromBitmap(bitmap);\n", parameter.getName()));
                    continue block8;
                }
                case "org.tensorflow.lite.support.tensorbuffer.TensorBuffer": {
                    codeBuilder.append(INDENT).append(String.format("TensorBuffer %s = TensorBuffer.createFixedSize(%s, %s);\n", parameter.getName(), TfliteModelFileEditor.buildIntArrayInJava(tensorInfo.getShape()), TfliteModelFileEditor.buildDataType(tensorInfo.getDataType())));
                    codeBuilder.append(INDENT).append(String.format("%s.loadBuffer(byteBuffer);\n", parameter.getName()));
                }
            }
        }
        codeBuilder.append("\n");
        return codeBuilder.toString();
    }

    @NotNull
    private static String buildTensorInputSampleCodeInKotlin(@NotNull PsiMethod processMethod, @NotNull ModelInfo modelInfo) {
        StringBuilder codeBuilder = new StringBuilder("// Creates inputs for reference.\n");
        Iterator tensorInfoIterator = modelInfo.getInputs().iterator();
        block8: for (PsiParameter parameter : processMethod.getParameterList().getParameters()) {
            TensorInfo tensorInfo = (TensorInfo)tensorInfoIterator.next();
            switch (parameter.getType().getCanonicalText()) {
                case "org.tensorflow.lite.support.image.TensorImage": {
                    codeBuilder.append(String.format("val %s = TensorImage.fromBitmap(bitmap)\n", parameter.getName()));
                    continue block8;
                }
                case "org.tensorflow.lite.support.tensorbuffer.TensorBuffer": {
                    codeBuilder.append(String.format("val %s = TensorBuffer.createFixedSize(%s, %s)\n", parameter.getName(), TfliteModelFileEditor.buildIntArrayInKotlin(tensorInfo.getShape()), TfliteModelFileEditor.buildDataType(tensorInfo.getDataType())));
                    codeBuilder.append(String.format("%s.loadBuffer(byteBuffer)\n", parameter.getName()));
                }
            }
        }
        codeBuilder.append("\n");
        return codeBuilder.toString();
    }

    @NotNull
    private static String buildIntArrayInJava(@NotNull int[] array) {
        return Arrays.stream(array).mapToObj(Integer::toString).collect(Collectors.joining(", ", "new int[]{", "}"));
    }

    @NotNull
    private static String buildIntArrayInKotlin(@NotNull int[] array) {
        return Arrays.stream(array).mapToObj(Integer::toString).collect(Collectors.joining(", ", "intArrayOf(", ")"));
    }

    @NotNull
    private static String buildDataType(@NotNull TensorInfo.DataType dataType) {
        return "DataType." + dataType.toString();
    }

    @Nullable
    private static PsiClass getInnerOutputsClass(@NotNull PsiClass modelClass) {
        return TfliteModelFileEditor.getInnerClass(modelClass, "Outputs");
    }

    @Nullable
    private static PsiClass getInnerGroupClass(@NotNull PsiClass modelClass, @Nullable PsiType returnType) {
        PsiType[] psiTypes;
        if (returnType instanceof PsiClassType && (psiTypes = ((PsiClassType)returnType).getParameters()).length == 1) {
            return TfliteModelFileEditor.getInnerClass(modelClass, psiTypes[0].getPresentableText());
        }
        return null;
    }

    @Nullable
    private static PsiClass getInnerClass(@NotNull PsiClass modelClass, @NotNull String innerClassName) {
        for (PsiClass innerClass : modelClass.getInnerClasses()) {
            if (!innerClassName.equals(innerClass.getName())) continue;
            return innerClass;
        }
        return null;
    }

    @NotNull
    public JComponent getComponent() {
        LightModelClass lightModelClass = this.getLatestLightModelClass();
        if (this.myUiStyleTracker.isUiStyleChanged() || !Objects.equals((Object)this.myLightModelClass, (Object)lightModelClass)) {
            this.myLightModelClass = lightModelClass;
            this.myRootPane.setViewportView((Component)this.createContentPanel());
        }
        return this.myRootPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTabbedCodePaneForFocus;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
    }

    @NotNull
    private static JPanel createPanelWithYAxisBoxLayout(@NotNull Border border) {
        JPanel sectionPanel = new JPanel();
        sectionPanel.setLayout(new BoxLayout(sectionPanel, 1));
        sectionPanel.setAlignmentX(0.0f);
        sectionPanel.setBackground(UIUtil.getTextFieldBackground());
        sectionPanel.setBorder(border);
        return sectionPanel;
    }

    @NotNull
    private static JPanel createPanelWithFlowLayout(@NotNull Border border) {
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.setAlignmentX(0.0f);
        panel2.setBackground(UIUtil.getTextFieldBackground());
        panel2.setBorder(border);
        return panel2;
    }

    @NotNull
    private static String breakIntoMultipleLines(@NotNull String text2, int maxLineLength) {
        String[] words = text2.split(" ");
        StringBuilder result2 = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (tmp.length() + word.length() > maxLineLength) {
                result2.append(tmp.toString().trim()).append(LINE_SEPARATOR);
                tmp.setLength(0);
            }
            tmp.append(word).append(" ");
        }
        return result2.append((CharSequence)tmp).toString().trim();
    }

    @NotNull
    private static String convertFloatArrayPairToString(@NotNull float[] array1, @NotNull float[] array2) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String arrayString1 = IntStream.range(0, array1.length).mapToObj(i2 -> decimalFormat.format(array1[i2])).collect(Collectors.joining(", ", "[", "]"));
        String arrayString2 = IntStream.range(0, array2.length).mapToObj(i2 -> decimalFormat.format(array2[i2])).collect(Collectors.joining(", ", "[", "]"));
        String separator = " /" + (array1.length >= 3 || array2.length >= 3 ? LINE_SEPARATOR : " ");
        return arrayString1 + separator + arrayString2;
    }

    private static boolean isCellContentTypeHtml(TableModel tableModel2, int rowIndex, int columnIndex) {
        return ((String)tableModel2.getValueAt(rowIndex, columnIndex)).startsWith("<html>");
    }

    private class EditorFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private EditorFocusTraversalPolicy() {
        }

        @Override
        @Nullable
        public Component getComponentAfter(@NotNull Container aContainer, @NotNull Component aComponent) {
            if (aComponent == TfliteModelFileEditor.this.myTabbedCodePaneForFocus) {
                return TfliteModelFileEditor.this.myTabbedCodePaneForFocus.getSelectedComponent();
            }
            return TfliteModelFileEditor.this.myTabbedCodePaneForFocus;
        }

        @Override
        @Nullable
        public Component getComponentBefore(@NotNull Container aContainer, @NotNull Component aComponent) {
            if (aComponent == TfliteModelFileEditor.this.myTabbedCodePaneForFocus) {
                return TfliteModelFileEditor.this.myTabbedCodePaneForFocus.getSelectedComponent();
            }
            return TfliteModelFileEditor.this.myTabbedCodePaneForFocus;
        }

        @Override
        @Nullable
        public Component getFirstComponent(@NotNull Container aContainer) {
            return TfliteModelFileEditor.this.myTabbedCodePaneForFocus;
        }

        @Override
        @Nullable
        public Component getLastComponent(@NotNull Container aContainer) {
            if (TfliteModelFileEditor.this.myTabbedCodePaneForFocus != null) {
                return TfliteModelFileEditor.this.myTabbedCodePaneForFocus.getSelectedComponent();
            }
            return null;
        }

        @Override
        @Nullable
        public Component getDefaultComponent(@NotNull Container aContainer) {
            return TfliteModelFileEditor.this.myTabbedCodePaneForFocus;
        }
    }

    private static class UiStyleTracker {
        private Font myLabelFont = StartupUiUtil.getLabelFont();
        private boolean myUnderDarcula = StartupUiUtil.isUnderDarcula();

        private UiStyleTracker() {
        }

        private boolean isUiStyleChanged() {
            if (this.myLabelFont.equals(StartupUiUtil.getLabelFont()) && this.myUnderDarcula == StartupUiUtil.isUnderDarcula()) {
                return false;
            }
            this.myLabelFont = StartupUiUtil.getLabelFont();
            this.myUnderDarcula = StartupUiUtil.isUnderDarcula();
            return true;
        }
    }

    private static class TableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private TableHeaderCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component delegate2 = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (!(delegate2 instanceof JLabel)) {
                return delegate2;
            }
            JLabel label = (JLabel)delegate2;
            label.setHorizontalAlignment(2);
            label.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
            return label;
        }
    }

    private static class MetadataCellComponentProvider
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        @NotNull
        private final JTextPane myTextPane = new JTextPane();

        private MetadataCellComponentProvider() {
            this.myTextPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.myTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.myTextPane.setBackground(UIUtil.getTextFieldBackground());
            this.myTextPane.setEditable(false);
            this.myTextPane.setHighlighter(null);
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.configureTextPane(table2, row, column);
            return this.myTextPane;
        }

        @Override
        @NotNull
        public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, int row, int column) {
            this.configureTextPane(table2, row, column);
            return this.myTextPane;
        }

        @Override
        @Nullable
        public Object getCellEditorValue() {
            return null;
        }

        private void configureTextPane(@NotNull JTable table2, int row, int column) {
            this.myTextPane.setContentType(TfliteModelFileEditor.isCellContentTypeHtml(table2.getModel(), row, column) ? "text/html" : "text/plain");
            this.myTextPane.setText((String)table2.getValueAt(row, column));
            if (((MetadataTableModel)table2.getModel()).hasHeader()) {
                this.myTextPane.setBorder((Border)JBUI.Borders.empty((int)8, (int)8, (int)8, (int)0));
            } else {
                this.myTextPane.setBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)8, (int)40));
            }
        }
    }

    private static class MetadataTableModel
    extends AbstractTableModel {
        private final List<List<String>> myRowDataList;
        private final List<String> myHeaderData;

        private MetadataTableModel(@NotNull List<List<String>> rowDataList, @NotNull List<String> headerData) {
            this.myRowDataList = ContainerUtil.map(rowDataList, row -> ContainerUtil.map((Collection)row, cellValue -> URLUtil.URL_PATTERN.matcher((CharSequence)cellValue).find() ? HtmlUtils.plainTextToHtml(cellValue) : cellValue));
            this.myHeaderData = headerData;
        }

        @Override
        public int getRowCount() {
            return this.myRowDataList.size();
        }

        @Override
        public int getColumnCount() {
            return this.myRowDataList.get(0).size();
        }

        @Override
        public String getValueAt(int rowIndex, int columnIndex) {
            return this.myRowDataList.get(rowIndex).get(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return column < this.myHeaderData.size() ? this.myHeaderData.get(column) : super.getColumnName(column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return TfliteModelFileEditor.isCellContentTypeHtml(this, rowIndex, columnIndex);
        }

        private boolean hasHeader() {
            return !this.myHeaderData.isEmpty();
        }
    }
}

