/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.mlkit.MlModuleService;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.ProjectMlModelFileTracker;
import com.android.tools.idea.mlkit.lightpsi.LightModelClass;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class MlProjectService {
    private final Project myProject;
    private final CachedValue<Map<String, List<PsiClass>>> lightClassMap;

    public static MlProjectService getInstance(@NotNull Project project) {
        return (MlProjectService)ServiceManager.getService((Project)project, MlProjectService.class);
    }

    public MlProjectService(@NotNull Project project) {
        this.myProject = project;
        this.lightClassMap = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            HashMap<String, List> lightClassMap = new HashMap<String, List>();
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (!MlUtils.isMlModelBindingBuildFeatureEnabled(module2)) continue;
                for (LightModelClass lightModelClass : MlModuleService.getInstance(module2).getLightModelClassList()) {
                    lightClassMap.computeIfAbsent(lightModelClass.getName(), key -> new ArrayList()).add(lightModelClass);
                    for (PsiClass innerClass : lightModelClass.getInnerClasses()) {
                        lightClassMap.computeIfAbsent(innerClass.getName(), key -> new ArrayList()).add(innerClass);
                    }
                }
            }
            return CachedValueProvider.Result.create(lightClassMap, (Object[])new Object[]{ProjectMlModelFileTracker.getInstance(this.myProject), ModuleManager.getInstance((Project)project)});
        });
    }

    @NotNull
    public List<PsiClass> getLightClassListByClassName(@NotNull String className2) {
        return ((Map)this.lightClassMap.getValue()).getOrDefault(className2, Collections.emptyList());
    }

    @NotNull
    public Set<String> getAllClassNames() {
        return ((Map)this.lightClassMap.getValue()).keySet();
    }
}

