/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.mlkit.ModelInfo;
import com.google.common.hash.Hashing;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MlModelBindingEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"MODEL_METADATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/google/wireless/android/sdk/stats/MlModelBindingEvent$ModelMetadata;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getModelMetadata", "modelFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "logEvent", "", "eventType", "Lcom/google/wireless/android/sdk/stats/MlModelBindingEvent$EventType;", "modelInfo", "Lcom/android/tools/mlkit/ModelInfo;", "intellij.android.mlkit"})
@JvmName(name="LoggingUtils")
public final class LoggingUtils {
    private static final Key<MlModelBindingEvent.ModelMetadata> MODEL_METADATA_KEY = Key.create((String)"model_metadata");

    public static final void logEvent(@NotNull MlModelBindingEvent.EventType eventType, @NotNull ModelInfo modelInfo) {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ML_MODEL_BINDING).setMlModelBindingEvent(MlModelBindingEvent.newBuilder().setEventType(eventType).addModelMetadatas(MlModelBindingEvent.ModelMetadata.newBuilder().setIsValidModel(true).setHasMetadata(modelInfo.isMetadataExisted()).setFileSize(modelInfo.getModelSize()).setFileHash(modelInfo.getModelHash()))));
    }

    public static final void logEvent(@NotNull MlModelBindingEvent.EventType eventType, @NotNull VirtualFile modelFile) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(eventType, modelFile){
            final /* synthetic */ MlModelBindingEvent.EventType $eventType;
            final /* synthetic */ VirtualFile $modelFile;

            public final void run() {
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ML_MODEL_BINDING).setMlModelBindingEvent(MlModelBindingEvent.newBuilder().setEventType(this.$eventType).addModelMetadatas(LoggingUtils.access$getModelMetadata(this.$modelFile))));
            }
            {
                this.$eventType = eventType;
                this.$modelFile = virtualFile;
            }
        });
    }

    private static final MlModelBindingEvent.ModelMetadata getModelMetadata(VirtualFile modelFile) {
        MlModelBindingEvent.ModelMetadata modelMetadata = (MlModelBindingEvent.ModelMetadata)modelFile.getUserData(MODEL_METADATA_KEY);
        if (modelMetadata != null) {
            return modelMetadata;
        }
        MlModelBindingEvent.ModelMetadata.Builder metadataBuilder = MlModelBindingEvent.ModelMetadata.newBuilder().setFileSize(modelFile.getLength());
        if (modelFile.getLength() <= 0xC800000L) {
            try {
                byte[] bytes = FilesKt.readBytes((File)VfsUtilCore.virtualToIoFile((VirtualFile)modelFile));
                metadataBuilder.setFileHash(Hashing.sha256().hashBytes(bytes).toString());
                ModelInfo modelInfo = ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(bytes));
                metadataBuilder.setIsValidModel(true);
                metadataBuilder.setHasMetadata(modelInfo.isMetadataExisted());
            }
            catch (Exception e) {
                metadataBuilder.setIsValidModel(false);
            }
        }
        MlModelBindingEvent.ModelMetadata metadata = metadataBuilder.build();
        modelFile.putUserData(MODEL_METADATA_KEY, (Object)metadata);
        return metadata;
    }

    public static final /* synthetic */ MlModelBindingEvent.ModelMetadata access$getModelMetadata(VirtualFile modelFile) {
        return LoggingUtils.getModelMetadata(modelFile);
    }
}

