/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.utils;

import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/material/icons/utils/MaterialIconsUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MATERIAL_ICONS_PATH", "", "METADATA_FILE_NAME", "getIconsSdkTargetPath", "Ljava/io/File;", "getMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "url", "Ljava/net/URL;", "hasMetadataFileInSdkPath", "", "toDirFormat", "intellij.android.core"})
public final class MaterialIconsUtils {
    private static final Logger LOG;
    @NotNull
    public static final String MATERIAL_ICONS_PATH = "images/material/icons/";
    @NotNull
    public static final String METADATA_FILE_NAME = "icons_metadata.txt";
    public static final MaterialIconsUtils INSTANCE;

    @NotNull
    public final String toDirFormat(@NotNull String $this$toDirFormat) {
        String string = $this$toDirFormat;
        Locale locale = Locale.US;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        return StringsKt.replace$default((String)string4, (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    @Nullable
    public final File getIconsSdkTargetPath() {
        File file2 = AndroidSdks.getInstance().tryToChooseSdkHandler().getLocation();
        if (file2 == null) {
            return null;
        }
        File sdkHome = file2;
        File iconsFolder = new File(sdkHome, "icons");
        File file3 = new File(iconsFolder, "material");
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file3;
        boolean bl3 = false;
        $this$apply.mkdirs();
        return file3;
    }

    public final boolean hasMetadataFileInSdkPath() {
        File iconsSdkPath = this.getIconsSdkTargetPath();
        return iconsSdkPath != null && FilesKt.resolve((File)iconsSdkPath, (String)METADATA_FILE_NAME).exists();
    }

    @Nullable
    public final MaterialIconsMetadata getMetadata(@NotNull URL url) {
        try {
            return MaterialIconsMetadata.Companion.parse(new BufferedReader(new InputStreamReader(url.openStream())));
        }
        catch (Exception e) {
            LOG.error("Error obtaining metadata file", (Throwable)e);
            return null;
        }
    }

    private MaterialIconsUtils() {
    }

    static {
        MaterialIconsUtils materialIconsUtils;
        INSTANCE = materialIconsUtils = new MaterialIconsUtils();
        LOG = Logger.getInstance(materialIconsUtils.getClass());
    }
}

