/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.FormattedLogcatReceiver;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

final class ViewListener
extends FormattedLogcatReceiver {
    private final AndroidLogcatView myView;
    private final Alarm myAlarm;

    ViewListener(@NotNull AndroidLogcatFormatter formatter, @NotNull AndroidLogcatView view) {
        super(formatter);
        this.myView = view;
        this.myAlarm = new Alarm(view.parentDisposable);
    }

    @Override
    void receiveFormattedLogLine(@NotNull String line2) {
        this.myView.getLogConsole().addLogLine(line2);
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ((ActionToolbar)this.myView.getToolbar()).updateActionsImmediately(), 50);
    }

    @Override
    public void onCleared() {
        this.myView.getLogFilterModel().beginRejectingOldMessages();
        AndroidLogConsole console = this.myView.getLogConsole();
        if (console.getConsole() == null) {
            return;
        }
        console.clear();
    }
}

