/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.DeviceAndSearchPanel;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class LogcatPanel
extends JBLoadingPanel {
    private final DevicePanel myDevicePanel;
    private final AndroidLogcatView myLogcatView;

    public LogcatPanel(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        super((LayoutManager)new BorderLayout(), (Disposable)project);
        DeviceContext context = new DeviceContext();
        this.myDevicePanel = new DevicePanel(project, context);
        this.myLogcatView = new AndroidLogcatView(project, context, toolWindow.getDisposable());
        this.add(new DeviceAndSearchPanel(this.myDevicePanel, this.myLogcatView), "North");
        this.add(this.createCenterComponent(project), "Center");
    }

    @NotNull
    private Component createCenterComponent(@NotNull Project project) {
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create("Android", "Logcat", "Logcat", (Disposable)project);
        Content content2 = ui.createContent("Android Logcat", (JComponent)this.myLogcatView.getContentPanel(), "logcat", StudioIcons.Shell.ToolWindows.LOGCAT, null);
        content2.setCloseable(false);
        content2.setPreferredFocusableComponent(this.myDevicePanel.getDeviceComboBox());
        content2.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)this.myLogcatView);
        ui.addContent(content2, 0, PlaceInGrid.center, false);
        new LogcatCloseListener(content2, project);
        return ui.getComponent();
    }

    @NotNull
    public DevicePanel getDevicePanel() {
        return this.myDevicePanel;
    }

    @NotNull
    public AndroidLogcatView getLogcatView() {
        return this.myLogcatView;
    }

    private static class LogcatCloseListener
    extends BaseContentCloseListener {
        LogcatCloseListener(@NotNull Content content2, @NotNull Project project) {
            super(content2, project);
        }

        protected void disposeContent(@NotNull Content content2) {
        }

        protected boolean closeQuery(@NotNull Content content2, boolean projectClosing2) {
            return true;
        }
    }
}

