/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.AndroidLogConsole;
import com.intellij.execution.actions.ClearConsoleAction;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.ArrayList;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class LogcatConsoleActionsPostProcessor
extends ConsoleActionsPostProcessor {
    @NotNull
    public AnAction[] postProcess(@NotNull ConsoleView console, @NotNull AnAction[] actions2) {
        if (!(console instanceof ConsoleViewImpl)) {
            return actions2;
        }
        ConsoleViewImpl consoleImpl = (ConsoleViewImpl)console;
        if (!(consoleImpl.getParent() instanceof AndroidLogConsole)) {
            return actions2;
        }
        return LogcatConsoleActionsPostProcessor.processActions((AndroidLogConsole)((Object)consoleImpl.getParent()), actions2);
    }

    @NotNull
    public AnAction[] postProcessPopupActions(@NotNull ConsoleView console, @NotNull AnAction[] actions2) {
        if (!(console instanceof ConsoleViewImpl)) {
            return actions2;
        }
        ConsoleViewImpl consoleImpl = (ConsoleViewImpl)console;
        if (!(consoleImpl.getParent() instanceof AndroidLogConsole)) {
            return actions2;
        }
        return LogcatConsoleActionsPostProcessor.processPopupActions((AndroidLogConsole)((Object)consoleImpl.getParent()), actions2);
    }

    @NotNull
    private static AnAction[] processActions(@NotNull AndroidLogConsole console, @NotNull AnAction[] actions2) {
        ArrayList<Object> actionList = new ArrayList<Object>(actions2.length);
        AnAction scrollToEndAction = null;
        for (AnAction a : actions2) {
            if (a instanceof ClearConsoleAction) continue;
            if (a instanceof ScrollToTheEndToolbarAction) {
                String message2 = "Scroll to the end. Clicking on a particular line stops scrolling and keeps that line visible.";
                a.getTemplatePresentation().setDescription(message2);
                a.getTemplatePresentation().setText(message2);
                scrollToEndAction = a;
                continue;
            }
            actionList.add(a);
        }
        if (scrollToEndAction != null) {
            actionList.add(0, scrollToEndAction);
        }
        actionList.add(0, (Object)new ClearLogCatAction(console));
        return actionList.toArray(AnAction.EMPTY_ARRAY);
    }

    @NotNull
    private static AnAction[] processPopupActions(@NotNull AndroidLogConsole console, @NotNull AnAction[] actions2) {
        AnAction[] resultActions = new AnAction[actions2.length];
        for (int i2 = 0; i2 < actions2.length; ++i2) {
            resultActions[i2] = actions2[i2] instanceof ClearConsoleAction ? new ClearLogCatAction(console) : actions2[i2];
        }
        return resultActions;
    }

    private static final class ClearLogCatAction
    extends DumbAwareAction {
        private final AndroidLogConsole myConsole;

        private ClearLogCatAction(@NotNull AndroidLogConsole console) {
            super(AndroidBundle.message("android.logcat.clear.log.action.title", new Object[0]), AndroidBundle.message("android.logcat.clear.log.action.tooltip", new Object[0]), AllIcons.Actions.GC);
            this.myConsole = console;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null;
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor2 != null && editor2.getDocument().getTextLength() == 0) {
                enabled = false;
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myConsole.clearLogcat();
        }
    }
}

