/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatService;
import org.jetbrains.annotations.NotNull;

abstract class FormattedLogcatReceiver
implements AndroidLogcatService.LogcatListener {
    private final AndroidLogcatFormatter myFormatter;
    private LogCatHeader myActiveHeader;

    FormattedLogcatReceiver(@NotNull AndroidLogcatFormatter formatter) {
        this.myFormatter = formatter;
    }

    @Override
    public final void onLogLineReceived(@NotNull LogCatMessage line2) {
        LogCatHeader header = line2.getHeader();
        if (this.myActiveHeader != header) {
            this.myActiveHeader = header;
            this.receiveFormattedLogLine(this.myFormatter.formatMessageFull(header, line2.getMessage()));
        } else {
            String message2 = AndroidLogcatFormatter.formatContinuation(line2.getMessage());
            this.receiveFormattedLogLine(message2);
        }
    }

    abstract void receiveFormattedLogLine(@NotNull String var1);
}

