/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.time.Instant;
import java.time.ZoneId;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

final class ConfigureLogcatHeaderDialog
extends DialogWrapper {
    private static final LogCatMessage SAMPLE = new LogCatMessage(new LogCatHeader(Log.LogLevel.INFO, 123, 456, "com.android.sample", "SampleTag", Instant.ofEpochMilli(1517955388555L)), "This is a sample message");
    private final ZoneId myTimeZone;
    private final AbstractButton myShowDateAndTimeCheckBox;
    private final AbstractButton myShowAsSecondsSinceEpochCheckBox;
    private final AbstractButton myShowProcessAndThreadIdsCheckBox;
    private final AbstractButton myShowPackageNameCheckBox;
    private final AbstractButton myShowTagCheckBox;
    private final JLabel mySampleLabel;

    ConfigureLogcatHeaderDialog(@NotNull Project project, @NotNull AndroidLogcatPreferences preferences, @NotNull ZoneId timeZone) {
        super(project, false, DialogWrapper.IdeModalityType.PROJECT);
        this.myTimeZone = timeZone;
        String format2 = preferences.LOGCAT_FORMAT_STRING;
        this.myShowDateAndTimeCheckBox = this.createShowDateAndTimeCheckBox(format2);
        this.myShowAsSecondsSinceEpochCheckBox = this.createCheckBox("Show as seconds since epoch", preferences.SHOW_AS_SECONDS_SINCE_EPOCH, 8);
        this.myShowProcessAndThreadIdsCheckBox = this.createCheckBox("Show process and thread IDs", format2.isEmpty() || format2.contains("%2$s"), 5);
        this.myShowPackageNameCheckBox = this.createCheckBox("Show package name", format2.isEmpty() || format2.contains("%3$s"), 13);
        this.myShowTagCheckBox = this.createCheckBox("Show tag", format2.isEmpty() || format2.contains("%5$s"), 7);
        this.mySampleLabel = this.createSampleLabel();
        this.init();
        this.setTitle(AndroidBundle.message("android.configure.logcat.header.title", new Object[0]));
    }

    @NotNull
    private AbstractButton createShowDateAndTimeCheckBox(@NotNull String format2) {
        JCheckBox checkBox = new JCheckBox("Show date and time", format2.isEmpty() || format2.contains("%1$s"));
        checkBox.setDisplayedMnemonicIndex(14);
        checkBox.addItemListener(event -> {
            this.myShowAsSecondsSinceEpochCheckBox.setVisible(this.myShowDateAndTimeCheckBox.isSelected());
            this.mySampleLabel.setText(this.formatSample());
        });
        return checkBox;
    }

    @NotNull
    private AbstractButton createCheckBox(@NotNull String text2, boolean selected, int displayedMnemonicIndex) {
        JCheckBox checkBox = new JCheckBox(text2, selected);
        checkBox.setDisplayedMnemonicIndex(displayedMnemonicIndex);
        checkBox.addItemListener(event -> this.mySampleLabel.setText(this.formatSample()));
        return checkBox;
    }

    @NotNull
    private JLabel createSampleLabel() {
        JLabel label = new JLabel(this.formatSample());
        label.setFont((Font)JBFont.create((Font)new Font("Monospaced", 0, 15)));
        return label;
    }

    @NotNull
    private String formatSample() {
        AndroidLogcatPreferences preferences = new AndroidLogcatPreferences();
        preferences.LOGCAT_FORMAT_STRING = this.getFormat();
        preferences.SHOW_AS_SECONDS_SINCE_EPOCH = this.myShowAsSecondsSinceEpochCheckBox.isSelected();
        return new AndroidLogcatFormatter(this.myTimeZone, preferences).formatMessage(SAMPLE);
    }

    @NotNull
    String getFormat() {
        boolean showDateAndTime = this.myShowDateAndTimeCheckBox.isSelected();
        boolean showProcessAndThreadIds = this.myShowProcessAndThreadIdsCheckBox.isSelected();
        boolean showPackageName = this.myShowPackageNameCheckBox.isSelected();
        boolean showTag = this.myShowTagCheckBox.isSelected();
        return showDateAndTime && showProcessAndThreadIds && showPackageName && showTag ? "" : AndroidLogcatFormatter.createCustomFormat(showDateAndTime, showProcessAndThreadIds, showPackageName, showTag);
    }

    @NotNull
    AbstractButton getShowDateAndTimeCheckBox() {
        return this.myShowDateAndTimeCheckBox;
    }

    @NotNull
    AbstractButton getShowAsSecondsSinceEpochCheckBox() {
        return this.myShowAsSecondsSinceEpochCheckBox;
    }

    @NotNull
    AbstractButton getShowProcessAndThreadIdsCheckBox() {
        return this.myShowProcessAndThreadIdsCheckBox;
    }

    @NotNull
    AbstractButton getShowPackageNameCheckBox() {
        return this.myShowPackageNameCheckBox;
    }

    @NotNull
    AbstractButton getShowTagCheckBox() {
        return this.myShowTagCheckBox;
    }

    @NotNull
    JLabel getSampleLabel() {
        return this.mySampleLabel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(null);
        GroupLayout layout2 = new GroupLayout(panel2);
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addComponent(this.myShowDateAndTimeCheckBox).addGroup(layout2.createSequentialGroup().addPreferredGap(this.myShowDateAndTimeCheckBox, this.myShowAsSecondsSinceEpochCheckBox, LayoutStyle.ComponentPlacement.INDENT).addComponent(this.myShowAsSecondsSinceEpochCheckBox)).addComponent(this.myShowProcessAndThreadIdsCheckBox).addComponent(this.myShowPackageNameCheckBox).addComponent(this.myShowTagCheckBox).addComponent(this.mySampleLabel);
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addComponent(this.myShowDateAndTimeCheckBox).addComponent(this.myShowAsSecondsSinceEpochCheckBox).addComponent(this.myShowProcessAndThreadIdsCheckBox).addComponent(this.myShowPackageNameCheckBox).addComponent(this.myShowTagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mySampleLabel);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        return panel2;
    }
}

