/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class AndroidLogConsole
extends LogConsoleBase {
    private final AndroidLogcatView myView;
    private final RegexFilterComponent myRegexFilterComponent = new RegexFilterComponent("LOG_FILTER_HISTORY", 5);
    private final AndroidLogcatPreferences myPreferences;

    AndroidLogConsole(@NotNull Project project, @NotNull AndroidLogFilterModel model2, @NotNull LogFormatter formatter, @NotNull AndroidLogcatView view) {
        super(project, null, "", false, (LogFilterModel)model2, GlobalSearchScope.allScope((Project)project), formatter);
        ConsoleView console = this.getConsole();
        if (console instanceof ConsoleViewImpl) {
            ConsoleViewImpl c = (ConsoleViewImpl)console;
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new AndroidLogcatView.MyRestartAction(view));
            c.addCustomConsoleAction((AnAction)new AndroidLogcatView.MyConfigureLogcatHeaderAction(view));
            DeviceContext context = view.getDeviceContext();
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new ScreenshotAction(project, context));
            c.addCustomConsoleAction((AnAction)new ScreenRecorderAction(project, context));
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new TerminateVMAction(context));
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new BrowserHelpAction("logcat", "http://developer.android.com/r/studio-ui/am-logcat.html"));
        }
        this.myView = view;
        this.myPreferences = AndroidLogcatPreferences.getInstance(project);
        this.myRegexFilterComponent.setFilter(this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER);
        this.myRegexFilterComponent.setIsRegex(this.myPreferences.TOOL_WINDOW_REGEXP_FILTER);
        this.myRegexFilterComponent.addRegexListener(filter2 -> {
            this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER = filter2.getFilter();
            this.myPreferences.TOOL_WINDOW_REGEXP_FILTER = filter2.isRegex();
            model2.updateCustomPattern(filter2.getPattern());
        });
    }

    public boolean isActive() {
        return this.myView.isActive();
    }

    public void clearLogcat() {
        IDevice device = this.myView.getSelectedDevice();
        if (device == null) {
            return;
        }
        AndroidLogcatService.getInstance().clearLogcat(device, this.myView.getProject());
    }

    @NotNull
    public Component getLogFilterComboBox() {
        JComponent component = this.getSearchComponent();
        assert (component != null);
        return component.getComponent(0);
    }

    @NotNull
    public Component getTextFilterComponent() {
        return this.myRegexFilterComponent;
    }

    public void addLogLine(@NotNull String line2) {
        super.addMessage(line2);
    }

    public void refresh() {
        this.onTextFilterChange();
    }
}

