/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000bH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/lint/RemoveSdkCheckFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "removeThen", "", "(Z)V", "getRemoveThen", "()Z", "setRemoveThen", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "findSdkConditional", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "start", "getFamilyName", "", "getName", "isApplicable", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "isVersionCheckConditional", "element", "intellij.android.core"})
public final class RemoveSdkCheckFix
implements LintIdeQuickFix {
    private boolean removeThen;

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        KtExpression keep;
        KtIfExpression ktIfExpression = this.findSdkConditional(startElement);
        if (ktIfExpression == null) {
            return;
        }
        KtIfExpression ifExpression = ktIfExpression;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(startElement)) {
            return;
        }
        KtExpression ktExpression = keep = this.removeThen ? ifExpression.getThen() : ifExpression.getElse();
        if (keep != null) {
            PsiElement psiElement = ifExpression.getParent();
            if (psiElement == null) {
                return;
            }
            PsiElement parent = psiElement;
            if (keep instanceof KtBlockExpression) {
                for (PsiElement child = ((KtBlockExpression)keep).getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof TreeElement && (Intrinsics.areEqual((Object)((TreeElement)child).getElementType(), (Object)KtTokens.RBRACE) || Intrinsics.areEqual((Object)((TreeElement)child).getElementType(), (Object)KtTokens.LBRACE))) continue;
                    parent.addBefore(child, (PsiElement)ifExpression);
                }
            } else {
                parent.addBefore((PsiElement)keep, (PsiElement)ifExpression);
            }
        }
        ifExpression.delete();
    }

    private final KtIfExpression findSdkConditional(PsiElement start2) {
        PsiElement current = start2;
        while (current != null) {
            PsiElement conditional;
            KtIfExpression next;
            if ((KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)current, KtIfExpression.class, (boolean)false) == null) {
                break;
            }
            KtExpression ktExpression = next.getCondition();
            if (!(ktExpression instanceof PsiElement)) {
                ktExpression = null;
            }
            if ((conditional = (PsiElement)ktExpression) != null && this.isVersionCheckConditional(conditional)) {
                return next;
            }
            current = next.getParent();
        }
        return null;
    }

    private final boolean isVersionCheckConditional(PsiElement element2) {
        return StringsKt.contains$default((CharSequence)element2.getText(), (CharSequence)"SDK_INT", (boolean)false, (int)2, null);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @NotNull
    public String getName() {
        return "Remove obsolete SDK version check";
    }

    @Nullable
    public String getFamilyName() {
        return "Remove obsolete SDK version checks";
    }

    public final boolean getRemoveThen() {
        return this.removeThen;
    }

    public final void setRemoveThen(boolean bl) {
        this.removeThen = bl;
    }

    public RemoveSdkCheckFix(boolean removeThen) {
        this.removeThen = removeThen;
    }
}

