/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.EditorUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0003J\b\u0010\u0014\u001a\u00020\u000fH\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/lint/GenerateMotionSceneFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "url", "Lcom/android/resources/ResourceUrl;", "(Lcom/android/resources/ResourceUrl;)V", "getUrl", "()Lcom/android/resources/ResourceUrl;", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "findFirstWidgetId", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "generateMotionSceneContent", "widgetId", "getName", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.core"})
public final class GenerateMotionSceneFix
implements LintIdeQuickFix {
    @NotNull
    private final ResourceUrl url;

    @NotNull
    public String getName() {
        return "Generate MotionScene file";
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)startElement);
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet facet2 = androidFacet;
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet2);
        return !appResources.getResources(ResourceNamespace.TODO(), ResourceType.XML).keySet().contains(this.url.name);
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = startElement.getProject();
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)startElement);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet2 = androidFacet;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Create MotionScene file", null, (Runnable)new Runnable(this, startElement, facet2, project){
            final /* synthetic */ GenerateMotionSceneFix this$0;
            final /* synthetic */ PsiElement $startElement;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ Project $project;

            public final void run() {
                try {
                    XmlTag motionTag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.$startElement, (Class[])new Class[]{XmlTag.class});
                    String string = GenerateMotionSceneFix.access$findFirstWidgetId(this.this$0, motionTag);
                    if (string == null) {
                        string = "widget";
                    }
                    String widgetId = string;
                    VirtualFile virtualFile = ResourceFolderManager.Companion.getInstance(this.$facet).getPrimaryFolder();
                    if (virtualFile == null) {
                        return;
                    }
                    VirtualFile primaryResourceDir = virtualFile;
                    VirtualFile xmlDir = AndroidUtils.createChildDirectoryIfNotExist(this.$project, primaryResourceDir, "xml");
                    VirtualFile resFile = xmlDir.createChildData((Object)this.$project, this.this$0.getUrl().name + ".xml");
                    VfsUtil.saveText((VirtualFile)resFile, (String)GenerateMotionSceneFix.access$generateMotionSceneContent(this.this$0, widgetId));
                    EditorUtil.reformatAndRearrange$default(this.$project, resFile, null, false, 12, null);
                    EditorUtil.openEditor(this.$project, resFile);
                    EditorUtil.selectEditor(this.$project, resFile);
                    XmlTag xmlTag = motionTag;
                    if (xmlTag != null) {
                        xmlTag.setAttribute("layoutDescription", "http://schemas.android.com/apk/res-auto", this.this$0.getUrl().toString());
                    }
                }
                catch (IOException ex) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "Failed to create file: %1$s";
                    Object[] objectArray = new Object[]{ex.getMessage()};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    String error = string2;
                    Messages.showErrorDialog((Project)this.$project, (String)error, (String)"Create MotionScene");
                }
            }
            {
                this.this$0 = generateMotionSceneFix;
                this.$startElement = psiElement;
                this.$facet = androidFacet;
                this.$project = project;
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String findFirstWidgetId(XmlTag tag) {
        Object object;
        block6: {
            block5: {
                Object v1;
                block4: {
                    void $this$mapTo$iv$iv;
                    object = tag;
                    if (tag == null || (object = object.getSubTags()) == null) break block5;
                    XmlTag[] $this$map$iv = object;
                    boolean $i$f$map = false;
                    Object object2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    Object t = $this$mapTo$iv$iv;
                    int n = ((void)t).length;
                    for (int j = 0; j < n; ++j) {
                        void it;
                        void item$iv$iv;
                        void var12_14 = item$iv$iv = t[j];
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                        collection2.add(string);
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    boolean bl = false;
                    object2 = iterable;
                    boolean bl2 = false;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        t = iterator.next();
                        String it = (String)t;
                        boolean bl3 = false;
                        CharSequence charSequence = it;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                if ((object = (String)v1) != null) break block6;
            }
            return null;
        }
        Object reference2 = object;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)reference2);
        return resourceUrl != null ? resourceUrl.name : null;
    }

    @Language(value="XML")
    private final String generateMotionSceneContent(String widgetId) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<MotionScene\n        xmlns:android=\"http://schemas.android.com/apk/res/android\"\n        xmlns:app=\"http://schemas.android.com/apk/res-auto\">\n\n  <ConstraintSet android:id=\"@+id/start\">\n      <Constraint android:id=\"@+id/" + widgetId + "\"/>\n  </ConstraintSet>\n\n  <ConstraintSet android:id=\"@+id/end\">\n      <Constraint android:id=\"@id/" + widgetId + "\"/>\n  </ConstraintSet>\n\n  <Transition\n      app:constraintSetStart=\"@+id/start\"\n      app:constraintSetEnd=\"@id/end\" />\n</MotionScene>\n";
    }

    @NotNull
    public final ResourceUrl getUrl() {
        return this.url;
    }

    public GenerateMotionSceneFix(@NotNull ResourceUrl url) {
        this.url = url;
    }

    public static final /* synthetic */ String access$findFirstWidgetId(GenerateMotionSceneFix $this, XmlTag tag) {
        return $this.findFirstWidgetId(tag);
    }

    public static final /* synthetic */ String access$generateMotionSceneContent(GenerateMotionSceneFix $this, String widgetId) {
        return $this.generateMotionSceneContent(widgetId);
    }
}

